/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.io.IFreePunktReader;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.Vector;

public class SystraKooReader
extends IFreePunktReader {
    public SystraKooReader(File file, LongHashList longHashList) {
        super(file, longHashList, null);
        this.punktStatus = -9;
    }

    public SystraKooReader(File file, LongHashList longHashList, IProgressViewer iProgressViewer) {
        super(file, longHashList, iProgressViewer);
        this.punktStatus = -9;
    }

    public SystraKooReader(File file, Vector vector) {
        super(file, vector, null);
        this.punktStatus = -9;
    }

    public SystraKooReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
        this.punktStatus = -9;
    }

    @Override
    protected Punkt lineToPunkt(String string) {
        if (string.length() < 60) {
            return null;
        }
        Punkt punkt = new Punkt();
        try {
            punkt.nr = Long.parseLong(string.substring(0, 15).trim());
            punkt.y = new Double(string.substring(15, 30).trim());
            punkt.x = new Double(string.substring(30, 45).trim());
            String string2 = string.substring(45, 60).trim();
            if (string2.length() > 0) {
                punkt.h = new Double(string2).floatValue();
                if (punkt.h == -1000.0f) {
                    punkt.h = 0.0f;
                }
            }
            if (string.length() > 60) {
                punkt.g = new Float(string.substring(60, 70).trim()).floatValue() / 100.0f;
                punkt.setPs(Integer.parseInt(string.substring(71, 72)) == 1 ? 1 : -2);
                string2 = string.substring(72, 82).trim();
                if (string2.length() > 0) {
                    punkt.t = new Double(string2).shortValue();
                }
                if ((string2 = string.substring(82, 92).trim()).length() > 0) {
                    punkt.a = (int)Math.rint(new Double(string2) * 10.0);
                }
                if ((string2 = string.substring(92, 102).trim()).length() > 0) {
                    punkt.b = (int)Math.rint(new Double(string2) * 10.0);
                }
            }
            if (string.length() > 160) {
                int n;
                PunktParameterALK punktParameterALK = new PunktParameterALK();
                string2 = string.substring(151, 155).trim();
                int n2 = n = string2.length() > 0 ? Integer.parseInt(string2) : 0;
                if (n > 9) {
                    punktParameterALK.setOska(n);
                } else if (n > 0) {
                    punktParameterALK.setPa(n);
                    punktParameterALK.setEb(Ebene.getDefaultEbene(punktParameterALK.getKafPa()));
                }
                string2 = string.substring(156, 160).trim();
                if (string2.length() > 0) {
                    punktParameterALK.setVa(Integer.parseInt(string2));
                }
                punkt.initParameter(punktParameterALK);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return punkt;
    }
}

