/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.Stat2;
import de.geocalc.kafplot.Stat4;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.ValueDataContainer;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.dat.SteuerDaten;
import de.geocalc.text.IFormat;
import de.geocalc.util.LongHashObject;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SystraOutReader
extends IDataReader {
    private static final boolean debug = true;
    private static final double ARC = 1.5707963267948964E-5;
    private static final int VOID = 0;
    private static final int BLOCK_PUNKTE_ALT = 1;
    private static final int BLOCK_PUNKTE_REF = 2;
    private static final int BLOCK_PUNKTE_NEU = 3;
    private static final int BLOCK_PUNKTE_ERG = 4;
    private static final int BLOCK_PUNKTE_VGL = 9;
    private static final int BLOCK_MES_ORTHO = 20;
    private static final int BLOCK_MES_STRECKE = 22;
    private static final int BLOCK_MES_POLARR = 23;
    private static final int BLOCK_MES_POLARS = 24;
    private static final int BLOCK_BED_GERADE = 31;
    private static final int BLOCK_BED_RECHTW = 32;
    private static final int BLOCK_SYSPARAM34 = 41;
    private static final int BLOCK_SYSPARAM56 = 42;
    private static final int BLOCK_PUNKTIDENT = 45;
    private static final int BLOCK_VERSCH = 51;
    private static final int HAS_NOT_VALUE = -1;
    private static final int HAS_VALUE = 0;
    private static final int FEST = 1;
    private static final int NOT_CONTROL = 2;
    private static final int NOT_BEOB = 3;
    private static final int ELIMINIERT = 8;
    private static final int VERWORFEN = 9;
    private static final int DURCHFLUCHTUNG = 11;
    private static final int PMA = 12;
    private static final int LMA = 13;
    private static String S_FF = "fest";
    private static String S_NC = "unkontrolliert";
    private static String S_NB = "nicht beobachtet";
    private static String S_EL = "eliminiert";
    private static String S_VW = "verworfen";
    private static String S_M_DF = "Durchfluchtung";
    private static String S_M_PA = "Parallele mit Abstand";
    private static String S_M_LP = "Abstand Punkt-Linie";
    private static String KENN_BLOCK_PUNKTE_ALT = " Eingelesene Referenzpunkte";
    private static String KENN_BLOCK_PUNKTE_REF = " Referenzkoordinaten";
    private static String KENN_BLOCK_PUNKTE_ERG = " Ausgeglichene Koordinaten der Referenzpunkte";
    private static String KENN_BLOCK_PUNKTE_NEU = " Ausgeglichene Koordinaten der Neupunkte";
    private static String KENN_BLOCK_PUNKTE_VGL = " Koordinatenvergleich";
    private static String KENN_BLOCK_MES_POLARR = " Richtungen";
    private static String KENN_BLOCK_MES_POLARS = " Polarstrecken";
    private static String KENN_BLOCK_MES_ORTHO = " Orthogonale Messwerte";
    private static String KENN_BLOCK_MES_STRECKE = " Strecken";
    private static String KENN_BLOCK_BED_RECHTW = " Rechtwinkelbedingungen";
    private static String KENN_BLOCK_BED_GERADE = " Geradenbedingungen";
    private static String KENN_BLOCK_SYSPARAM34 = " Systemparameter  (3,4-Parameter-Transformation)";
    private static String KENN_BLOCK_SYSPARAM56 = " Systemparameter  (5,6-Parameter-Transformation)";
    private static String KENN_BLOCK_PUNKTIDENT = " Punktidentit\u00e4ten";
    private static String KENN_BLOCK_VERSCH = " Verschiebungsvektoren der Referenz- und Verk";
    private static final char NEW_PAGE = '\f';
    static int SKIP_PAGES = 4;
    static int PAGE_HEADER = 1;
    static int ID0 = 0;
    static int ID1 = 6;
    static int PA0 = 6;
    static int PA1 = 23;
    static int PA2 = 38;
    static int PA3 = 53;
    static int PA4 = 68;
    static int PA5 = 81;
    static int PA6 = 47;
    static int PR0 = 6;
    static int PR1 = 23;
    static int PR2 = 31;
    static int PR3 = 41;
    static int PR4 = 47;
    static int PR5 = 54;
    static int PR6 = 60;
    static int PR7 = 63;
    static int PR8 = 73;
    static int PR9 = 79;
    static int PR10 = 86;
    static int PR11 = 92;
    static int PE0 = 6;
    static int PE1 = 23;
    static int PE2 = 38;
    static int PE3 = 53;
    static int PE4 = 76;
    static int PE5 = 84;
    static int PE6 = 92;
    static int PE7 = 100;
    static int PE8 = 108;
    static int PE9 = 116;
    static int PE10 = 119;
    static int PN0 = 6;
    static int PN1 = 23;
    static int PN2 = 38;
    static int PN3 = 53;
    static int PN4 = 76;
    static int PN5 = 84;
    static int PN6 = 92;
    static int PN7 = 100;
    static int PN8 = 108;
    static int PN9 = 116;
    static int PN10 = 119;
    static int MO0 = 6;
    static int MO1 = 9;
    static int MO2 = 23;
    static int MO3 = 40;
    static int MO4 = 50;
    static int MO5 = 56;
    static int MO6 = 63;
    static int MO7 = 69;
    static int MO8 = 76;
    static int MO9 = 82;
    static int MO10 = 85;
    static int MO11 = 95;
    static int MO12 = 101;
    static int MO13 = 108;
    static int MO14 = 114;
    static int MO15 = 121;
    static int MO16 = 127;
    static int MO17 = 130;
    static int MS0 = 6;
    static int MS1 = 23;
    static int MS2 = 40;
    static int MS3 = 50;
    static int MS4 = 56;
    static int MS5 = 63;
    static int MS6 = 69;
    static int MS7 = 76;
    static int MS8 = 82;
    static int MS9 = 85;
    static int MS10 = 95;
    static int MS11 = 135;
    static int MS12 = 150;
    static int MS13 = 168;
    static int MR0 = 6;
    static int MR1 = 23;
    static int MR2 = 40;
    static int MR3 = 57;
    static int MR4 = 67;
    static int MR5 = 73;
    static int MR6 = 80;
    static int MR7 = 86;
    static int MR8 = 93;
    static int MR9 = 99;
    static int MR10 = 102;
    static int MR11 = 110;
    static int MR12 = 125;
    static int MP0 = 6;
    static int MP1 = 23;
    static int MP2 = 40;
    static int MP3 = 50;
    static int MP4 = 56;
    static int MP5 = 63;
    static int MP6 = 69;
    static int MP7 = 76;
    static int MP8 = 82;
    static int MP9 = 85;
    static int MP10 = 95;
    static int MP11 = 135;
    static int MP12 = 150;
    static int MP13 = 168;
    static int SD0 = 6;
    static int SD1 = 9;
    static int SD2 = 23;
    static int SD3 = 25;
    static int SD4 = 38;
    static int SD5 = 51;
    static int SD6 = 65;
    static int SD7 = 79;
    static int SD8 = 99;
    static int SF0 = 6;
    static int SF1 = 9;
    static int SF2 = 23;
    static int SF3 = 25;
    static int SF4 = 38;
    static int SF5 = 51;
    static int SF6 = 65;
    static int SF7 = 79;
    static int SF8 = 99;
    static int BR0 = 6;
    static int BR1 = 25;
    static int BR2 = 42;
    static int BR3 = 59;
    static int BR4 = 68;
    static int BR5 = 77;
    static int BR6 = 83;
    static int BR7 = 90;
    static int BR8 = 96;
    static int BR9 = 126;
    static int BR10 = 169;
    static int BG0 = 6;
    static int BG1 = 25;
    static int BG2 = 42;
    static int BG3 = 59;
    static int BG4 = 68;
    static int BG5 = 77;
    static int BG6 = 83;
    static int BG7 = 90;
    static int BG8 = 96;
    static int BG9 = 126;
    static int BG10 = 169;
    static int TV0 = 6;
    static int TV1 = 9;
    static int TV2 = 23;
    static int TV3 = 40;
    static int TV4 = 50;
    static int TV5 = 60;
    static int TV6 = 70;
    static int TV7 = 80;
    private DataBase db = null;
    private int version = 0;
    private int readErrCount = 0;
    private int ordErrCount = 0;
    private LineNumberReader reader = null;
    private Riss riss = null;
    private Hashtable polarSRisse = new Hashtable();
    private Hashtable polarRisse = new Hashtable();
    private Vector polarList = new Vector();
    private Hashtable mesRisse = new Hashtable();
    private Vector mesList = new Vector();
    private Hashtable orthoRisse = new Hashtable();
    private Vector orthoList = new Vector();
    private Hashtable bedRisse = new Hashtable();
    private Vector bedList = new Vector();
    private Hashtable systeme = new Hashtable();
    private Hashtable systemePMA = new Hashtable();
    private Hashtable systemeLMA = new Hashtable();
    private Hashtable systemeRK = new Hashtable();
    private Hashtable P = new Hashtable();
    private long newNr = 0L;

    public SystraOutReader(File file, DataBase dataBase) {
        this(file, dataBase, null);
    }

    public SystraOutReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.db = dataBase;
        if (DataBase.steuerDaten == null) {
            DataBase.steuerDaten = new SteuerDaten("AutoCreate");
        }
    }

    public int getBlock(String string) {
        if (string.startsWith(KENN_BLOCK_PUNKTE_ALT)) {
            return 1;
        }
        if (string.startsWith(KENN_BLOCK_PUNKTE_REF)) {
            return 2;
        }
        if (string.startsWith(KENN_BLOCK_PUNKTE_ERG)) {
            return 4;
        }
        if (string.startsWith(KENN_BLOCK_PUNKTE_NEU)) {
            return 3;
        }
        if (string.startsWith(KENN_BLOCK_PUNKTE_VGL)) {
            return 9;
        }
        if (string.startsWith(KENN_BLOCK_MES_POLARR)) {
            return 23;
        }
        if (string.startsWith(KENN_BLOCK_MES_POLARS)) {
            return 24;
        }
        if (string.startsWith(KENN_BLOCK_MES_ORTHO)) {
            return 20;
        }
        if (string.startsWith(KENN_BLOCK_MES_STRECKE)) {
            return 22;
        }
        if (string.startsWith(KENN_BLOCK_BED_GERADE)) {
            return 31;
        }
        if (string.startsWith(KENN_BLOCK_BED_RECHTW)) {
            return 32;
        }
        if (string.startsWith(KENN_BLOCK_SYSPARAM34)) {
            return 41;
        }
        if (string.startsWith(KENN_BLOCK_SYSPARAM56)) {
            return 42;
        }
        if (string.startsWith(KENN_BLOCK_PUNKTIDENT)) {
            return 45;
        }
        if (string.startsWith(KENN_BLOCK_VERSCH)) {
            return 51;
        }
        return 0;
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        int n = 0;
        String string = null;
        try {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = SKIP_PAGES;
            this.reader = this.createReader();
            long l = 0L;
            while ((string = this.reader.readLine()) != null) {
                int n6 = string.length();
                l += (long)(n6 + 1);
                if (n6 > 0 && string.charAt(0) == '\f') {
                    n2 = 0;
                    ++n3;
                    --n5;
                    continue;
                }
                ++n2;
                if (n5 > 0) continue;
                if (n4 > 0) {
                    --n4;
                    continue;
                }
                if (n6 >= ID1) {
                    if (this.isDataLine(string, n)) {
                        try {
                            int n7;
                            int n8 = n7 = string.charAt(ID1 - 1) == ' ' ? 0 : Integer.parseInt(string.substring(ID0, ID1).trim());
                            if (n == 1) {
                                var11_14 = this.p(string, PA0, PA1);
                                ((Punkt)var11_14).y = this.d(string, PA1, PA2);
                                ((Punkt)var11_14).x = this.d(string, PA2, PA3);
                                ((Punkt)var11_14).h = (float)this.d(string, PA3, PA4);
                                if (((Punkt)var11_14).h == -1000.0f) {
                                    ((Punkt)var11_14).h = 0.0f;
                                }
                                ((Punkt)var11_14).g = (float)(this.d(string, PA4, PA5) / 100.0);
                                ((Punkt)var11_14).setPs(((Punkt)var11_14).g == 0.0f ? 1 : 2);
                            } else if (n == 2) {
                                var11_14 = this.p(string, PR0, PR1);
                                var12_15 = this.getState(string, PR3, PR6);
                                if (var12_15 == 1) continue;
                                int n9 = this.getState(string, PR8, PR11);
                                Stat2 stat2 = new Stat2();
                                ((Punkt)var11_14).setStatistik(stat2);
                                ((Punkt)var11_14).dy = this.f(string, PR2, PR3) * 0.01f;
                                ((Stat)stat2).setV(1, this.s(string, PR2, PR3, 10.0));
                                ((Stat)stat2).setSaV(1, (short)Math.rint((double)((Punkt)var11_14).g * 1000.0));
                                if (var12_15 == 0) {
                                    ((Stat)stat2).setEv(1, this.s(string, PR3, PR4, 1.0));
                                    ((Stat)stat2).setGf(1, this.s(string, PR4, PR5, 10.0));
                                    ((Stat)stat2).setNv(1, this.s(string, PR5, PR6, 10.0));
                                }
                                ((Punkt)var11_14).dx = this.f(string, PR7, PR8) * 0.01f;
                                ((Stat)stat2).setV(2, this.s(string, PR7, PR8, 10.0));
                                ((Stat)stat2).setSaV(2, (short)Math.rint((double)((Punkt)var11_14).g * 1000.0));
                                if (n9 == 0) {
                                    ((Stat)stat2).setEv(2, this.s(string, PR8, PR9, 1.0));
                                    ((Stat)stat2).setGf(2, this.s(string, PR9, PR10, 10.0));
                                    ((Stat)stat2).setNv(2, this.s(string, PR10, PR11, 10.0));
                                }
                            } else if (n == 4) {
                                var11_14 = this.p(string, PE0, PE1);
                                ((Punkt)var11_14).y = this.d(string, PE1, PE2);
                                ((Punkt)var11_14).x = this.d(string, PE2, PE3);
                                ((Punkt)var11_14).t = this.s(string, PE3, PE4, 1.0);
                                ((Punkt)var11_14).a = this.i(string, PE4, PE5, 10.0);
                                ((Punkt)var11_14).b = this.i(string, PE5, PE6, 10.0);
                            } else if (n == 3) {
                                var11_14 = this.p(string, PN0, PN1);
                                ((Punkt)var11_14).y = this.d(string, PN1, PN2);
                                ((Punkt)var11_14).x = this.d(string, PN2, PN3);
                                ((Punkt)var11_14).t = this.s(string, PN3, PN4, 1.0);
                                ((Punkt)var11_14).a = this.i(string, PN4, PN5, 10.0);
                                ((Punkt)var11_14).b = this.i(string, PN5, PN6, 10.0);
                            } else if (n != 9) {
                                if (n == 23) {
                                    var11_14 = new Messung(230);
                                    Stat2 stat2 = new Stat2();
                                    ((Messung)var11_14).ps = this.p(string, MR0, MR1);
                                    String string2 = this.t(string, MR1, MR2).trim();
                                    ((Messung)var11_14).pz = this.p(string, MR2, MR3);
                                    boolean bl = false;
                                    var15_38 = this.getState(string, MR3, MR9);
                                    ((Messung)var11_14).l1 = this.d(string, MR3, MR4);
                                    double d = this.d(string, MR11, MR12) * 1000.0;
                                    ((Stat)stat2).setSaV(1, this.s(string, MR4, MR5, d, true));
                                    ((Stat)stat2).setV(1, this.s(string, MR5, MR6, d, true));
                                    ((Stat)stat2).setEv(1, this.s(string, MR6, MR7, 1.0));
                                    ((Stat)stat2).setGf(1, this.s(string, MR7, MR8, d, true));
                                    ((Stat)stat2).setNv(1, this.s(string, MR8, MR9, 10.0));
                                    ((Messung)var11_14).setStatistik(stat2);
                                    ((Messung)var11_14).setWerteBelegung(1);
                                    this.getPolarRiss(string2).addElement(var11_14);
                                } else if (n == 24) {
                                    var11_14 = new Messung(230);
                                    Stat2 stat2 = new Stat2();
                                    ((Messung)var11_14).ps = this.p(string, MP0, MP1);
                                    ((Messung)var11_14).pz = this.p(string, MP1, MP2);
                                    ((Messung)var11_14).l2 = this.d(string, MP2, MP3);
                                    int n10 = this.getState(string, MP3, MP8);
                                    if (n10 != 8 && n10 != 9) {
                                        ((Stat)stat2).setSaV(2, this.s(string, MP3, MP4, 10.0));
                                        ((Stat)stat2).setV(2, this.s(string, MP4, MP5, 10.0));
                                        if (n10 == 0) {
                                            ((Stat)stat2).setEv(2, this.s(string, MP5, MP6, 1.0));
                                            ((Stat)stat2).setGf(2, this.s(string, MP6, MP7, 10.0));
                                            ((Stat)stat2).setNv(2, this.s(string, MP7, MP8, 10.0));
                                        }
                                    }
                                    String string3 = null;
                                    if (n6 >= MP12) {
                                        string3 = this.t(string, MP12, MP13);
                                    }
                                    ((Messung)var11_14).setWerteBelegung(2);
                                    ((Messung)var11_14).setStatistik(stat2);
                                    this.getPolarSRiss(string3).addElement(var11_14);
                                } else if (n == 22) {
                                    var11_14 = new Messung(220);
                                    Stat stat = new Stat();
                                    ((Messung)var11_14).ps = this.p(string, MS0, MS1);
                                    ((Messung)var11_14).pz = this.p(string, MS1, MS2);
                                    ((Messung)var11_14).l1 = this.d(string, MS2, MS3);
                                    int n11 = this.getState(string, MS3, MS8);
                                    if (n11 != 8 && n11 != 9) {
                                        stat.setSaV(1, this.s(string, MS3, MS4, 10.0));
                                        stat.setV(1, this.s(string, MS4, MS5, 10.0));
                                        if (n11 == 0) {
                                            stat.setEv(1, this.s(string, MS5, MS6, 1.0));
                                            stat.setGf(1, this.s(string, MS6, MS7, 10.0));
                                            stat.setNv(1, this.s(string, MS7, MS8, 10.0));
                                        }
                                    }
                                    String string4 = null;
                                    if (n6 >= MS12) {
                                        string4 = this.t(string, MS11, MS12);
                                    }
                                    ((Messung)var11_14).setWerteBelegung(1);
                                    ((Messung)var11_14).setStatistik(stat);
                                    this.getMesRiss(string4).addElement(var11_14);
                                } else if (n == 20) {
                                    var11_14 = new Messung(200);
                                    String string5 = this.t(string, MO1, MO2).trim();
                                    Stat4 stat4 = new Stat4();
                                    ((Messung)var11_14).setStatistik(stat4);
                                    ((Messung)var11_14).ps = this.p(string, MO2, MO3);
                                    int n12 = 0;
                                    var15_38 = this.getState(string, MO3, MO9);
                                    if (var15_38 == 12) {
                                        this.systemePMA.put(string5, string5);
                                    } else if (var15_38 == 13) {
                                        this.systemeLMA.put(string5, string5);
                                    } else if (var15_38 != 3 && var15_38 != 11) {
                                        ++n12;
                                        ((Messung)var11_14).l1 = this.d(string, MO3, MO4);
                                        stat4.setSaV(1, this.s(string, MO4, MO5, 10.0));
                                        stat4.setV(1, this.s(string, MO5, MO6, 10.0));
                                        if (var15_38 == 0) {
                                            stat4.setEv(1, this.s(string, MO6, MO7, 1.0));
                                            stat4.setGf(1, this.s(string, MO7, MO8, 10.0));
                                            stat4.setNv(1, this.s(string, MO8, MO9, 10.0));
                                        }
                                    }
                                    int n13 = this.getState(string, MO10, MO16);
                                    if (n13 != 3) {
                                        if (var15_38 != 11) {
                                            n12 += 2;
                                        }
                                        ((Messung)var11_14).l2 = this.d(string, MO10, MO11);
                                        stat4.setSaV(3, this.s(string, MO11, MO12, 10.0));
                                        stat4.setV(3, this.s(string, MO12, MO13, 10.0));
                                        if (n13 == 0) {
                                            stat4.setEv(3, this.s(string, MO13, MO14, 1.0));
                                            stat4.setGf(3, this.s(string, MO14, MO15, 10.0));
                                            stat4.setNv(3, this.s(string, MO15, MO16, 10.0));
                                        }
                                    }
                                    ((Messung)var11_14).setWerteBelegung(n12);
                                    this.getOrthoRiss(string5).addElement(var11_14);
                                } else if (n == 41) {
                                    var11_14 = this.t(string, SD1, SD2).trim();
                                    var12_15 = n6 > SD8 && string.charAt(SD8 - 1) != ' ' ? 1 : 0;
                                    TrafoSystem trafoSystem = new TrafoSystem(var12_15 != 0 ? 8 : 9);
                                    trafoSystem.setName((String)var11_14);
                                    trafoSystem.setParameter(this.i(string, SD2, SD3));
                                    this.systeme.put(var11_14, trafoSystem);
                                } else if (n == 42) {
                                    if (n7 == 0) continue;
                                    var11_14 = this.t(string, SF1, SF2).trim();
                                    var12_15 = n6 > SF8 && string.charAt(SF8) != ' ' ? 1 : 0;
                                    TrafoSystem trafoSystem = new TrafoSystem(var12_15 != 0 ? 8 : 9);
                                    trafoSystem.setName((String)var11_14);
                                    trafoSystem.setParameter(this.i(string, SF2, SF3));
                                    this.systeme.put(var11_14, trafoSystem);
                                } else if (n == 32) {
                                    var11_14 = new Bedingung(2);
                                    ((Bedingung)var11_14).p1 = this.p(string, BR0, BR1);
                                    ((Bedingung)var11_14).p2 = this.p(string, BR1, BR2);
                                    ((Bedingung)var11_14).p3 = this.p(string, BR2, BR3);
                                    Stat stat = new Stat();
                                    ((Bedingung)var11_14).g = DataBase.steuerDaten.getRwGw(this.d(string, BR3, BR4) * 0.01);
                                    stat.setSaV(1, this.s(string, BR3, BR4, 10.0));
                                    stat.setV(1, this.s(string, BR4, BR5, 10.0));
                                    int n14 = this.getState(string, BR5, BR8);
                                    if (n14 == 0) {
                                        stat.setEv(1, this.s(string, BR5, BR6, 1.0));
                                        stat.setGf(1, this.s(string, BR6, BR7, 10.0));
                                        stat.setNv(1, this.s(string, BR7, BR8, 10.0));
                                    }
                                    ((Bedingung)var11_14).setStatistik(stat);
                                    String string6 = null;
                                    if (n6 > BR8) {
                                        string6 = this.t(string, BR8, BR9);
                                    }
                                    this.getBedingungRiss(string6).addElement(var11_14);
                                } else if (n == 31) {
                                    var11_14 = new Bedingung(1);
                                    ((Bedingung)var11_14).p1 = this.p(string, BG0, BG1);
                                    ((Bedingung)var11_14).p2 = this.p(string, BG1, BG2);
                                    ((Bedingung)var11_14).p3 = this.p(string, BG2, BG3);
                                    Stat stat = new Stat();
                                    ((Bedingung)var11_14).g = DataBase.steuerDaten.getGeGw(this.d(string, BG3, BG4) * 0.01);
                                    stat.setSaV(1, this.s(string, BG3, BG4, 10.0));
                                    stat.setV(1, this.s(string, BG4, BG5, 10.0));
                                    int n15 = this.getState(string, BG5, BG8);
                                    if (n15 == 0) {
                                        stat.setEv(1, this.s(string, BG5, BG6, 1.0));
                                        stat.setGf(1, this.s(string, BG6, BG7, 10.0));
                                        stat.setNv(1, this.s(string, BG7, BG8, 10.0));
                                    }
                                    ((Bedingung)var11_14).setStatistik(stat);
                                    String string7 = null;
                                    if (n6 > BG8) {
                                        string7 = this.t(string, BG8, BG9);
                                    }
                                    this.getBedingungRiss(string7).addElement(var11_14);
                                }
                            }
                        }
                        catch (Exception exception) {
                            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), exception.getMessage()));
                        }
                    } else {
                        n = this.getBlock(string);
                        if (n != 0) {
                            n4 = 4;
                        }
                    }
                }
                super.setFileProgress(l);
            }
        }
        catch (IOException iOException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), iOException.getMessage()));
        }
        catch (Exception exception) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), exception.getMessage()));
            System.out.println("Zeile: " + this.reader.getLineNumber());
            exception.printStackTrace();
        }
        try {
            this.reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.match();
        if (this.readErrCount > 0 || this.ordErrCount > 0) {
            this.ex("\nFehler beim Laden der Datei: " + this.inFile.getName() + "\nKAFKA-Dateiversion: " + IFormat.f_3.format((double)this.version / 1000.0) + "\nes wird die KAFKA-Version ab 6.000 unterst\u00fctzt\nes sind " + this.readErrCount + " Lesefehler und " + this.ordErrCount + " Zuordnungsfehler aufgetreten\nBitte senden sie die Daten an kafplot@geocalc.de");
        }
    }

    private void putRestklaffe(String string, Punkt punkt) {
        Hashtable<Punkt, Punkt> hashtable = (Hashtable<Punkt, Punkt>)this.systemeRK.get(string = string == null ? "" : string.trim());
        if (hashtable == null) {
            hashtable = new Hashtable<Punkt, Punkt>();
            this.systemeRK.put(string, hashtable);
        }
        hashtable.put(punkt, punkt);
    }

    private Riss getPolarSRiss(String string) {
        string = string == null ? "" : string.trim();
        int n = 201;
        int n2 = 1;
        Riss riss = (Riss)this.polarSRisse.get(string);
        if (riss == null) {
            riss = new Riss(string, n2, n);
            this.polarSRisse.put(string, riss);
        }
        return riss;
    }

    private Riss getPolarRiss(String string) {
        string = string == null ? "" : string.trim();
        int n = 201;
        int n2 = 1;
        Riss riss = (Riss)this.polarRisse.get(string);
        if (riss == null) {
            riss = new Riss(string, n2, n);
            this.polarRisse.put(string, riss);
            this.polarList.addElement(riss);
        }
        return riss;
    }

    private Riss getMesRiss(String string) {
        string = string == null ? "" : string.trim();
        int n = string.length() == 0 ? 205 : 204;
        int n2 = string.length() == 0 ? 1 : 2;
        Riss riss = (Riss)this.mesRisse.get(string);
        if (riss == null) {
            riss = new Riss(string, n2, n);
            this.mesRisse.put(string, riss);
            this.mesList.addElement(riss);
        }
        return riss;
    }

    private Riss getOrthoRiss(String string) {
        string = string == null ? "" : string.trim();
        int n = string.length() == 0 ? 205 : 204;
        int n2 = string.length() == 0 ? 1 : 2;
        Riss riss = (Riss)this.orthoRisse.get(string);
        if (riss == null) {
            riss = new Riss(string, n2, n);
            this.orthoRisse.put(string, riss);
            this.orthoList.addElement(riss);
        }
        return riss;
    }

    private Riss getBedingungRiss(String string) {
        string = string == null ? "" : string.trim();
        int n = string.length() == 0 ? 601 : 602;
        Riss riss = (Riss)this.bedRisse.get(string);
        if (riss == null) {
            riss = new Riss(string, 6, n);
            this.bedRisse.put(string, riss);
            this.bedList.addElement(riss);
        }
        return riss;
    }

    private Punkt p(String string, int n, int n2) throws Exception {
        n2 = Math.min(string.length(), n2);
        String string2 = string.substring(n, n2).trim();
        Punkt punkt = (Punkt)this.P.get(string2);
        if (punkt == null) {
            punkt = new Punkt(IFormat.hasOnlyNumbers(string2) ? Long.parseLong(string2) : (this.newNr = this.newNr - 1L));
            this.P.put(string2, punkt);
        }
        return punkt;
    }

    private boolean isDataLine(String string, int n) {
        int n2 = string.length();
        if (n2 < ID1) {
            return false;
        }
        if (n == 42) {
            return n2 > SF4 && string.charAt(SF4 - 1) != ' ';
        }
        try {
            Integer.parseInt(string.substring(ID0, ID1).trim());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private long l(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        try {
            return Long.parseLong(string.substring(n, n2).trim());
        }
        catch (Exception exception) {
            ++this.readErrCount;
            System.out.println("LT2 Zeile:" + this.reader.getLineNumber());
            exception.printStackTrace();
            return 0L;
        }
    }

    private double d(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        return new Double(string.substring(n, n2).trim());
    }

    private float f(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        return new Float(string.substring(n, n2).trim()).floatValue();
    }

    private int i(String string, int n, int n2) {
        return Integer.parseInt(string.substring(n, n2).trim());
    }

    private short s(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        if (n >= n2) {
            return Short.MIN_VALUE;
        }
        if (n2 < n) {
            return Short.MAX_VALUE;
        }
        String string2 = null;
        try {
            string2 = string.substring(n, n2).trim();
            if (string2.length() == 0) {
                return Short.MIN_VALUE;
            }
            int n3 = Integer.parseInt(string2);
            if (n3 < -32766) {
                return -32767;
            }
            if (n3 > 32765) {
                return 32766;
            }
            return (short)n3;
        }
        catch (Exception exception) {
            if (this.isOverflow(string2)) {
                return 32766;
            }
            ++this.readErrCount;
            System.out.println("LT2 Zeile:" + this.reader.getLineNumber());
            exception.printStackTrace();
            return Short.MAX_VALUE;
        }
    }

    private short s(String string, int n, int n2, double d) {
        return this.s(string, n, n2, d, false);
    }

    private short s(String string, int n, int n2, double d, boolean bl) {
        n2 = Math.min(string.length(), n2);
        if (n >= n2) {
            return Short.MIN_VALUE;
        }
        if (n2 < n) {
            return Short.MAX_VALUE;
        }
        String string2 = null;
        try {
            int n3;
            string2 = string.substring(n, n2).trim();
            if (string2.length() == 0) {
                return Short.MIN_VALUE;
            }
            double d2 = new Double(string2);
            if (bl) {
                d2 = Math.tan(d2 * 1.5707963267948964E-5);
            }
            if ((n3 = (int)Math.rint(d2 * d)) < -32766) {
                return -32767;
            }
            if (n3 > 32765) {
                return 32766;
            }
            return (short)n3;
        }
        catch (Exception exception) {
            if (this.isOverflow(string2)) {
                return 32766;
            }
            ++this.readErrCount;
            System.out.println("LT2 Zeile:" + this.reader.getLineNumber());
            exception.printStackTrace();
            return Short.MAX_VALUE;
        }
    }

    private int i(String string, int n, int n2, double d) {
        n2 = Math.min(string.length(), n2);
        String string2 = null;
        try {
            string2 = string.substring(n, n2).trim();
            double d2 = new Double(string2);
            return (int)Math.rint(d2 * d);
        }
        catch (Exception exception) {
            ++this.readErrCount;
            System.out.println("LT2 Zeile:" + this.reader.getLineNumber());
            exception.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    private String t(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        return string.substring(n, n2);
    }

    private boolean isOverflow(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '*') continue;
            return false;
        }
        return true;
    }

    private int getState(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        if (n >= n2) {
            return -1;
        }
        String string2 = string.substring(n, n2);
        if (string2.indexOf(S_FF) >= 0) {
            return 1;
        }
        if (string2.indexOf(S_NC) >= 0) {
            return 2;
        }
        if (string2.indexOf(S_NB) >= 0) {
            return 3;
        }
        if (string2.indexOf(S_EL) >= 0) {
            return 8;
        }
        if (string2.indexOf(S_VW) >= 0) {
            return 9;
        }
        if (string2.indexOf(S_M_DF) >= 0) {
            return 11;
        }
        if (string2.indexOf(S_M_PA) >= 0) {
            return 12;
        }
        if (string2.indexOf(S_M_LP) >= 0) {
            return 13;
        }
        return 0;
    }

    private void match() {
        try {
            Messung messung;
            Cloneable cloneable;
            Cloneable cloneable2;
            Enumeration enumeration = this.P.elements();
            while (enumeration.hasMoreElements()) {
                cloneable2 = (Punkt)enumeration.nextElement();
                DataBase.P.put((LongHashObject)((Object)cloneable2));
                if (((Punkt)cloneable2).nr > 0L) continue;
                System.out.println("**" + ((Punkt)cloneable2).nr);
            }
            for (int i = this.orthoList.size() - 1; i >= 0; --i) {
                cloneable2 = (Riss)this.orthoList.elementAt(i);
                cloneable = (TrafoSystem)this.systeme.get(((ValueDataContainer)cloneable2).getName());
                if (cloneable == null) {
                    System.out.println("Ohne TS: " + ((ValueDataContainer)cloneable2).getName());
                }
                if (cloneable == null || !this.isDigitSystem((Riss)cloneable2) && !this.isTrafoSystem((Riss)cloneable2)) continue;
                Enumeration enumeration2 = ((DataContainer)cloneable2).elements();
                while (enumeration2.hasMoreElements()) {
                    messung = (Messung)enumeration2.nextElement();
                    TrafoPunkt trafoPunkt = new TrafoPunkt(messung.ps, messung.l2, messung.l1);
                    ((TrafoSystem)cloneable).addElement(trafoPunkt);
                }
                DataBase.T.addElement((TrafoSystem)cloneable);
                this.orthoList.removeElementAt(i);
            }
            Enumeration enumeration3 = this.polarList.elements();
            while (enumeration3.hasMoreElements()) {
                cloneable2 = (Riss)enumeration3.nextElement();
                cloneable = (Messung)((DataContainer)cloneable2).firstElement();
                for (int i = 1; i < ((DataContainer)cloneable2).size(); ++i) {
                    messung = (Messung)((DataContainer)cloneable2).elementAt(i);
                    messung.ps = null;
                    messung.setReferenz((Messung)cloneable);
                }
                DataBase.MP.addElement(cloneable2);
            }
            enumeration3 = this.orthoList.elements();
            while (enumeration3.hasMoreElements()) {
                int n;
                cloneable2 = (Riss)enumeration3.nextElement();
                cloneable = (Messung)((DataContainer)cloneable2).firstElement();
                Messung messung2 = (Messung)((DataContainer)cloneable2).lastElement();
                if (((Messung)cloneable).getMessungsArt() == 200) {
                    ((Messung)cloneable).setMessungsArt(210);
                }
                if (messung2.getMessungsArt() == 200) {
                    messung2.setMessungsArt(290);
                }
                if ((n = ((Riss)cloneable2).getRissInfo().getList()) == 204) {
                    DataBase.MK.addElement(cloneable2);
                    continue;
                }
                DataBase.MV.addElement(cloneable2);
            }
            enumeration3 = this.mesList.elements();
            while (enumeration3.hasMoreElements()) {
                cloneable2 = (Riss)enumeration3.nextElement();
                int n = ((Riss)cloneable2).getRissInfo().getList();
                if (n == 204) {
                    DataBase.MK.addElement(cloneable2);
                    continue;
                }
                DataBase.MV.addElement(cloneable2);
            }
            enumeration3 = this.bedList.elements();
            while (enumeration3.hasMoreElements()) {
                cloneable2 = (Riss)enumeration3.nextElement();
                int n = ((Riss)cloneable2).getRissInfo().getList();
                if (n == 601) {
                    DataBase.BH.addElement(cloneable2);
                    continue;
                }
                DataBase.BB.addElement(cloneable2);
            }
            DataBase.hasStatistik = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isDigitSystem(Riss riss) {
        TrafoSystem trafoSystem = (TrafoSystem)this.systeme.get(riss.getName());
        return trafoSystem != null && trafoSystem.getRissInfo().getTyp() == 9;
    }

    private boolean isTrafoSystem(Riss riss) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        Enumeration enumeration = riss.elements();
        while (enumeration.hasMoreElements()) {
            Messung messung = (Messung)enumeration.nextElement();
            d = Math.min(d, messung.l1);
            d2 = Math.max(d2, messung.l1);
            d = Math.min(d, messung.l2);
            d2 = Math.max(d2, messung.l2);
        }
        return d2 > 10000.0 || d2 < -10000.0 || d > 5000.0 || d < -5000.0;
    }

    private void ex(String string) {
        this.addException(new IFileInputException("OUT: " + string));
    }
}

