/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.TrafoGewicht;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.MessungParser;
import de.geocalc.kafplot.io.dat.SteuerDaten;
import de.geocalc.kafplot.io.sta.StaIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparator;
import de.geocalc.util.CountTable;
import de.geocalc.util.SortableVector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SystraReader
extends IDataReader {
    private static final String INTERN_SYSTEM_NAME_SCHNITT = "#internSystemSchnitt";
    private static final String INTERN_SYSTEM_NAME_POLAR = "#internSystemPolar";
    private static final String INTERN_SYSTEM_NAME_RECHTER_WINKEL = "#internSystemRechtWinkel";
    private static final String INTERN_SYSTEM_NAME_GERADE = "#internSystemGerade";
    private static final String INTERN_SYSTEM_NAME_PARALLEL = "#internSystemParallel";
    private static final String INTERN_SYSTEM_NAME_BOGENSCHNITT = "#internSystemBogenschnitt";
    private static final String INTERN_SYSTEM_NAME_KREIS = "#internSystemKreis";
    private static final String INTERN_SYSTEM_TYP_BOGENSCHNITT = "_BS";
    private static final String INTERN_SYSTEM_TYP_KREIS = "_KR";
    private static final String INTERN_SYSTEM_TYP_KREISPUNKT = "_KP";
    private DataBase db;
    private File iniFile;
    private File kooFile;
    private File kanFile;
    private File lokFile;
    private File zusFile;
    private File sysFile;
    private File linFile;
    private Hashtable points = new Hashtable();
    private Hashtable systeme = new Hashtable();
    private Hashtable beds = new Hashtable();
    private Hashtable objects = new Hashtable();
    private SteuerDaten steuerDaten = null;
    private float mfAbz = 0.02f;
    private float mfOrd = 0.02f;
    private float mfDig = 1.0f;
    private float mfFlu = 0.005f;
    private float mfSpn = 0.02f;
    private float mfIde = 0.02f;
    private float mfPri = 0.01f;
    private float mfPsa = 0.005f;
    private float mfPsr = 0.005f;
    private float mfPuz = 0.005f;
    private float mfFpk = 0.02f;
    private float mfFph = 0.02f;
    private float mfMst = 0.1f;
    private float mfGrs = 0.02f;
    private float mfRew = 0.02f;
    private float mfGer = 0.02f;
    private float mfPar = 0.02f;
    private float mfPma = 0.02f;
    private float mfApl = 0.02f;
    private float mfKrr = 0.02f;
    private float mfKrh = 0.02f;
    private float mfKrz = 0.02f;
    private float mfKrp = 0.02f;
    private float mfKra = 0.02f;
    private float mfLok = 1.0f;
    private float mfFactor = 1.0f;
    private long newNr = 0L;
    private LineNumberReader reader = null;

    private float getDefaultMf(String string, int n) {
        if (string.equals("   ")) {
            return n == 1 ? this.mfAbz : this.mfOrd;
        }
        if (string.equals("DIG")) {
            return this.mfDig;
        }
        if (string.equals("FLU")) {
            return this.mfFlu;
        }
        if (string.equals("APL")) {
            return this.mfApl;
        }
        if (string.equals("PMA")) {
            return this.mfPma;
        }
        if (string.equals("SPN")) {
            return this.mfSpn;
        }
        if (string.equals("GRS")) {
            return this.mfGrs;
        }
        if (string.equals("REW")) {
            return this.mfRew;
        }
        if (string.equals("GER")) {
            return this.mfGer;
        }
        if (string.equals("PAR")) {
            return this.mfPar;
        }
        if (string.equals("KOO")) {
            return this.mfFpk;
        }
        if (string.equals("POL")) {
            return this.mfPri;
        }
        if (string.equals("     ")) {
            return n == 1 ? this.mfPri : this.mfPsa;
        }
        if (string.equals(INTERN_SYSTEM_TYP_BOGENSCHNITT)) {
            return 0.0f;
        }
        if (string.equals(INTERN_SYSTEM_TYP_KREIS)) {
            return this.mfKrr;
        }
        if (string.equals(INTERN_SYSTEM_TYP_KREISPUNKT)) {
            return this.mfKrp;
        }
        return this.mfSpn;
    }

    public SystraReader(File file, DataBase dataBase) {
        this(file, dataBase, null);
    }

    public SystraReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.db = dataBase;
        this.steuerDaten = dataBase.getSteuerDaten();
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        Object object;
        super.setProgress(0);
        String string = null;
        File file = null;
        String string2 = this.inFile.getAbsolutePath();
        int n = string2.lastIndexOf(File.separator);
        if (n > 0) {
            string2 = string2.substring(0, n + 1);
        }
        try {
            Object object2;
            float f;
            float f2;
            String string3;
            Object object3;
            int n2;
            file = this.inFile;
            this.reader = this.createReader(file);
            while ((string = this.reader.readLine()) != null) {
                if (string.startsWith("INI=")) {
                    this.iniFile = new File(string2 + string.substring(4) + ".ini");
                }
                if (string.startsWith("KOOR=")) {
                    this.kooFile = new File(string2 + string.substring(5) + ".koo");
                }
                if (string.startsWith("LOKOOR=")) {
                    this.lokFile = new File(string2 + string.substring(7) + ".lok");
                }
                if (string.startsWith("KANTE=")) {
                    this.kanFile = new File(string2 + string.substring(6) + ".kan");
                }
                if (string.startsWith("ZUSATZ=")) {
                    this.zusFile = new File(string2 + string.substring(7) + ".zus");
                }
                if (string.startsWith("SYSTEM=")) {
                    this.sysFile = new File(string2 + string.substring(7) + ".sys");
                }
                if (!string.startsWith("LINIE=")) continue;
                this.linFile = new File(string2 + string.substring(6) + ".lin");
            }
            this.reader.close();
            file = this.iniFile;
            if (file != null && file.exists()) {
                this.reader = this.createReader(file);
                n2 = 0;
                while ((string = this.reader.readLine()) != null) {
                    try {
                        int n3;
                        if (string.startsWith("#")) continue;
                        if (string.startsWith("[") && string.endsWith("]")) {
                            n2 = string.startsWith("[SYSTRA]");
                            continue;
                        }
                        if (n2 == 0 || (n3 = string.indexOf("=")) <= 0) continue;
                        object3 = string.substring(0, n3).trim();
                        String string4 = string.substring(n3 + 1).trim();
                        if (((String)object3).equals("MF LINIE ABSZISSE")) {
                            this.mfAbz = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF LINIE ORDINATE")) {
                            this.mfOrd = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF DIGITAL. PUNKTE")) {
                            this.mfDig = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF DURCHFLUCHTUNG")) {
                            this.mfFlu = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF SPANNMASSE")) {
                            this.mfSpn = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF IDENTITAET")) {
                            this.mfIde = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF RICHTUNGSBEOB")) {
                            this.mfPri = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF STRECKENBEOB ABS")) {
                            this.mfPsa = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF STRECKENBEOB REL")) {
                            this.mfPsr = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF ZENTRIERUNG")) {
                            this.mfPuz = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF FESTPUNKTE")) {
                            this.mfFpk = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF FESTPUNKTE HOEHE")) {
                            this.mfFph = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF MASSSTAEBE")) {
                            this.mfMst = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF GERADENSCHNITTE")) {
                            this.mfGrs = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF RECHTWINKEL")) {
                            this.mfRew = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF GERADEN")) {
                            this.mfGer = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF PARALLEL")) {
                            this.mfPar = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF PARALLEL MIT ABSTAND")) {
                            this.mfPma = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF ABSTAND PUNKT-LINIE")) {
                            this.mfApl = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF KREIS-RADIUS")) {
                            this.mfKrr = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF KREIS-PFEILHOEHE")) {
                            this.mfKrh = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF KREIS-ZENTRIWINKEL")) {
                            this.mfKrz = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF KREIS-PERIPHERIEPUNKTE")) {
                            this.mfKrp = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (((String)object3).equals("MF KREIS-PERIPHERIE APEP")) {
                            this.mfKra = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                            continue;
                        }
                        if (!((String)object3).equals("MF LOKALE N\u00c4HERUNGSKOORDINATEN")) continue;
                        this.mfLok = new Float(string4).floatValue() * 0.01f * this.mfFactor;
                    }
                    catch (Exception exception) {
                        this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": " + exception.getMessage()));
                    }
                }
            } else {
                this.addException(new IException(file.getName() + ": Datei nicht vorhanden"));
            }
            file = this.kooFile;
            if (file != null && file.exists()) {
                this.reader = this.createReader(file);
                while ((string = this.reader.readLine()) != null) {
                    if (string.length() < 60) continue;
                    try {
                        Punkt punkt = this.getPunkt(string.substring(0, 15));
                        punkt.y = new Double(string.substring(15, 30).trim());
                        punkt.x = new Double(string.substring(30, 45).trim());
                        punkt.h = IFormat.parseFloat(string, 45, 60, 1.0, 0.0f);
                        if (punkt.h == -1000.0f) {
                            punkt.h = 0.0f;
                        }
                        if (string.length() <= 60) continue;
                        punkt.g = IFormat.parseFloat(string, 60, 70, 100.0, 0.01f);
                        punkt.setPs(IFormat.parseInt(string, 71, 72, -2));
                        punkt.t = (short)IFormat.parseInt(string, 72, 82, 1.0, 0);
                        punkt.a = IFormat.parseInt(string, 82, 92, 10.0, 0);
                        punkt.b = IFormat.parseInt(string, 92, 102, 10.0, 0);
                    }
                    catch (Exception exception) {
                        this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": " + exception.getMessage()));
                    }
                }
            } else {
                this.addException(new IException(file.getName() + ": Datei nicht vorhanden"));
            }
            if ((file = new File(string2 + "SYSTRA.KOO")) != null && file.exists()) {
                this.reader = this.createReader(file);
                while ((string = this.reader.readLine()) != null) {
                    n2 = string.length();
                    if (n2 < 60) continue;
                    try {
                        Punkt punkt = this.getPunkt(string.substring(0, 15));
                        punkt.y = new Double(string.substring(15, 30).trim());
                        punkt.x = new Double(string.substring(30, 45).trim());
                        punkt.h = IFormat.parseFloat(string, 45, 60, 1.0, 0.0f);
                        if (punkt.h == -1000.0f) {
                            punkt.h = 0.0f;
                        }
                        if (string.length() <= 60) continue;
                        punkt.g = IFormat.parseFloat(string, 60, 70, 100.0, 0.01f);
                        punkt.setPs(IFormat.parseInt(string, 71, 72, -2));
                        punkt.t = (short)IFormat.parseInt(string, 72, 82, 1.0, 0);
                        punkt.a = IFormat.parseInt(string, 82, 92, 10.0, 0);
                        punkt.b = IFormat.parseInt(string, 92, 102, 10.0, 0);
                    }
                    catch (Exception exception) {
                        this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": " + exception.getMessage()));
                    }
                }
                this.reader.close();
            } else {
                this.addException(new IException(file.getName() + ": Datei nicht vorhanden"));
            }
            super.setProgress(20);
            file = this.sysFile;
            if (file != null && file.exists()) {
                this.reader = this.createReader(file);
                while ((string = this.reader.readLine()) != null) {
                    n2 = string.length();
                    try {
                        int n4 = Integer.parseInt(string.substring(0, 1));
                        object3 = string.substring(1, 16).trim();
                        float f3 = IFormat.parseFloat(string, 86, 96, 0.01, 0.0f);
                        float f4 = IFormat.parseFloat(string, 96, 106, 0.01, 0.0f);
                        String string5 = string.substring(106, 109);
                        double d = IFormat.parseDouble(string, 109, 124, 1.0, 1.0);
                        string3 = n2 > 124 ? string.substring(124, Math.min(n2, 139)).trim() : "";
                        f2 = n2 > 150 ? IFormat.parseFloat(string, 150, Math.min(n2, 160), 1.0, 1.0f) : 1.0f;
                        float f5 = f = n2 > 160 ? IFormat.parseFloat(string, 160, Math.min(n2, 170), 1.0, 1.0f) : 1.0f;
                        if (f2 != 1.0f) {
                            this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": System " + (String)object3 + " enth\u00e4lt Abzissenfaktor ungleich 1.0, Faktor wird ignoriert"));
                        }
                        if (f != 1.0f) {
                            this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": System " + (String)object3 + " enth\u00e4lt Ordinatenfaktor ungleich 1.0, Faktor wird ignoriert"));
                        }
                        if (this.systeme.put(object3, new System(n4, (String)object3, string5, string3, f3, f4)) == null) continue;
                        this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": Systemname " + (String)object3 + " doppelt vorhanden, Parameter werden \u00fcberschrieben"));
                    }
                    catch (Exception exception) {
                        this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": " + exception.getMessage()));
                    }
                }
            } else {
                this.addException(new IException(file.getName() + ": Datei nicht vorhanden"));
            }
            super.setProgress(30);
            file = this.lokFile;
            if (file != null && file.exists()) {
                this.reader = this.createReader(file);
                while ((string = this.reader.readLine()) != null) {
                    n2 = string.length();
                    if (n2 < 60) continue;
                    try {
                        String string6 = string.substring(0, 15).trim();
                        object3 = this.getPunkt(string.substring(15, 30));
                        double d = IFormat.parseDouble(string, 30, 45, 1.0, Double.MAX_VALUE);
                        double d2 = IFormat.parseDouble(string, 45, 60, 1.0, Double.MAX_VALUE);
                        double d3 = IFormat.parseDouble(string, 60, 75, 1.0, Double.MAX_VALUE);
                        f2 = IFormat.parseFloat(string, 75, 85, 1.0, 0.0f);
                        f = IFormat.parseFloat(string, 85, 95, 1.0, 0.0f);
                        object2 = string.substring(105, 108);
                        object = n2 > 110 ? string.substring(110, Math.min(n2, 125)).trim() : "";
                        String string7 = n2 > 130 ? string.substring(130, Math.min(n2, 155)).trim() : "";
                        System system = (System)this.systeme.get(string6);
                        if (system == null) {
                            system = new System(4, string6, (String)object2, "", this.getDefaultMf((String)object2, 1), this.getDefaultMf((String)object2, 2));
                            this.systeme.put(string6, system);
                        }
                        if (f2 == 0.0f) {
                            f2 = system.mfO;
                        }
                        if (f == 0.0f) {
                            f = system.mfA;
                        }
                        system.addElement(new SystemPunkt(this, (Punkt)object3, d2, d, f, f2, (String)object, string7));
                    }
                    catch (Exception exception) {
                        this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": " + exception.getMessage()));
                    }
                }
                this.reader.close();
            } else {
                this.addException(new IException(file.getName() + ": Datei nicht vorhanden"));
            }
            super.setProgress(50);
            file = this.kanFile;
            if (file != null && file.exists()) {
                this.reader = this.createReader(file);
                while ((string = this.reader.readLine()) != null) {
                    n2 = string.length();
                    if (n2 < 60) continue;
                    try {
                        Punkt punkt = this.getPunkt(string.substring(0, 15));
                        object3 = this.getPunkt(string.substring(15, 30));
                        double d = IFormat.parseDouble(string, 30, 45, 1.0, 0.0);
                        float f6 = IFormat.parseFloat(string, 45, 55, 0.01, 0.0f);
                        String string8 = string.substring(55, 60);
                        String string9 = StaIOProperties.kanTypToSysTyp(string8);
                        string3 = n2 > 61 ? string.substring(61, Math.min(n2, 76)).trim() : "";
                        String string10 = n2 > 80 ? string.substring(80, Math.min(n2, 95)).trim() : "";
                        String string11 = n2 > 175 ? string.substring(175, Math.min(n2, 200)).trim() : "";
                        object2 = (System)this.systeme.get(string10);
                        if (object2 == null) {
                            object2 = new System(4, string10, string9, "", this.getDefaultMf(string9, 1), this.getDefaultMf(string9, 1));
                            this.systeme.put(string10, object2);
                        } else if (!string9.equals(((System)object2).typ)) {
                            throw new Exception("Beobachtungstyp " + string8 + " entspricht nicht dem Typ der Systemgruppe " + ((System)object2).typ);
                        }
                        if (f6 == 0.0f) {
                            f6 = ((System)object2).mfO;
                        }
                        if (string9.equals("IDENT")) continue;
                        ((Vector)object2).addElement(new SystemKante(this, punkt, (Punkt)object3, d, f6, string3, string11));
                    }
                    catch (Exception exception) {
                        this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": " + exception.getMessage()));
                    }
                }
                this.reader.close();
            } else {
                this.addException(new IException(file.getName() + ": Datei nicht vorhanden"));
            }
            super.setProgress(60);
            file = this.zusFile;
            if (file != null && file.exists()) {
                this.reader = this.createReader(file);
                n2 = 1;
                int n5 = 0;
                while ((string = this.reader.readLine()) != null) {
                    Cloneable cloneable;
                    int n6 = string.length();
                    if (n6 == 0) {
                        ++n2;
                        continue;
                    }
                    SystemElement systemElement = null;
                    Object object4 = "";
                    String string12 = null;
                    if (n2 == 1) {
                        cloneable = this.getPunkt(string.substring(0, 15));
                        Punkt punkt = this.getPunkt(string.substring(15, 30));
                        Punkt punkt2 = this.getPunkt(string.substring(30, 45));
                        Punkt punkt3 = this.getPunkt(string.substring(45, 60));
                        Punkt punkt4 = this.getPunkt(string.substring(60, 75));
                        float f7 = IFormat.parseFloat(string, 75, 85, 0.01, 0.0f);
                        object4 = n6 > 90 ? string.substring(90, Math.min(n6, 105)).trim() : "";
                        object = n6 > 110 ? string.substring(110, Math.min(n6, 125)).trim() : "";
                        String string13 = n6 > 130 ? string.substring(130, Math.min(n6, 155)).trim() : "";
                        systemElement = new SystemSchnitt(this, (Punkt)cloneable, punkt, punkt2, punkt3, punkt4, f7, (String)object, string13);
                        if (((String)object4).equals("")) {
                            object4 = INTERN_SYSTEM_NAME_SCHNITT;
                        }
                        string12 = "GRS";
                    } else if (n2 == 2) {
                        this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": Block 2 (Zus\u00e4tzliche Abzissen) muss unbesetzt sein, Daten nicht \u00fcbernommen"));
                    } else if (n2 == 3) {
                        this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": Block 3 (Zus\u00e4tzliche Ordinaten) muss unbesetzt sein, Daten nicht \u00fcbernommen"));
                    } else if (n2 == 4) {
                        object4 = string.substring(0, 15).trim();
                        cloneable = this.getPunkt(string.substring(15, 30));
                        Punkt punkt = this.getPunkt(string.substring(30, 45));
                        double d = IFormat.parseDouble(string, 45, 60, 1.0, 0.0);
                        float f8 = IFormat.parseFloat(string, 60, 70, 0.01, 0.0f);
                        String string14 = "";
                        object = n6 > 130 ? string.substring(130, Math.min(n6, 155)).trim() : "";
                        systemElement = new SystemRichtung(this, (Punkt)cloneable, punkt, d, f8, string14, (String)object);
                        if (((String)object4).equals("")) {
                            this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": Systemname f\u00fcr Polarrichtung fehlt"));
                            object4 = INTERN_SYSTEM_NAME_POLAR;
                        }
                        string12 = "POL";
                    } else if (n2 == 5) {
                        cloneable = this.getPunkt(string.substring(0, 15));
                        Punkt punkt = this.getPunkt(string.substring(15, 30));
                        Punkt punkt5 = this.getPunkt(string.substring(30, 45));
                        float f9 = IFormat.parseFloat(string, 45, 55, 0.01, 0.0f);
                        object4 = n6 > 90 ? string.substring(90, Math.min(n6, 105)).trim() : "";
                        String string15 = n6 > 110 ? string.substring(110, Math.min(n6, 125)).trim() : "";
                        String string16 = n6 > 130 ? string.substring(130, Math.min(n6, 130)).trim() : "";
                        systemElement = new SystemRechtWinkel(this, (Punkt)cloneable, punkt, punkt5, f9, string15, string16);
                        if (((String)object4).equals("")) {
                            object4 = INTERN_SYSTEM_NAME_RECHTER_WINKEL;
                        }
                        string12 = "REW";
                    } else if (n2 == 6) {
                        cloneable = this.getPunkt(string.substring(0, 15));
                        Punkt punkt = this.getPunkt(string.substring(15, 30));
                        Punkt punkt6 = this.getPunkt(string.substring(30, 45));
                        float f10 = IFormat.parseFloat(string, 45, 55, 0.01, 0.0f);
                        object4 = n6 > 90 ? string.substring(90, Math.min(n6, 105)).trim() : "";
                        String string17 = n6 > 110 ? string.substring(110, Math.min(n6, 125)).trim() : "";
                        String string18 = n6 > 130 ? string.substring(130, Math.min(n6, 130)).trim() : "";
                        systemElement = new SystemGerade(this, (Punkt)cloneable, punkt, punkt6, f10, string17, string18);
                        if (((String)object4).equals("")) {
                            object4 = INTERN_SYSTEM_NAME_GERADE;
                        }
                        string12 = "GER";
                    } else if (n2 == 7) {
                        cloneable = this.getPunkt(string.substring(0, 15));
                        Punkt punkt = this.getPunkt(string.substring(15, 30));
                        Punkt punkt7 = this.getPunkt(string.substring(30, 45));
                        Punkt punkt8 = this.getPunkt(string.substring(45, 60));
                        float f11 = IFormat.parseFloat(string, 60, 70, 0.01, 0.0f);
                        object4 = n6 > 90 ? string.substring(90, Math.min(n6, 105)).trim() : "";
                        String string19 = n6 > 110 ? string.substring(110, Math.min(n6, 125)).trim() : "";
                        object = n6 > 130 ? string.substring(130, Math.min(n6, 130)).trim() : "";
                        systemElement = new SystemParallele(this, (Punkt)cloneable, punkt, punkt7, punkt8, f11, string19, (String)object);
                        if (((String)object4).equals("")) {
                            object4 = INTERN_SYSTEM_NAME_PARALLEL;
                        }
                        string12 = "PAR";
                    } else if (n2 == 8) {
                        cloneable = this.getPunkt(string.substring(0, 15));
                        Punkt punkt = this.getPunkt(string.substring(15, 30));
                        Punkt punkt9 = this.getPunkt(string.substring(30, 45));
                        String string20 = "";
                        String string21 = n6 > 130 ? string.substring(130, Math.min(n6, 130)).trim() : "";
                        systemElement = new SystemBogenSchnitt(this, (Punkt)cloneable, punkt, punkt9, string20, string21);
                        object4 = INTERN_SYSTEM_NAME_BOGENSCHNITT;
                        string12 = INTERN_SYSTEM_TYP_BOGENSCHNITT;
                    } else if (n2 == 9) {
                        object4 = string.substring(0, 15).trim();
                        cloneable = this.getPunkt(string.substring(15, 30));
                        Punkt punkt = this.getPunkt(string.substring(30, 45));
                        Punkt punkt10 = this.getPunkt(string.substring(45, 60));
                        double d = IFormat.parseDouble(string, 60, 75, 1.0, 0.0);
                        double d4 = IFormat.parseDouble(string, 75, 90, 1.0, 0.0);
                        double d5 = IFormat.parseDouble(string, 90, 105, 1.0, 0.0);
                        if (d4 != 0.0) {
                            this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": Pfeilh\u00f6he kann nicht verarbeitet werden"));
                        }
                        if (d5 != 0.0) {
                            this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": Zentriwinkel kann nicht verarbeitet werden"));
                        }
                        float f12 = IFormat.parseFloat(string, 105, 115, 0.01, 0.0f);
                        String string22 = "";
                        String string23 = n6 > 140 ? string.substring(140, Math.min(n6, 165)).trim() : "";
                        systemElement = new SystemBogen(this, (Punkt)cloneable, punkt, punkt10, d, f12, string22, string23);
                        if (((String)object4).equals("")) {
                            this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": Systemname f\u00fcr Kreisbogen fehlt"));
                            object4 = INTERN_SYSTEM_NAME_KREIS + n5++;
                        }
                        string12 = INTERN_SYSTEM_TYP_KREIS;
                    } else if (n2 == 10) {
                        object4 = string.substring(0, 15).trim();
                        cloneable = this.getPunkt(string.substring(15, 30));
                        float f13 = IFormat.parseFloat(string, 30, 40, 0.01, 0.0f);
                        systemElement = new SystemBogenPunkt(this, (Punkt)cloneable, f13, "", "");
                        if (((String)object4).equals("")) {
                            this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": Systemname f\u00fcr Kreisbogen fehlt"));
                            object4 = INTERN_SYSTEM_NAME_KREIS + n5;
                        }
                        string12 = INTERN_SYSTEM_TYP_KREISPUNKT;
                    } else {
                        this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": Block " + n2 + " unbekannt"));
                    }
                    if (systemElement == null) continue;
                    cloneable = (System)this.systeme.get(object4);
                    if (cloneable == null) {
                        cloneable = new System(4, (String)object4, string12, "", this.getDefaultMf(string12, 1), this.getDefaultMf(string12, 2));
                        this.systeme.put(object4, cloneable);
                    }
                    if (systemElement.mf == 0.0f) {
                        systemElement.mf = ((System)cloneable).mfA;
                    }
                    ((Vector)cloneable).addElement(systemElement);
                }
            }
            super.setProgress(70);
            file = this.linFile;
            if (file != null && file.exists()) {
                this.reader = this.createReader(file);
                n2 = 1;
                while ((string = this.reader.readLine()) != null) {
                    int n7 = string.length();
                    if (n7 == 0) {
                        if (++n2 <= 1) continue;
                        this.addException(new IException(file.getName() + ":" + this.reader.getLineNumber() + ": Lesen von B\u00f6gen und Fl\u00e4chen nicht implementiert"));
                        break;
                    }
                    if (n2 != 1) continue;
                    Punkt punkt = this.getPunkt(string.substring(0, 15));
                    Punkt punkt11 = this.getPunkt(string.substring(15, 30));
                    String string24 = n7 > 60 ? string.substring(60, Math.min(n7, 76)).trim() : "";
                    Linie linie = new Linie(2, punkt, punkt11);
                    if (n7 > 76) {
                        int n8 = 0;
                        int n9 = 0;
                        String string25 = string.substring(76, Math.min(n7, 95)).trim();
                        int n10 = string25.lastIndexOf(".");
                        if (n10 > 0) {
                            try {
                                n9 = Integer.parseInt(string25.substring(n10 + 1));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            int n11 = string25.lastIndexOf(".", n10 - 1);
                            if (n11 > 0) {
                                try {
                                    n8 = Integer.parseInt(string25.substring(n11 + 1, n10));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        linie.setParameter(this.createLinePar(n8, n9));
                    }
                    this.getObject(string24).addElement(linie);
                }
            }
            super.setProgress(90);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IFileInputException("Datei " + file.getName() + " nicht gefunden");
        }
        catch (IOException iOException) {
            throw new IFileInputException("Lesefehler in Datei: " + file.getName() + " in Zeile: " + this.reader.getLineNumber());
        }
        catch (Exception exception) {
            this.addException(new IFileInputException("Lesefehler in Datei: " + file.getName() + " in Zeile: " + this.reader.getLineNumber() + " " + exception.getMessage()));
        }
        Object object5 = this.points.elements();
        while (object5.hasMoreElements()) {
            Punkt punkt = (Punkt)object5.nextElement();
            if (punkt.nr <= 0L) continue;
            this.savePunkt(punkt, DataBase.P);
        }
        object5 = this.points.elements();
        while (object5.hasMoreElements()) {
            Punkt punkt = (Punkt)object5.nextElement();
            if (punkt.nr > 0L) continue;
            punkt.nr = this.getFreeNumber(DataBase.P);
            this.savePunkt(punkt, DataBase.P);
        }
        object5 = this.systeme.elements();
        while (object5.hasMoreElements()) {
            System system = (System)object5.nextElement();
            if (!system.typ.equals("   ")) continue;
            boolean bl = false;
            if (system.pt > 4) {
                bl = true;
            } else {
                double d = Double.MAX_VALUE;
                double d6 = Double.MAX_VALUE;
                double d7 = -1.7976931348623157E308;
                double d8 = -1.7976931348623157E308;
                Enumeration enumeration = system.elements();
                while (enumeration.hasMoreElements()) {
                    object = (SystemPunkt)enumeration.nextElement();
                    d = Math.min(d, ((SystemPunkt)object).a);
                    d6 = Math.min(d6, ((SystemPunkt)object).o);
                    d7 = Math.max(d7, ((SystemPunkt)object).a);
                    d8 = Math.max(d8, ((SystemPunkt)object).o);
                }
                if (d > 1000.0) {
                    bl = true;
                } else if (d6 > 100.0) {
                    bl = true;
                }
            }
            if (!bl) continue;
            system.typ = "DIG";
        }
        object5 = new Hashtable();
        Object object6 = this.systeme.elements();
        while (object6.hasMoreElements()) {
            System system = (System)object6.nextElement();
            if (system.typ.equals("DIG")) {
                TrafoSystem trafoSystem = new TrafoSystem(9);
                system.fillTrafoSystem(trafoSystem);
                try {
                    DataBase.T.put(trafoSystem);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (system.typ.equals("   ")) {
                String string26 = system.getNachweis();
                Riss riss = (Riss)((Hashtable)object5).get(string26);
                if (riss == null) {
                    riss = new Riss(string26, 2, 204);
                    ((Hashtable)object5).put(string26, riss);
                    try {
                        DataBase.MK.put(riss);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                system.fillOrthoRiss(riss);
            } else if (system.typ.equals("FLU")) {
                // empty if block
            }
            java.lang.System.out.println(system.name + ":" + system.typ + ":" + system.size());
        }
        super.setProgress(95);
        this.db.setArea(-1);
        object6 = new MessungParser(this.db);
        ((MessungParser)object6).referMessungen();
        ((MessungParser)object6).referBedingungen();
        ((MessungParser)object6).computeInternPunkte();
        ((MessungParser)object6).initGeom();
        super.setProgress(100);
        super.setProgress(100);
    }

    private LinieParameter createLinePar(int n, int n2) {
        LinieParameter linieParameter = new LinieParameter();
        if (n > 0 || n2 > 0) {
            linieParameter.setFolie(n);
            linieParameter.setOska(n2);
            int n3 = 0;
            int n4 = 0;
            switch (n2) {
                case 231: 
                case 232: 
                case 233: 
                case 239: {
                    n4 = 1;
                    n3 = 2;
                    break;
                }
                case 914: 
                case 915: 
                case 1011: 
                case 1012: 
                case 1013: 
                case 1014: 
                case 1016: 
                case 1041: 
                case 1042: 
                case 1043: 
                case 1044: 
                case 1045: 
                case 1046: 
                case 1047: 
                case 1048: 
                case 1049: {
                    n4 = 2;
                    n3 = 3;
                    break;
                }
                case 241: {
                    n4 = 47;
                    n3 = 4;
                }
                case 242: {
                    n4 = 0;
                    n3 = 0;
                    break;
                }
                default: {
                    n4 = 0;
                    n3 = 4;
                }
            }
            if (n3 > 0) {
                linieParameter.setLa(n3);
            }
            if (n4 > 0) {
                linieParameter.setEb(n4);
            }
        }
        return linieParameter;
    }

    private Punkt getPunkt(String string) {
        Punkt punkt = (Punkt)this.points.get(string = string.trim());
        if (punkt == null) {
            if (IFormat.hasOnlyNumbers(string)) {
                punkt = new Punkt(Long.parseLong(string));
            } else {
                punkt = new Punkt(--this.newNr);
                punkt.setBemerkung(string);
            }
            this.points.put(string, punkt);
        }
        return punkt;
    }

    private Riss getBedBlatt(String string) {
        Riss riss;
        if (string == null) {
            string = "";
        }
        if ((riss = (Riss)this.beds.get(string)) == null) {
            riss = new Riss(string, 6, 602);
            this.beds.put(string, riss);
            try {
                DataBase.BB.put(riss);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return riss;
    }

    private TopObject getObject(String string) {
        TopObject topObject;
        if (string == null) {
            string = "";
        }
        if ((topObject = (TopObject)this.objects.get(string)) == null) {
            topObject = new TopObject();
            topObject.setBezeichnung(string);
            this.objects.put(string, topObject);
            try {
                DataBase.TOP.put(topObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return topObject;
    }

    private class System
    extends SortableVector {
        int pt = 0;
        String name;
        String typ;
        String grp;
        float mfA;
        float mfO;

        System(int n, String string, String string2, String string3, float f, float f2) {
            this.pt = n;
            this.name = string;
            this.typ = string2;
            this.grp = string3;
            this.mfA = f;
            this.mfO = f2;
        }

        void fillTrafoSystem(TrafoSystem trafoSystem) {
            this.sort(new SystemPunktNummerComparator(SystraReader.this));
            String string = this.getNachweis();
            trafoSystem.setParameter(this.pt);
            trafoSystem.setName(this.name);
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                SystemPunkt systemPunkt = (SystemPunkt)enumeration.nextElement();
                TrafoPunkt trafoPunkt = systemPunkt.toTrafoPunkt();
                if (!systemPunkt.knw.equals(string)) {
                    trafoPunkt.addBemerkung(systemPunkt.knw);
                }
                if (!systemPunkt.txt.equals("")) {
                    trafoPunkt.addBemerkung(systemPunkt.txt);
                }
                trafoSystem.addElement(trafoPunkt);
            }
        }

        void fillOrthoRiss(Riss riss) {
            this.sort(new SystemPunktAbzisseComparator(SystraReader.this));
            String string = this.getNachweis();
            boolean bl = true;
            Object object = this.elements();
            while (object.hasMoreElements()) {
                SystemPunkt systemPunkt = (SystemPunkt)object.nextElement();
                Messung messung = systemPunkt.toOrthoMessung();
                if (bl) {
                    messung.setMessungsArt(210);
                    bl = false;
                }
                riss.addElement(messung);
            }
            object = (Messung)riss.lastElement();
            ((Messung)object).setMessungsArt(290);
        }

        MessungGewicht fillOrthoGewichte() {
            MessungGewicht messungGewicht = new MessungGewicht(1.0f, 1.0f, 1.0f, 1.0f);
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
            }
            return messungGewicht;
        }

        public String getNachweis() {
            Object object;
            CountTable countTable = new CountTable();
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                object = (SystemElement)enumeration.nextElement();
                countTable.put(((SystemElement)object).knw);
            }
            int n = 0;
            object = "";
            Enumeration enumeration2 = countTable.keys();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                int n2 = countTable.getCount(string);
                if (n2 <= n) continue;
                n = n2;
                object = string;
            }
            return object;
        }
    }

    private class SystemPunkt
    extends SystemElement {
        Punkt p;
        double o;
        double a;
        float mfA;
        float mfO;

        SystemPunkt(SystraReader systraReader, Punkt punkt, double d, double d2, float f, float f2, String string, String string2) {
            super(systraReader, (f + f2) / 2.0f, string, string2);
            this.p = punkt;
            this.a = d;
            this.o = d2;
            this.mfA = f;
            this.mfO = f2;
        }

        TrafoPunkt toTrafoPunkt() {
            return new TrafoPunkt(this.p, this.o, this.a, new TrafoGewicht(this.mfA, this.mfA));
        }

        Messung toOrthoMessung() {
            Messung messung = new Messung(200, this.p, null, this.a, this.o, 3, new MessungGewicht(1.0f, 1.0f, 1.0f, 1.0f));
            return messung;
        }
    }

    private class SystemKante
    extends SystemElement {
        Punkt p1;
        Punkt p2;
        double s;

        SystemKante(SystraReader systraReader, Punkt punkt, Punkt punkt2, double d, float f, String string, String string2) {
            super(systraReader, f, string, string2);
            this.p1 = punkt;
            this.p2 = punkt2;
            this.s = d;
        }
    }

    private class SystemSchnitt
    extends SystemElement {
        Punkt ps;
        Punkt p11;
        Punkt p12;
        Punkt p21;
        Punkt p22;

        SystemSchnitt(SystraReader systraReader, Punkt punkt, Punkt punkt2, Punkt punkt3, Punkt punkt4, Punkt punkt5, float f, String string, String string2) {
            super(systraReader, f, string, string2);
            this.ps = punkt;
            this.p11 = punkt2;
            this.p12 = punkt3;
            this.p21 = punkt4;
            this.p22 = punkt5;
        }
    }

    private class SystemRichtung
    extends SystemElement {
        Punkt ps;
        Punkt pz;
        double r;

        SystemRichtung(SystraReader systraReader, Punkt punkt, Punkt punkt2, double d, float f, String string, String string2) {
            super(systraReader, f, string, string2);
            this.ps = punkt;
            this.pz = punkt2;
            this.r = d;
        }
    }

    private class SystemRechtWinkel
    extends SystemElement {
        Punkt p1;
        Punkt p2;
        Punkt p3;

        SystemRechtWinkel(SystraReader systraReader, Punkt punkt, Punkt punkt2, Punkt punkt3, float f, String string, String string2) {
            super(systraReader, f, string, string2);
            this.p1 = punkt;
            this.p2 = punkt2;
            this.p3 = punkt3;
            this.mf = f;
        }
    }

    private class SystemGerade
    extends SystemElement {
        Punkt p1;
        Punkt p2;
        Punkt p3;

        SystemGerade(SystraReader systraReader, Punkt punkt, Punkt punkt2, Punkt punkt3, float f, String string, String string2) {
            super(systraReader, f, string, string2);
            this.p1 = punkt;
            this.p2 = punkt2;
            this.p3 = punkt3;
            this.mf = f;
        }
    }

    private class SystemParallele
    extends SystemElement {
        Punkt p1;
        Punkt p2;
        Punkt p3;
        Punkt p4;

        SystemParallele(SystraReader systraReader, Punkt punkt, Punkt punkt2, Punkt punkt3, Punkt punkt4, float f, String string, String string2) {
            super(systraReader, f, string, string2);
            this.p1 = punkt;
            this.p2 = punkt2;
            this.p3 = punkt3;
            this.p4 = punkt4;
            this.mf = f;
        }
    }

    private class SystemBogenSchnitt
    extends SystemElement {
        Punkt ps;
        Punkt p1;
        Punkt p2;

        SystemBogenSchnitt(SystraReader systraReader, Punkt punkt, Punkt punkt2, Punkt punkt3, String string, String string2) {
            super(systraReader, 0.0f, string, string2);
            this.ps = punkt;
            this.p1 = punkt2;
            this.p2 = punkt3;
        }
    }

    private class SystemBogen
    extends SystemElement {
        Punkt pm;
        Punkt pa;
        Punkt pe;
        double r;

        SystemBogen(SystraReader systraReader, Punkt punkt, Punkt punkt2, Punkt punkt3, double d, float f, String string, String string2) {
            super(systraReader, f, string, string2);
            this.pm = punkt;
            this.pa = punkt2;
            this.pe = punkt3;
            this.mf = f;
        }
    }

    private class SystemBogenPunkt
    extends SystemElement {
        Punkt pp;

        SystemBogenPunkt(SystraReader systraReader, Punkt punkt, float f, String string, String string2) {
            super(systraReader, f, string, string2);
            this.pp = punkt;
            this.mf = f;
        }
    }

    private class SystemElement {
        String knw;
        String txt;
        float mf;

        SystemElement(SystraReader systraReader, float f, String string, String string2) {
            this.mf = f;
            this.knw = string;
            this.txt = string2;
        }
    }

    private class SystemPunktAbzisseComparator
    implements Comparator {
        private SystemPunktAbzisseComparator(SystraReader systraReader) {
        }

        @Override
        public int compare(Object object, Object object2) {
            SystemPunkt systemPunkt = (SystemPunkt)object;
            SystemPunkt systemPunkt2 = (SystemPunkt)object2;
            if (systemPunkt.a < systemPunkt2.a) {
                return -1;
            }
            if (systemPunkt.a > systemPunkt2.a) {
                return 1;
            }
            if (systemPunkt.o == systemPunkt2.o) {
                return 0;
            }
            if (systemPunkt.o < 0.0) {
                return systemPunkt.o > systemPunkt2.o ? -1 : 1;
            }
            return systemPunkt.o < systemPunkt2.o ? -1 : 1;
        }
    }

    private class SystemPunktNummerComparator
    implements Comparator {
        private SystemPunktNummerComparator(SystraReader systraReader) {
        }

        @Override
        public int compare(Object object, Object object2) {
            SystemPunkt systemPunkt = (SystemPunkt)object;
            SystemPunkt systemPunkt2 = (SystemPunkt)object2;
            if (systemPunkt.p.nr < systemPunkt2.p.nr) {
                return -1;
            }
            if (systemPunkt.p.nr > systemPunkt2.p.nr) {
                return 1;
            }
            return 0;
        }
    }
}

