/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameterALKIS;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.RissInfo;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.IFileReader;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.dat.SteuerDaten;
import de.geocalc.kafplot.io.sta.StaIOProperties;
import de.geocalc.kafplot.io.sta.StaSigma;
import de.geocalc.text.IFormat;
import de.geocalc.util.CountTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;

public class SystraWriter
extends IFileWriter {
    public static final String TITLE = "SystraWriter";
    public static final String VERSION = "1.0";
    protected DataBase db;
    private PrintWriter sta = null;
    private PrintWriter syp = null;
    private PrintWriter koo = null;
    private PrintWriter kan = null;
    private PrintWriter lok = null;
    private PrintWriter zus = null;
    private PrintWriter sys = null;
    private PrintWriter lin = null;
    private PrintWriter ini = null;
    private PrintWriter pat = null;
    private PrintWriter fat = null;
    private PrintWriter skoo = null;
    private PrintWriter ssys = null;
    private String projektFileName = null;
    private String projektPath = null;
    private CountTable systeme = new CountTable();
    private Hashtable systemNames = new Hashtable();
    private Hashtable systemPoints = new Hashtable();
    private boolean bedingungWithValue = false;
    private boolean isRegOrthoStart = false;
    private String outProjectName = null;
    private String outDate = null;
    private static double oa = 0.0;
    private static double oe = 0.0;
    private Hashtable numbers = new Hashtable();
    private static final int DATE_NOT_USED = 1;
    private static final int DATE_USED = 2;
    private int dateUse = 0;

    public SystraWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
        this.setParameter();
    }

    protected void setParameter() {
        this.outProjectName = DataBase.antrag != null ? DataBase.antrag : this.outFile.getName();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.outDate = IFormat.i02.format(gregorianCalendar.get(5)) + "." + IFormat.i02.format(gregorianCalendar.get(2) + 1) + "." + IFormat.i04.format(gregorianCalendar.get(1));
    }

    @Override
    public void write() throws IFileOutputException {
        Object object;
        Object object2;
        super.setProgress(0);
        String string = null;
        try {
            int n;
            this.projektFileName = this.outFile.getName();
            this.projektPath = this.outFile.getParent();
            this.projektPath = this.projektPath == null ? "" : this.projektPath + File.separator;
            if (this.projektFileName == null) {
                this.projektFileName = "KafToSystra";
            }
            if ((n = this.projektFileName.lastIndexOf(".")) > 0) {
                this.projektFileName = this.projektFileName.substring(0, n);
            }
            this.projektFileName = this.projektFileName + "_SYSTRA";
            string = this.projektPath + this.projektFileName;
            this.syp = this.createWriter(new File(string + ".syp"));
            this.koo = this.createWriter(new File(string + ".koo"));
            this.fat = this.createWriter(new File(string + ".fat"));
            this.kan = this.createWriter(new File(string + ".kan"));
            this.lok = this.createWriter(new File(string + ".lok"));
            this.zus = this.createWriter(new File(string + ".zus"));
            this.sys = this.createWriter(new File(string + ".sys"));
            this.lin = this.createWriter(new File(string + ".lin"));
            this.pat = this.createWriter(new File(string + ".pat"));
            this.sta = this.createWriter(new File(this.projektPath + "SYSTRA.sta"));
            this.skoo = this.createWriter(new File(this.projektPath + "SYSTRA.koo"));
            this.ssys = this.createWriter(new File(this.projektPath + "SYSTRA.sys"));
            try {
                string = this.projektPath + this.projektFileName + ".ini";
                try {
                    object2 = IFileReader.createFileReader(new File("systra.ini"));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    object2 = IFileReader.createStreamReader(this.getClass().getResourceAsStream("/systra.ini"));
                }
                this.ini = this.createWriter(new File(string));
                object = null;
                while ((object = ((LineNumberReader)object2).readLine()) != null) {
                    this.ini.println((String)object);
                }
                this.ini.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            throw new IFileOutputException("Fehler beim Erzeugen der Datei: " + string);
        }
        try {
            StringBuffer stringBuffer;
            Linie linie;
            Enumeration enumeration;
            Object object3;
            Object object4;
            Object object5;
            this.sta.println("INI=" + this.projektFileName);
            this.sta.println("KOOR=" + this.projektFileName);
            this.sta.println("LOKOOR=" + this.projektFileName);
            this.sta.println("KANTE=" + this.projektFileName);
            this.sta.println("LINIE=" + this.projektFileName);
            this.sta.println("ZUSATZ=" + this.projektFileName);
            this.sta.println("SYSTEM=" + this.projektFileName);
            this.sta.println("BATCH=");
            this.sta.println("PAT=" + this.projektFileName);
            this.sta.close();
            this.syp.println("[programminfo]");
            this.syp.println("version=7.0");
            this.syp.println("programm=SYSTRA");
            this.syp.println("louterr=SYSTRA");
            this.syp.println("beginn=" + this.outDate);
            this.syp.println("lbearb=" + this.outDate);
            this.syp.println("ende=" + this.outDate);
            this.syp.println("[SYSTRASHELL]");
            this.syp.println("MODUS3D = 0");
            this.syp.close();
            PunktTable punktTable = new PunktTable();
            SystraWriter systraWriter = this;
            object2 = systraWriter.db.gpsMessungen();
            while (object2.hasMoreElements()) {
                object = (Messung)object2.nextElement();
                if (((Messung)object).ps != null) {
                    punktTable.put(((Messung)object).ps);
                }
                if (((Messung)object).pz == null) continue;
                punktTable.put(((Messung)object).pz);
            }
            object2 = DataBase.P.elements();
            while (object2.hasMoreElements()) {
                object = (Punkt)object2.nextElement();
                if (!((Punkt)object).isOn() && !StaIOProperties.writeUnusedPoints()) continue;
                object5 = StaIOProperties.getPunktNummer((Punkt)object);
                if (((Punkt)object).getInternalPs() == 0 && ((Punkt)object).isKatasterPunkt()) {
                    this.koo.println(this.getKooLine((Punkt)object, false));
                }
                if (!(((Punkt)object).getParameter() instanceof PunktParameterALKIS)) continue;
                object4 = (PunktParameterALKIS)((Punkt)object).getParameter();
                if (((PunktParameterALKIS)object4).getKafVa() > 0) {
                    this.pat.println((String)object5 + IFormat.getRightString("ABM", 15) + "          " + IFormat.getRightString(((PunktParameterALKIS)object4).getOutVa(), 15));
                }
                if (((PunktParameterALKIS)object4).getKafVb() > 0) {
                    this.pat.println((String)object5 + IFormat.getRightString("BZA", 15) + "          " + IFormat.getRightString(((PunktParameterALKIS)object4).getOutVb(), 15));
                }
                if ((object3 = ((Punkt)object).getBemerkungText()) != null) {
                    this.pat.println((String)object5 + IFormat.getRightString("TEXT", 15) + "          " + IFormat.getRightString((String)object3, 15));
                }
                if (((Punkt)object).isKatasterAenderungElement() || ((Punkt)object).isKatasterNeuElement()) {
                    this.pat.println((String)object5 + IFormat.getRightString("ENTSTEHUNG", 15) + "          " + IFormat.getRightString(this.outProjectName, 15));
                } else if (((Punkt)object).getRiss() != null) {
                    this.pat.println((String)object5 + IFormat.getRightString("ENTSTEHUNG", 15) + "          " + IFormat.getRightString(((Punkt)object).getRiss(), 15));
                }
                if (!((Punkt)object).isKatasterNeuElement() || ((PunktParameterALKIS)object4).getOska() <= 0) continue;
                this.pat.println((String)object5 + IFormat.getRightString("OA", 15) + "          " + IFormat.getRightString(((PunktParameterALKIS)object4).getOutOska(), 15));
            }
            this.koo.close();
            this.pat.close();
            object2 = DataBase.P.elements();
            while (object2.hasMoreElements()) {
                object = (Punkt)object2.nextElement();
                if (!((Punkt)object).isOn() && (((Punkt)object).getInternalPs() != 0 || !((Punkt)object).isKatasterPunkt())) continue;
                this.skoo.println(this.getKooLine((Punkt)object, true));
            }
            this.skoo.close();
            this.setProgress(10);
            this.bedingungWithValue = false;
            object2 = this.getSchnittPoints();
            object = ((Hashtable)object2).elements();
            while (object.hasMoreElements()) {
                this.writeSchnitt((Schnitt)object.nextElement());
            }
            this.zus.println("");
            this.zus.println("");
            this.zus.println("");
            this.bedingungWithValue = true;
            this.setProgress(15);
            this.writeRissList(DataBase.MG, false);
            this.setProgress(20);
            this.writeRissList(DataBase.MP, false);
            this.setProgress(25);
            this.writeRissList(DataBase.MM, false);
            this.setProgress(30);
            this.writeRissList(DataBase.MK, true);
            this.setProgress(40);
            this.writeRissList(DataBase.ME, false);
            this.setProgress(45);
            this.writeRissList(DataBase.MV, false);
            this.setProgress(50);
            this.zus.println("");
            this.bedingungWithValue = true;
            this.writeBedingungList(DataBase.BB, true, 0);
            this.writeBedingungList(DataBase.BH, false, 0);
            this.writeBedingungList(DataBase.BB, true, 4);
            this.writeBedingungList(DataBase.BH, false, 4);
            this.writeBedingungList(DataBase.BB, true, 5);
            this.writeBedingungList(DataBase.BH, false, 5);
            this.setProgress(55);
            this.writeTrafoList(DataBase.T);
            if (StaIOProperties.writeApproxPoints()) {
                this.writeApproxSystem();
            }
            this.setProgress(60);
            this.bedingungWithValue = false;
            this.writeBedingungList(DataBase.BB, true, 2);
            this.writeBedingungList(DataBase.BH, false, 2);
            this.zus.println("");
            this.writeBedingungList(DataBase.BB, true, 1);
            this.writeBedingungList(DataBase.BH, false, 1);
            this.zus.println("");
            this.writeBedingungList(DataBase.BB, true, 0);
            this.writeBedingungList(DataBase.BH, false, 0);
            this.zus.println("");
            if (StaIOProperties.writeBogenSchnittDef()) {
                this.writeBogenSchnittList(DataBase.MG);
                this.writeBogenSchnittList(DataBase.MP);
                this.writeBogenSchnittList(DataBase.MM);
                this.writeBogenSchnittList(DataBase.MK);
                this.writeBogenSchnittList(DataBase.ME);
                this.writeBogenSchnittList(DataBase.MV);
            }
            this.zus.println("");
            this.zus.println("");
            this.zus.println("");
            this.lok.close();
            this.zus.close();
            this.sys.close();
            this.kan.close();
            this.setProgress(70);
            object = this.db.getLinien().elements();
            while (object.hasMoreElements()) {
                object5 = (Linie)object.nextElement();
                if (!((Linie)object5).pa.isKatasterPunkt() || ((Linie)object5).pe != null && !((Linie)object5).pe.isKatasterPunkt()) continue;
                object4 = new StringBuffer();
                ((StringBuffer)object4).append(StaIOProperties.getPunktNummer(((Linie)object5).pa));
                ((StringBuffer)object4).append(StaIOProperties.getPunktNummer(((Linie)object5).pe));
                ((StringBuffer)object4).append(IFormat.getSpaces(31));
                ((StringBuffer)object4).append(IFormat.getRightString(DataBase.antrag != null ? DataBase.antrag : "Global", 15));
                ((StringBuffer)object4).append(IFormat.getRightString("" + ((Linie)object5).getOska(), 19));
                this.lin.println(((StringBuffer)object4).toString());
            }
            this.lin.println("");
            this.lin.println("");
            this.lin.println("");
            this.setProgress(80);
            int n = 0;
            object5 = "";
            object4 = DataBase.FLST.elements();
            while (object4.hasMoreElements()) {
                object3 = (Flurstueck)object4.nextElement();
                ((GObject)object3).setTempFlag1(true);
                enumeration = ((DataContainer)object3).elements();
                while (enumeration.hasMoreElements()) {
                    linie = (Linie)enumeration.nextElement();
                    if (linie.pe == null || linie.pa.isKatasterPunkt() && linie.pe.isKatasterPunkt()) continue;
                    ((GObject)object3).setTempFlag1(false);
                    break;
                }
                if (!((GObject)object3).isTempFlag1()) continue;
                object5 = ((Flurstueck)object3).getNummer();
                this.fat.println(IFormat.i15.format(++n) + IFormat.getRightString("FOLIE", 15) + "          " + IFormat.i15.format(((DataContainer)object3).getOska()));
                this.fat.println(IFormat.i15.format(n) + IFormat.getRightString("NAME", 15) + IFormat.getRightString((String)object5, 25));
                this.fat.println(IFormat.i15.format(n) + IFormat.getRightString("SYSTEM", 15) + IFormat.getRightString(this.outProjectName, 25));
                this.fat.println(IFormat.i15.format(n) + IFormat.getRightString("BFL", 15) + IFormat.getRightString(((Flurstueck)object3).getBuchFlaecheAsString(), 25));
                this.fat.println(IFormat.i15.format(n) + IFormat.getRightString("FKZ", 15) + IFormat.getRightString(((Flurstueck)object3).getAlkLongKennzeichen(), 25));
                enumeration = ((DataContainer)object3).elements();
                while (enumeration.hasMoreElements()) {
                    linie = (Linie)enumeration.nextElement();
                    if (linie.pe == null) continue;
                    stringBuffer = new StringBuffer(120);
                    stringBuffer.append(IFormat.i15.format(n));
                    stringBuffer.append(StaIOProperties.getPunktNummer(linie.pa));
                    stringBuffer.append(StaIOProperties.getPunktNummer(linie.pe));
                    stringBuffer.append(" ");
                    stringBuffer.append("               ");
                    stringBuffer.append(IFormat.getRightString(this.outProjectName, 15));
                    stringBuffer.append(IFormat.i15.format(linie.getOska()));
                    stringBuffer.append(IFormat.getRightString((String)object5, 14));
                    stringBuffer.append(IFormat.i5.format(0L));
                    this.lin.println(stringBuffer.toString());
                }
            }
            this.setProgress(90);
            object4 = DataBase.GEB.elements();
            while (object4.hasMoreElements()) {
                object3 = (Gebaeude)object4.nextElement();
                ((GObject)object3).setTempFlag1(true);
                enumeration = ((DataContainer)object3).elements();
                while (enumeration.hasMoreElements()) {
                    linie = (Linie)enumeration.nextElement();
                    if (linie.pe == null || linie.pa.isKatasterPunkt() && linie.pe.isKatasterPunkt()) continue;
                    ((GObject)object3).setTempFlag1(false);
                    break;
                }
                if (!((GObject)object3).isTempFlag1()) continue;
                object5 = Integer.toString(((Gebaeude)object3).getFunktion());
                this.fat.println(IFormat.i15.format(++n) + IFormat.getRightString("FOLIE", 15) + "          " + IFormat.i15.format(((DataContainer)object3).getOska()));
                this.fat.println(IFormat.i15.format(n) + IFormat.getRightString("NAME", 15) + IFormat.getRightString((String)object5, 25));
                this.fat.println(IFormat.i15.format(n) + IFormat.getRightString("SYSTEM", 15) + IFormat.getRightString(this.outProjectName, 25));
                enumeration = ((DataContainer)object3).elements();
                while (enumeration.hasMoreElements()) {
                    linie = (Linie)enumeration.nextElement();
                    if (linie.pe == null || linie.isLinie()) continue;
                    stringBuffer = new StringBuffer(120);
                    stringBuffer.append(IFormat.i15.format(n));
                    stringBuffer.append(StaIOProperties.getPunktNummer(linie.pa));
                    stringBuffer.append(StaIOProperties.getPunktNummer(linie.pe));
                    stringBuffer.append(" ");
                    stringBuffer.append("               ");
                    stringBuffer.append(IFormat.getRightString(this.outProjectName, 15));
                    stringBuffer.append(IFormat.i15.format(linie.getOska()));
                    stringBuffer.append(IFormat.getRightString((String)object5, 14));
                    stringBuffer.append(IFormat.i5.format(0L));
                    this.lin.println(stringBuffer.toString());
                }
            }
            this.setProgress(95);
            this.fat.close();
            this.lin.close();
            this.ssys.close();
            this.setProgress(100);
        }
        catch (Exception exception) {
            this.kan.close();
            this.lok.close();
            this.zus.close();
            this.sys.close();
            this.lin.close();
            this.ssys.close();
            exception.printStackTrace();
            throw new IFileOutputException("Es ist ein nicht klassifizierbarer Fehler bei der Ausgabe der Systradateien entstanden. Die Daten wurden nicht vollst\u00e4ndig ausgegeben. Bitte pr\u00fcfen Sie die Dateneingabe auf logische Fehler. Meldung: " + exception.getMessage());
        }
        super.setProgress(100);
    }

    private String getKooLine(Punkt punkt, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(300);
        DPoint dPoint = bl ? punkt : punkt.getOriginal();
        stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
        stringBuffer.append("   ");
        stringBuffer.append(KafkaIOProperties.meridianDecade);
        stringBuffer.append(IFormat.f7_3.format(dPoint.y));
        stringBuffer.append("    ");
        stringBuffer.append(IFormat.f7_3.format(dPoint.x));
        stringBuffer.append("     ");
        stringBuffer.append(IFormat.f5_4.format(KafkaIOProperties.writeHoehe && punkt.h != 0.0f ? (double)punkt.h : DataBase.getGelHoehe()));
        stringBuffer.append(" ");
        if (punkt.getPs() == 1 || punkt.getPs() == 2) {
            stringBuffer.append(IFormat.f5_3.format((double)punkt.getGl() * 100.0));
        } else {
            stringBuffer.append("         ");
        }
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.i1.format(punkt.getPs() == 1 || punkt.getPs() == 2 ? 1L : 9L));
        stringBuffer.append(IFormat.getSpaces(68));
        stringBuffer.append(IFormat.getRightString(punkt.hasBemerkung() ? punkt.getBemerkungText() : "", 55));
        stringBuffer.append(" ");
        stringBuffer.append("          ");
        stringBuffer.append(" ");
        stringBuffer.append("                    ");
        stringBuffer.append("   ");
        stringBuffer.append(this.outDate);
        stringBuffer.append(" ");
        stringBuffer.append("               ");
        stringBuffer.append(IFormat.getSpaces(30));
        return stringBuffer.toString();
    }

    private Hashtable getSchnittPoints() {
        Cloneable cloneable;
        Hashtable<Punkt, Object> hashtable = new Hashtable<Punkt, Object>();
        Punkt punkt = null;
        Punkt punkt2 = null;
        SystraWriter systraWriter = this;
        Enumeration enumeration = systraWriter.db.messungen();
        while (enumeration.hasMoreElements()) {
            Object object;
            cloneable = (Messung)enumeration.nextElement();
            int n = ((Messung)cloneable).getMessungsArt();
            int n2 = ((Messung)cloneable).getWerteBelegung();
            if (n == 210) {
                punkt = null;
                punkt2 = null;
                if (((Messung)cloneable).l2 == 0.0) {
                    punkt = ((Messung)cloneable).ps;
                } else if (((Messung)cloneable).pz != null && ((Messung)cloneable).pz.nr != 0L) {
                    punkt = ((Messung)cloneable).pz;
                }
                object = ((Messung)cloneable).getReferenz();
                if (((Messung)object).l2 == 0.0) {
                    punkt2 = ((Messung)object).ps;
                } else if (((Messung)object).pz != null && ((Messung)object).pz.nr != 0L) {
                    punkt2 = ((Messung)cloneable).pz;
                }
            }
            if (n != 200 || n2 != 0) continue;
            if (punkt != null && punkt2 != null) {
                object = (Schnitt)hashtable.get(((Messung)cloneable).getP1());
                if (object == null) {
                    object = new Schnitt(this);
                    ((Schnitt)object).s = ((Messung)cloneable).getP1();
                    ((Schnitt)object).p1 = punkt;
                    ((Schnitt)object).p2 = punkt2;
                    hashtable.put(((Messung)cloneable).getP1(), object);
                    continue;
                }
                if (((Schnitt)object).p3 != null || ((Schnitt)object).p1 == punkt || ((Schnitt)object).p2 == punkt || ((Schnitt)object).p1 == punkt2 || ((Schnitt)object).p2 == punkt2) continue;
                ((Schnitt)object).p3 = punkt;
                ((Schnitt)object).p4 = punkt2;
                continue;
            }
            if (punkt == null) {
                this.addException(new Exception("Fluchtpunkt " + ((Messung)cloneable).ps.nr + " ist in einer Ortholinie mit seitlichem Anfangsma\u00df enthalten, dort den Fu\u00dfpunkt setzen"));
            }
            if (punkt2 != null) continue;
            this.addException(new Exception("Fluchtpunkt " + ((Messung)cloneable).ps.nr + " ist in einer Ortholinie mit seitlichem Endma\u00df enthalten, dort den Fu\u00dfpunkt setzen"));
        }
        SystraWriter systraWriter2 = this;
        enumeration = systraWriter2.db.allBedingungen();
        while (enumeration.hasMoreElements()) {
            cloneable = (Bedingung)enumeration.nextElement();
            if (((Bedingung)cloneable).ba != 1) continue;
            Schnitt schnitt = (Schnitt)hashtable.get(((Bedingung)cloneable).getP2());
            if (schnitt == null) {
                schnitt = new Schnitt(this);
                schnitt.s = ((Bedingung)cloneable).getP2();
                schnitt.p1 = ((Bedingung)cloneable).getP1();
                schnitt.p2 = ((Bedingung)cloneable).getP3();
                continue;
            }
            if (schnitt.p3 != null || schnitt.p1 == ((Bedingung)cloneable).getP1() || schnitt.p2 == ((Bedingung)cloneable).getP1() || schnitt.p1 == ((Bedingung)cloneable).getP3() || schnitt.p2 == ((Bedingung)cloneable).getP3()) continue;
            schnitt.p3 = ((Bedingung)cloneable).getP1();
            schnitt.p4 = ((Bedingung)cloneable).getP3();
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            cloneable = (Punkt)enumeration.nextElement();
            Schnitt schnitt = (Schnitt)hashtable.get(cloneable);
            if (schnitt.p3 != null) continue;
            hashtable.remove(cloneable);
        }
        return hashtable;
    }

    private String createSysName(String object, String string, boolean bl) {
        if (string == StaIOProperties.SYS_NAME_SPANNMASS) {
            return "               ";
        }
        if (((String)object).length() > 11) {
            this.addException(new Exception("Systemkennung '" + (String)object + "' l\u00e4nger als 11 Zeichen, Kennung wird gek\u00fcrzt"));
        }
        StringBuffer stringBuffer = new StringBuffer(15);
        if (string == StaIOProperties.SYS_NAME_ORTHO || string == StaIOProperties.SYS_NAME_FLUCHT || string == StaIOProperties.SYS_NAME_TRAFO) {
            object = "S" + (String)object;
        }
        object = IFormat.getRightString((String)object, 12);
        stringBuffer.append((String)object);
        stringBuffer.append(StaIOProperties.SYS_NAME_DELIM);
        stringBuffer.append(string);
        String string2 = stringBuffer.toString();
        if (bl) {
            String string3 = "00";
            this.systeme.put(string2);
            int n = this.systeme.getCount(string2);
            if (n > 99) {
                this.addException(new Exception("Systemnummerierung f\u00fcr " + stringBuffer.toString() + " gr\u00f6\u00dfer 99, Nummer wird durch Zeichen ersetzt"));
                try {
                    string3 = this.getOverflowSysNr(n);
                }
                catch (Exception exception) {
                    this.addException(new Exception("FATAL: Systemnummerierung f\u00fcr " + stringBuffer.toString() + " gr\u00f6\u00dfer 625, SystemNummer\u00fcberlauf mit ** gekennzeichnet"));
                    string3 = "**";
                }
            } else {
                string3 = IFormat.i02.format(n);
            }
            stringBuffer.append(string3);
            String string4 = stringBuffer.toString();
            this.systemNames.put(string2, string4);
            return string4;
        }
        stringBuffer.append("00");
        return stringBuffer.toString();
    }

    private String getOverflowSysNr(int n) throws Exception {
        if (n < 100) {
            return IFormat.i02.format(n);
        }
        int n2 = (n -= 100) / 25;
        int n3 = n % 25;
        if (n2 > 25) {
            throw new Exception();
        }
        StringBuffer stringBuffer = new StringBuffer(2);
        stringBuffer.append((char)(97 + n2));
        stringBuffer.append((char)(97 + n3));
        return stringBuffer.toString();
    }

    private char toChar(int n) {
        return (char)(n + 97);
    }

    private String getSysName(String object, String string) {
        StringBuffer stringBuffer = new StringBuffer(15);
        if (string == StaIOProperties.SYS_NAME_ORTHO || string == StaIOProperties.SYS_NAME_FLUCHT || string == StaIOProperties.SYS_NAME_TRAFO) {
            object = "S" + (String)object;
        }
        stringBuffer.append(IFormat.getRightString((String)object, 12));
        stringBuffer.append(StaIOProperties.SYS_NAME_DELIM);
        stringBuffer.append(string);
        String string2 = stringBuffer.toString();
        String string3 = (String)this.systemNames.get(string2);
        if (string3 == null) {
            this.addException(new Exception("Interner Fehler im System " + string2 + " Messung ohne Standpunkt"));
        }
        return string3;
    }

    private void writeTrafoList(Vector vector) throws Exception {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TrafoSystem trafoSystem = (TrafoSystem)enumeration.nextElement();
            this.writeTrafoSystem(trafoSystem);
        }
    }

    private void writeTrafoSystem(TrafoSystem trafoSystem) throws Exception {
        if (trafoSystem.size() == 0) {
            return;
        }
        String string = trafoSystem.getKeyString();
        String string2 = this.createSysName(string, StaIOProperties.SYS_NAME_TRAFO, true);
        String string3 = trafoSystem.getDate() != null ? trafoSystem.getDate() : this.outDate;
        RissInfo rissInfo = trafoSystem.getRissInfo();
        this.testDate(rissInfo, trafoSystem.getName(), trafoSystem.getDate());
        String string4 = "LokKoo";
        if (rissInfo.getTyp() == 2) {
            string4 = StaIOProperties.listToString(204);
        } else if (rissInfo.getTyp() == 8) {
            string4 = StaIOProperties.listToString(401);
        } else if (rissInfo.getTyp() == 9) {
            string4 = StaIOProperties.listToString(402);
        }
        TrafoPunkt trafoPunkt = (TrafoPunkt)trafoSystem.elementAt(0);
        String string5 = StaIOProperties.writeAllAsDigit() ? "DIG" : (rissInfo.getTyp() == 9 ? "DIG" : "   ");
        StaSigma staSigma = StaSigma.getDigSigma(trafoPunkt.getGewichte());
        String string6 = staSigma.getName();
        this.sys.println(this.sysLine(trafoSystem.getParameter(), string2, 0.0f, staSigma.getS2() * 100.0f, staSigma.getS2() * 100.0f, string5, string6, string4, string3));
        double[] dArray = trafoSystem.getTransformParam();
        DPoint dPoint = trafoSystem.getSourceCenter();
        dPoint = dPoint.y > 100000.0 && dPoint.x > 100000.0 ? trafoSystem.getTransformPoint(new DPoint(dPoint.y - dPoint.y % 100000.0, dPoint.x - dPoint.x % 100000.0)) : trafoSystem.getTransformPoint(new DPoint(0.0, 0.0));
        this.ssys.println(this.sSysLine(Math.max(trafoSystem.getParameter(), 3), string2, dPoint.x, dPoint.y, dArray[0], dArray[1], dArray[3], dArray[2]));
        this.systemPoints.clear();
        float f = trafoPunkt.getGewichte().getG1();
        Enumeration enumeration = trafoSystem.elements();
        while (enumeration.hasMoreElements()) {
            TrafoPunkt trafoPunkt2 = (TrafoPunkt)enumeration.nextElement();
            if (!trafoPunkt2.isOn()) continue;
            TrafoPunkt trafoPunkt3 = (TrafoPunkt)this.systemPoints.get(trafoPunkt2.getPunkt());
            if (trafoPunkt3 != null) {
                this.addException(new Exception("Der Punkt " + trafoPunkt2.getPunkt().nr + " ist mehrfach im Trafosystem " + string2 + " enthalten"));
                continue;
            }
            String string7 = trafoPunkt2.getBemerkungText() != null ? trafoPunkt2.getBemerkungText() : "";
            StringBuffer stringBuffer = new StringBuffer(250);
            stringBuffer.append(string2);
            stringBuffer.append(StaIOProperties.getPunktNummer(trafoPunkt2.getPunkt()));
            stringBuffer.append(IFormat.f10_4.format(trafoPunkt2.y));
            stringBuffer.append(IFormat.f10_4.format(trafoPunkt2.x));
            stringBuffer.append("               ");
            float f2 = trafoPunkt2.getGewichte().getG1();
            float f3 = f2 == f ? 0.0f : (float)((double)f2 * 100.0);
            stringBuffer.append(IFormat.f7_2.format(f3));
            stringBuffer.append(IFormat.f7_2.format(f3));
            stringBuffer.append(IFormat.f5_4.format(0.0));
            this.appendTexts(stringBuffer, string5, string, string7, string4, string3);
            this.lok.println(stringBuffer.toString());
            this.systemPoints.put(trafoPunkt2.getPunkt(), trafoPunkt2);
        }
    }

    private void writeApproxSystem() throws Exception {
        String string = "      NAEHERUNG";
        String string2 = "NAEHERUNG";
        String string3 = "Naeherung";
        String string4 = this.outDate;
        this.sys.println(this.sysLine(3, string, (float)StaIOProperties.aMf, (float)StaIOProperties.aMf, (float)StaIOProperties.aMf, "DIG", string2 + StaIOProperties.SYS_NAME_TRAFO, string3, string4));
        DPoint dPoint = new DPoint(0.0, 0.0);
        if (DataBase.ymin > 100000.0) {
            if (DataBase.xmin > 100000.0) {
                dPoint.y = DataBase.ymin - DataBase.ymin % 100000.0;
                dPoint.x = DataBase.xmin - DataBase.xmin % 100000.0;
            }
        }
        this.ssys.println(this.sSysLine(3, string, dPoint.x, dPoint.y, 1.0, 0.0, 0.0, 1.0));
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!punkt.isOn()) continue;
            StringBuffer stringBuffer = new StringBuffer(250);
            stringBuffer.append(string);
            stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
            stringBuffer.append(IFormat.f10_4.format(punkt.y));
            stringBuffer.append(IFormat.f10_4.format(punkt.x));
            stringBuffer.append(IFormat.f10_4.format(0.0));
            stringBuffer.append(IFormat.f7_2.format(0.0));
            stringBuffer.append(IFormat.f7_2.format(0.0));
            stringBuffer.append(IFormat.f5_4.format(0.0));
            this.appendTexts(stringBuffer, "DIG", string2, "", string3, string4);
            this.lok.println(stringBuffer.toString());
        }
    }

    private void writeRissList(Vector vector, boolean bl) throws Exception {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            this.writeRiss(riss, bl);
        }
    }

    private void writeRiss(Riss riss, boolean bl) throws Exception {
        String string = "   ";
        String string2 = StaIOProperties.listToString(riss.getRissInfo().getList());
        String string3 = bl ? riss.getKeyString() : string2;
        String string4 = riss.getDate() != null ? riss.getDate() : this.outDate;
        this.testDate(riss.getRissInfo(), riss.getName(), riss.getDate());
        for (int i = 0; i < riss.size(); ++i) {
            Messung messung;
            Messung messung2 = (Messung)riss.elementAt(i);
            Messung messung3 = messung = i < riss.size() - 1 ? (Messung)riss.elementAt(i + 1) : null;
            if (!messung2.isOn()) continue;
            int n = messung2.getMessungsArt(false);
            if (n == 210 && this.testFlucht(riss, i)) {
                string = "FLU";
            }
            this.writeMessung(messung2, string2, string3, string4, string, messung);
            if (n != 290) continue;
            string = "   ";
        }
    }

    private boolean testFlucht(Riss riss, int n) {
        int n2 = 0;
        while (n < riss.size()) {
            Messung messung = (Messung)riss.elementAt(n);
            int n3 = messung.getWerteBelegung();
            if (n3 == 1 || n3 == 3) {
                ++n2;
            }
            if (messung.getMessungsArt(false) == 290) break;
            ++n;
        }
        return n2 < 2;
    }

    private void writeMessung(Messung messung, String string, String string2, String string3, String string4, Messung messung2) throws Exception {
        Object object;
        boolean bl = StaIOProperties.writeIndividualGewicht();
        double d = StaIOProperties.getMfFactor();
        if (messung.isFehler() && !StaIOProperties.writeErrorValues()) {
            return;
        }
        int n = messung.getWerteBelegung();
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        MessungGewicht messungGewicht = null;
        if (messung.hasGewichte()) {
            object = messung.getGewichte();
            if (((MessungGewicht)object).hasG1()) {
                d2 = ((MessungGewicht)object).getG1();
            }
            if (((MessungGewicht)object).hasG2()) {
                d3 = ((MessungGewicht)object).getG2();
            }
            if (((MessungGewicht)object).hasG3()) {
                d4 = ((MessungGewicht)object).getG3();
            }
            if (((MessungGewicht)object).hasG4()) {
                d5 = ((MessungGewicht)object).getG4();
            }
        }
        SystraWriter systraWriter = this;
        object = systraWriter.db.getSteuerDaten();
        Punkt punkt = messung.getP1();
        Punkt punkt2 = messung.getP2();
        String string5 = messung.getBemerkungText();
        if (string5 == null) {
            string5 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        switch (messung.getMessungsArt(false)) {
            case 230: 
            case 280: {
                StringBuffer stringBuffer = null;
                if (messung.ps != null) {
                    this.sys.println(this.sysLine(3, this.createSysName(string2, StaIOProperties.SYS_NAME_POLAR, true), 0.0f, 0.0f, 0.0f, "POL", string + StaIOProperties.SYS_NAME_POLAR, string, string3));
                }
                if (n == 1 || n == 3) {
                    stringBuffer = new StringBuffer(210);
                    stringBuffer.append(this.getSysName(string2, StaIOProperties.SYS_NAME_POLAR));
                    stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
                    stringBuffer.append(StaIOProperties.getPunktNummer(punkt2));
                    stringBuffer.append("   ");
                    stringBuffer.append(IFormat.f7_4.format(messung.l1));
                    if (messung.isFehler()) {
                        stringBuffer.append(IFormat.f7_2.format(StaIOProperties.eMf));
                    } else {
                        stringBuffer.append(IFormat.f7_2.format(bl ? ((SteuerDaten)object).getRichtungMf(messung.l1, d2) * d * 1000.0 : 0.0));
                    }
                    stringBuffer.append(IFormat.getSpaces(55));
                    this.appendTexts(stringBuffer, string5, string, string3);
                    this.zus.println(stringBuffer.toString());
                }
                if (n != 2 && n != 3) break;
                stringBuffer = new StringBuffer(210);
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt2));
                stringBuffer.append("   ");
                stringBuffer.append(IFormat.f7_4.format(messung.l2));
                if (messung.isFehler()) {
                    stringBuffer.append(IFormat.f7_2.format(StaIOProperties.eMf));
                } else {
                    stringBuffer.append(IFormat.f7_2.format(bl ? ((SteuerDaten)object).getEdmMf(messung.l2, d3) * d * 100.0 : 0.0));
                }
                stringBuffer.append("POLAR");
                stringBuffer.append(" ");
                stringBuffer.append(IFormat.getRightString(string2, 15));
                stringBuffer.append("    ");
                stringBuffer.append(this.getSysName(string2, StaIOProperties.SYS_NAME_POLAR));
                stringBuffer.append(IFormat.getSpaces(30));
                this.appendTexts(stringBuffer, string5, string, string3);
                this.kan.println(stringBuffer.toString());
                break;
            }
            case 270: {
                StringBuffer stringBuffer = null;
                if (messung.ps != null) {
                    float f = (float)((SteuerDaten)object).getGpsMf(messung.l1, messung.l2, d2, d3);
                    this.sys.println(this.sysLine(3, this.createSysName(string2, StaIOProperties.SYS_NAME_GPS, true), f, f, f, "   ", string + StaIOProperties.SYS_NAME_GPS, string, string3));
                    stringBuffer = new StringBuffer(200);
                    stringBuffer.append(this.getSysName(string2, StaIOProperties.SYS_NAME_GPS));
                    stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
                    stringBuffer.append(IFormat.f10_4.format(0.0));
                    stringBuffer.append(IFormat.f10_4.format(0.0));
                    stringBuffer.append("               ");
                    stringBuffer.append("          ");
                    stringBuffer.append("          ");
                    stringBuffer.append("          ");
                    this.appendTexts(stringBuffer, "   ", string2, string5, string, string3);
                    this.lok.println(stringBuffer.toString());
                }
                stringBuffer = new StringBuffer(200);
                stringBuffer.append(this.getSysName(string2, StaIOProperties.SYS_NAME_GPS));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt2));
                stringBuffer.append(IFormat.f10_4.format(messung.l1));
                stringBuffer.append(IFormat.f10_4.format(messung.l2));
                stringBuffer.append("               ");
                stringBuffer.append("          ");
                stringBuffer.append("          ");
                stringBuffer.append("          ");
                this.appendTexts(stringBuffer, "   ", string2, string5, string, string3);
                this.lok.println(stringBuffer.toString());
                break;
            }
            case 220: 
            case 260: {
                StringBuffer stringBuffer = new StringBuffer(210);
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt2));
                stringBuffer.append(IFormat.f10_4.format(messung.l1));
                if (messung.isFehler()) {
                    stringBuffer.append(IFormat.f7_2.format(StaIOProperties.eMf));
                } else {
                    stringBuffer.append(IFormat.f7_2.format(bl ? ((SteuerDaten)object).getMassMf(messung.l1, d2) * d * 100.0 : 0.0));
                }
                stringBuffer.append("     ");
                stringBuffer.append(" ");
                stringBuffer.append(IFormat.getRightString(string2, 15));
                stringBuffer.append("    ");
                stringBuffer.append(this.createSysName(string2, StaIOProperties.SYS_NAME_SPANNMASS, false));
                stringBuffer.append(IFormat.getSpaces(30));
                this.appendTexts(stringBuffer, string5, string, string3);
                this.kan.println(stringBuffer.toString());
                break;
            }
            case 240: {
                double d6 = Math.min(Math.abs(messung.l1 - oa), Math.abs(oe - messung.l1));
                StringBuffer stringBuffer = new StringBuffer(210);
                stringBuffer.append(this.getSysName(string2, StaIOProperties.SYS_NAME_ORTHO));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
                stringBuffer.append(IFormat.f10_4.format(0.0));
                stringBuffer.append(IFormat.f10_4.format(messung.l1));
                stringBuffer.append(IFormat.f10_4.format(0.0));
                if (messung.isFehler()) {
                    stringBuffer.append(IFormat.f7_2.format(StaIOProperties.eMf));
                    stringBuffer.append(IFormat.f7_2.format(StaIOProperties.eMf));
                } else {
                    stringBuffer.append(IFormat.f7_2.format(bl ? ((SteuerDaten)object).getOrdMf(0.0, d3, d4) * d * 100.0 : 0.0));
                    stringBuffer.append(IFormat.f7_2.format(bl ? ((SteuerDaten)object).getAbszMf(d6, 0.0, d2, d5) * d * 100.0 : 0.0));
                }
                stringBuffer.append(IFormat.f5_4.format(0.0));
                stringBuffer.append("   ");
                stringBuffer.append("  ");
                this.appendTexts(stringBuffer, string2, string5, string, string3);
                this.lok.println(stringBuffer.toString());
                stringBuffer = new StringBuffer(210);
                if (!messung.isFehler()) {
                    this.systemPoints.put(punkt, new Messung(200, punkt, null, messung.l1, 0.0));
                }
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt2));
                stringBuffer.append(IFormat.f10_4.format(messung.l2));
                if (messung.isFehler()) {
                    stringBuffer.append(IFormat.f7_2.format(StaIOProperties.eMf));
                } else {
                    stringBuffer.append(IFormat.f7_2.format(bl ? ((SteuerDaten)object).getMassMf(messung.l2, d3) * d * 100.0 : 0.0));
                }
                stringBuffer.append("     ");
                stringBuffer.append(" ");
                stringBuffer.append(IFormat.getRightString(string2, 15));
                stringBuffer.append("    ");
                stringBuffer.append(this.createSysName(string2, StaIOProperties.SYS_NAME_SPANNMASS, false));
                stringBuffer.append(IFormat.getSpaces(30));
                this.appendTexts(stringBuffer, string5, string, string3);
                this.kan.println(stringBuffer.toString());
                break;
            }
            case 210: {
                CharSequence charSequence;
                Cloneable cloneable;
                Object object2;
                if (!messung.isFehler() || !this.isRegOrthoStart) {
                    if (!messung.isFehler()) {
                        this.isRegOrthoStart = true;
                    }
                    this.systemPoints.clear();
                    messungGewicht = messung.hasGewichte() ? messung.getGewichte() : MessungGewicht.DEFAULT;
                    StaSigma staSigma = string4.equals("FLU") ? StaSigma.getFluSigma(messungGewicht) : StaSigma.getMliSigma(messungGewicht);
                    String string6 = staSigma.getName();
                    object2 = messung.getReferenz();
                    cloneable = new OrthoLinie(messung.pz != null ? messung.pz : messung.ps, ((Messung)object2).pz != null ? ((Messung)object2).pz : ((Messung)object2).ps, messung.l1, 0.0, ((Messung)object2).l1, 0.0);
                    charSequence = "";
                    if (string4.equals("FLU")) {
                        charSequence = this.createSysName(string2, StaIOProperties.SYS_NAME_FLUCHT, true);
                        this.sys.println(this.sysLine(3, (String)charSequence, 0.0f, staSigma.getS1() * 100.0f, staSigma.getS2() * 100.0f, "FLU", string6, string, string3));
                        this.ssys.println(this.sSysLine(3, (String)charSequence, (messung.ps.x + ((Messung)object2).ps.x) / 2.0, (messung.ps.y + ((Messung)object2).ps.y) / 2.0, ((OrthoLinie)cloneable).getA(), ((OrthoLinie)cloneable).getO()));
                    } else {
                        charSequence = this.createSysName(string2, StaIOProperties.SYS_NAME_ORTHO, true);
                        this.sys.println(this.sysLine(4, (String)charSequence, 0.0f, staSigma.getS1() * 100.0f, staSigma.getS2() * 100.0f, "   ", string6, string, string3));
                        Punkt punkt3 = ((OrthoLinie)cloneable).getPunktOf(0.0, 0.0);
                        this.ssys.println(this.sSysLine(4, (String)charSequence, punkt3.x, punkt3.y, ((OrthoLinie)cloneable).getA(), ((OrthoLinie)cloneable).getO()));
                    }
                }
                oa = messung.l1;
                oe = messung.getReferenz().l1;
            }
            case 200: 
            case 290: {
                CharSequence charSequence;
                double d7 = Math.min(Math.abs(messung.l1 - oa), Math.abs(oe - messung.l1));
                Object object2 = this.getSysName(string2, string4.equals("FLU") ? StaIOProperties.SYS_NAME_FLUCHT : StaIOProperties.SYS_NAME_ORTHO);
                Cloneable cloneable = null;
                if (messung.getP2() != null && messung.getP2().nr != 0L) {
                    cloneable = (Messung)this.systemPoints.get(punkt2);
                    if (messung.isFehler() && messung2 != null && messung2.getP2() == punkt2) {
                        if (messung2.getBemerkung() == null) {
                            this.addException(new Exception("Der Punkt " + punkt2.nr + " hat ein fehlerhaftes Ma\u00df: " + IFormat.f_2.format(messung.l1) + " Ma\u00dfberichtigung muss kommentiert werden!"));
                        }
                    } else if (cloneable != null && !((Messung)cloneable).isFehler()) {
                        if (((Messung)cloneable).l1 != messung.l1) {
                            this.addException(new Exception("Der Punkt " + punkt2.nr + " ist im OrthoSystem " + (String)object2 + " mehrfach vorhanden: " + IFormat.f_2.format(((Messung)cloneable).l1) + " != " + IFormat.f_2.format(messung.l1)));
                        }
                    } else {
                        charSequence = new StringBuffer(210);
                        ((StringBuffer)charSequence).append((String)object2);
                        ((StringBuffer)charSequence).append(StaIOProperties.getPunktNummer(punkt2));
                        ((StringBuffer)charSequence).append(IFormat.f10_4.format(0.0));
                        ((StringBuffer)charSequence).append(IFormat.f10_4.format(messung.l1));
                        ((StringBuffer)charSequence).append(IFormat.f10_4.format(0.0));
                        if (messung.isFehler()) {
                            ((StringBuffer)charSequence).append(IFormat.f7_2.format(StaIOProperties.eMf));
                            ((StringBuffer)charSequence).append(IFormat.f7_2.format(StaIOProperties.eMf));
                        } else {
                            ((StringBuffer)charSequence).append(IFormat.f7_2.format(bl ? ((SteuerDaten)object).getOrdMf(0.0, d3, d4) * d * 100.0 : 0.0));
                            ((StringBuffer)charSequence).append(IFormat.f7_2.format(bl ? ((SteuerDaten)object).getAbszMf(d7, 0.0, d2, d5) * d * 100.0 : 0.0));
                        }
                        ((StringBuffer)charSequence).append(IFormat.f5_4.format(0.0));
                        this.appendTexts((StringBuffer)charSequence, string4, string2, string5, string, string3);
                        this.lok.println(((StringBuffer)charSequence).toString());
                        this.systemPoints.put(messung.getP2(), messung);
                    }
                }
                cloneable = (Messung)this.systemPoints.get(punkt);
                if (messung.isFehler() && messung2 != null && messung2.getP1() == punkt) {
                    if (messung2.getBemerkung() == null) {
                        this.addException(new Exception("Der Punkt " + punkt.nr + " hat ein fehlerhaftes Ma\u00df: " + IFormat.f_2.format(messung.l1) + " Ma\u00dfberichtigung muss kommentiert werden!"));
                    }
                } else if (cloneable != null && !((Messung)cloneable).isFehler()) {
                    this.addException(new Exception("Der Punkt " + punkt.nr + " ist im OrthoSystem " + (String)object2 + " mehrfach vorhanden: " + IFormat.f_2.format(((Messung)cloneable).l1) + ", " + IFormat.f_2.format(messung.l1)));
                } else {
                    charSequence = new StringBuffer(210);
                    ((StringBuffer)charSequence).append((String)object2);
                    ((StringBuffer)charSequence).append(StaIOProperties.getPunktNummer(punkt));
                    ((StringBuffer)charSequence).append(IFormat.f10_4.format(messung.l2));
                    ((StringBuffer)charSequence).append(n == 1 || n == 3 ? IFormat.f10_4.format(messung.l1) : "               ");
                    ((StringBuffer)charSequence).append(IFormat.f10_4.format(0.0));
                    if (messung.isFehler()) {
                        ((StringBuffer)charSequence).append(IFormat.f7_2.format(StaIOProperties.eMf));
                        ((StringBuffer)charSequence).append(IFormat.f7_2.format(StaIOProperties.eMf));
                    } else {
                        ((StringBuffer)charSequence).append(IFormat.f7_2.format(bl ? ((SteuerDaten)object).getOrdMf(messung.l2, d3, d4) * d * 100.0 : 0.0));
                        ((StringBuffer)charSequence).append(IFormat.f7_2.format(bl ? ((SteuerDaten)object).getAbszMf(d7, messung.l2, d2, d5) * d * 100.0 : 0.0));
                    }
                    ((StringBuffer)charSequence).append(IFormat.f5_4.format(0.0));
                    this.appendTexts((StringBuffer)charSequence, string4, string2, string5, string, string3);
                    this.lok.println(((StringBuffer)charSequence).toString());
                    this.systemPoints.put(punkt, messung);
                }
                if (messung.isFehler() || messung.getMessungsArt(false) != 290) break;
                this.isRegOrthoStart = false;
                break;
            }
        }
    }

    private void writeBedingungList(Vector vector, boolean bl, int n) throws Exception {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            this.writeBedingungRiss(riss, bl, n);
        }
    }

    private void writeBedingungRiss(Riss riss, boolean bl, int n) throws Exception {
        String string = StaIOProperties.listToString(riss.getRissInfo().getList());
        String string2 = bl ? riss.getKeyString() : string;
        String string3 = riss.getDate() != null ? riss.getDate() : this.outDate;
        this.testDate(riss.getRissInfo(), riss.getName(), riss.getDate());
        for (int i = 0; i < riss.size(); ++i) {
            Bedingung bedingung = (Bedingung)riss.elementAt(i);
            if (!bedingung.isOn()) continue;
            if (this.bedingungWithValue && n == 0 && bedingung.ba == 3) {
                if (!this.testBedingungMass(riss, i + 1)) continue;
                this.writeBedingung(bedingung, string, string2, string3);
                continue;
            }
            if (bedingung.ba != n) continue;
            this.writeBedingung(bedingung, string, string2, string3);
        }
    }

    private boolean testBedingungMass(Riss riss, int n) {
        while (n < riss.size()) {
            Bedingung bedingung = (Bedingung)riss.elementAt(n);
            if (bedingung.ba != 0) {
                return false;
            }
            if (bedingung.l != 0.0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void writeBedingung(Bedingung bedingung, String string, String string2, String string3) throws Exception {
        boolean bl = StaIOProperties.writeIndividualGewicht();
        double d = StaIOProperties.getMfFactor();
        double d2 = 1.0;
        if (bedingung.g != 0.0f) {
            d2 = bedingung.g;
        }
        SystraWriter systraWriter = this;
        SteuerDaten steuerDaten = systraWriter.db.getSteuerDaten();
        Punkt punkt = bedingung.getP1();
        Punkt punkt2 = bedingung.getP2();
        Punkt punkt3 = bedingung.getP3();
        String string4 = bedingung.getBemerkungText();
        if (string4 == null) {
            string4 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        switch (bedingung.ba) {
            case 1: {
                StringBuffer stringBuffer = new StringBuffer(210);
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt2));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt3));
                stringBuffer.append(IFormat.f7_2.format(bl ? steuerDaten.getGeMf(d2) * d * 100.0 : 0.0));
                stringBuffer.append(IFormat.getSpaces(35));
                stringBuffer.append(this.createSysName(string2, StaIOProperties.SYS_NAME_FLUCHT, false));
                stringBuffer.append("     ");
                this.appendTexts(stringBuffer, string2, string4, string, string3);
                this.zus.println(stringBuffer.toString());
                break;
            }
            case 2: {
                StringBuffer stringBuffer = new StringBuffer(210);
                double d3 = DLine.getDistance(punkt, punkt2, punkt3);
                stringBuffer.append(StaIOProperties.getPunktNummer(d3 > 0.0 ? punkt : punkt3));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt2));
                stringBuffer.append(StaIOProperties.getPunktNummer(d3 > 0.0 ? punkt3 : punkt));
                stringBuffer.append(IFormat.f7_2.format(bl ? steuerDaten.getRwMf(d2) * d * 100.0 : 0.0));
                stringBuffer.append(IFormat.getSpaces(35));
                stringBuffer.append(this.createSysName(string2, StaIOProperties.SYS_NAME_RECHTWINKEL, false));
                stringBuffer.append("     ");
                this.appendTexts(stringBuffer, string2, string4, string, string3);
                this.zus.println(stringBuffer.toString());
                break;
            }
            case 3: {
                if (!this.bedingungWithValue) {
                    return;
                }
                Object object = this.createSysName(string2, StaIOProperties.SYS_NAME_PARALLEL, true);
                Cloneable cloneable = new OrthoLinie(bedingung.p1, bedingung.p2, 0.0, 0.0, 0.0, 0.0);
                this.sys.println(this.sysLine(3, (String)object, 0.0f, 0.0f, 0.0f, "PAR", string2 + StaIOProperties.SYS_NAME_PARALLEL, string, string3));
                this.ssys.println(this.sSysLine(3, (String)object, (bedingung.p1.x + bedingung.p2.x) / 2.0, (bedingung.p1.y + bedingung.p2.y) / 2.0, ((OrthoLinie)cloneable).getA(), ((OrthoLinie)cloneable).getO()));
                StringBuffer stringBuffer = new StringBuffer(210);
                stringBuffer.append((String)object);
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
                stringBuffer.append(IFormat.f10_4.format(0.0));
                stringBuffer.append("               ");
                stringBuffer.append("               ");
                stringBuffer.append(IFormat.f7_2.format(bl ? steuerDaten.getGeMf(d2) * d * 100.0 : 0.0));
                stringBuffer.append("          ");
                stringBuffer.append("          ");
                this.appendTexts(stringBuffer, "PMA", string2, string4, string, string3);
                this.lok.println(stringBuffer.toString());
                stringBuffer = new StringBuffer(210);
                stringBuffer.append((String)object);
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt2));
                stringBuffer.append(IFormat.f10_4.format(0.0));
                stringBuffer.append("               ");
                stringBuffer.append("               ");
                stringBuffer.append(IFormat.f7_2.format(bl ? steuerDaten.getGeMf(d2) * d * 100.0 : 0.0));
                stringBuffer.append("          ");
                stringBuffer.append("          ");
                this.appendTexts(stringBuffer, "PMA", string2, string4, string, string3);
                this.lok.println(stringBuffer.toString());
            }
            case 0: {
                Cloneable cloneable;
                Object object;
                if (bedingung.l == 0.0) {
                    if (this.bedingungWithValue) {
                        return;
                    }
                    object = new StringBuffer(210);
                    cloneable = bedingung.getReferenz();
                    ((StringBuffer)object).append(StaIOProperties.getPunktNummer(((Bedingung)cloneable).p1));
                    ((StringBuffer)object).append(StaIOProperties.getPunktNummer(((Bedingung)cloneable).p2));
                    ((StringBuffer)object).append(StaIOProperties.getPunktNummer(punkt));
                    ((StringBuffer)object).append(StaIOProperties.getPunktNummer(punkt2));
                    ((StringBuffer)object).append(IFormat.f7_2.format(bl ? steuerDaten.getGeMf(d2) * d * 100.0 : 0.0));
                    ((StringBuffer)object).append(IFormat.getSpaces(20));
                    ((StringBuffer)object).append(this.createSysName(string2, StaIOProperties.SYS_NAME_PARALLEL, false));
                    ((StringBuffer)object).append("     ");
                    this.appendTexts((StringBuffer)object, string2, string4, string, string3);
                    this.zus.println(((StringBuffer)object).toString());
                    break;
                }
                if (!this.bedingungWithValue) {
                    return;
                }
                object = bedingung.getReferenz();
                double d4 = DLine.getDistance(((Bedingung)object).getP1(), ((Bedingung)object).getP2(), punkt);
                double d5 = DLine.getDistance(((Bedingung)object).getP1(), ((Bedingung)object).getP2(), punkt2);
                double d6 = bedingung.l;
                if ((d4 < 0.0 || d5 < 0.0) && d6 > 0.0 || (d4 > 0.0 || d5 > 0.0) && d6 < 0.0) {
                    d6 = -d6;
                    if (d4 < 0.0 && d5 > 0.0 || d4 > 0.0 && d5 < 0.0) {
                        this.addException(new Exception(String.valueOf(bedingung) + " hat Unterschiedliche Vorzeichen in den IST-Abst\u00e4nden"));
                    }
                }
                StringBuffer stringBuffer = new StringBuffer(210);
                stringBuffer.append(this.getSysName(string2, StaIOProperties.SYS_NAME_PARALLEL));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
                stringBuffer.append(IFormat.f10_4.format(d6));
                stringBuffer.append("               ");
                stringBuffer.append("               ");
                stringBuffer.append(IFormat.f7_2.format(bl ? steuerDaten.getGeMf(d2) * d * 100.0 : 0.0));
                stringBuffer.append("          ");
                stringBuffer.append("          ");
                this.appendTexts(stringBuffer, "PMA", string2, string4, string, string3);
                this.lok.println(stringBuffer.toString());
                stringBuffer = new StringBuffer(210);
                stringBuffer.append(this.getSysName(string2, StaIOProperties.SYS_NAME_PARALLEL));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt2));
                stringBuffer.append(IFormat.f10_4.format(d6));
                stringBuffer.append("               ");
                stringBuffer.append("               ");
                stringBuffer.append(IFormat.f7_2.format(bl ? steuerDaten.getGeMf(d2) * d * 100.0 : 0.0));
                stringBuffer.append("          ");
                stringBuffer.append("          ");
                this.appendTexts(stringBuffer, "PMA", string2, string4, string, string3);
                this.lok.println(stringBuffer.toString());
                break;
            }
            case 4: {
                if (!this.bedingungWithValue) {
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer(210);
                stringBuffer.append(this.createSysName(string2, StaIOProperties.SYS_NAME_ABSTAND, true));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
                stringBuffer.append(IFormat.f10_4.format(0.0));
                stringBuffer.append("               ");
                stringBuffer.append("               ");
                stringBuffer.append(IFormat.f7_2.format(bl ? steuerDaten.getGeMf(d2) * d * 100.0 : 0.0));
                stringBuffer.append("          ");
                stringBuffer.append("          ");
                this.appendTexts(stringBuffer, "APL", string2, string4, string, string3);
                this.lok.println(stringBuffer.toString());
                stringBuffer = new StringBuffer(210);
                stringBuffer.append(this.getSysName(string2, StaIOProperties.SYS_NAME_ABSTAND));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt2));
                stringBuffer.append(IFormat.f10_4.format(0.0));
                stringBuffer.append("               ");
                stringBuffer.append("               ");
                stringBuffer.append(IFormat.f7_2.format(bl ? steuerDaten.getGeMf(d2) * d * 100.0 : 0.0));
                stringBuffer.append("          ");
                stringBuffer.append("          ");
                this.appendTexts(stringBuffer, "APL", string2, string4, string, string3);
                this.lok.println(stringBuffer.toString());
                double d7 = bedingung.l;
                double d8 = DLine.getDistance(punkt, punkt2, punkt3);
                if (d8 < 0.0 && d7 > 0.0 || d8 > 0.0 && d7 < 0.0) {
                    d7 = -d7;
                }
                stringBuffer = new StringBuffer(210);
                stringBuffer.append(this.getSysName(string2, StaIOProperties.SYS_NAME_ABSTAND));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt3));
                stringBuffer.append(IFormat.f10_4.format(d7));
                stringBuffer.append("               ");
                stringBuffer.append("               ");
                stringBuffer.append(IFormat.f7_2.format(bl ? steuerDaten.getGeMf(d2) * d * 100.0 : 0.0));
                stringBuffer.append("          ");
                stringBuffer.append("          ");
                this.appendTexts(stringBuffer, "APL", string2, string4, string, string3);
                this.lok.println(stringBuffer.toString());
                break;
            }
            case 5: {
                StringBuffer stringBuffer = new StringBuffer(210);
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt));
                stringBuffer.append(StaIOProperties.getPunktNummer(punkt2));
                stringBuffer.append(IFormat.f10_4.format(bedingung.l));
                stringBuffer.append(IFormat.f7_2.format(bl ? steuerDaten.getGeMf(d2) * d * 100.0 : 0.0));
                this.appendTexts(stringBuffer, "     ", string2, this.createSysName(string2, StaIOProperties.SYS_NAME_SPANNMASS, false), string4, string, string3);
                this.kan.println(stringBuffer.toString());
                break;
            }
            default: {
                this.addException(new IException("Bedingungstyp " + bedingung.ba + " noch nicht implementiert"));
            }
        }
    }

    private String sysLine(int n, String string, float f, float f2, float f3, String string2, String string3, String string4, String string5) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(IFormat.i1.format(n));
        stringBuffer.append(IFormat.getRightString(string, 15));
        stringBuffer.append(IFormat.getSpaces(60));
        stringBuffer.append(IFormat.f5_2.format(f) + "00");
        stringBuffer.append(IFormat.f5_2.format(f2) + "00");
        stringBuffer.append(IFormat.f5_2.format(f3) + "00");
        stringBuffer.append(IFormat.getLeftString(string2, 3));
        stringBuffer.append("               ");
        stringBuffer.append(IFormat.getRightString(string3, 15));
        stringBuffer.append("          ");
        stringBuffer.append(" ");
        stringBuffer.append("          ");
        stringBuffer.append("          ");
        this.appendTexts(stringBuffer, " ", string4, string5);
        return stringBuffer.toString();
    }

    private String sSysLine(int n, String string, double d, double d2, double d3, double d4) {
        return this.sSysLine(n, string, d, d2, d3, -d4, d4, d3);
    }

    private String sSysLine(int n, String string, double d, double d2, double d3, double d4, double d5, double d6) {
        StringBuffer stringBuffer = new StringBuffer(110);
        stringBuffer.append(IFormat.i1.format(n));
        stringBuffer.append("S");
        stringBuffer.append(IFormat.getRightString(string, 14));
        stringBuffer.append(IFormat.f10_4.format(d));
        stringBuffer.append(IFormat.f10_4.format(d2));
        stringBuffer.append(IFormat.f4_10.format(d3));
        stringBuffer.append(IFormat.f4_10.format(d4));
        stringBuffer.append(IFormat.f4_10.format(d5));
        stringBuffer.append(IFormat.f4_10.format(d6));
        return stringBuffer.toString();
    }

    private void appendTexts(StringBuffer stringBuffer, String string, String string2, String string3, String string4, String string5, String string6) {
        stringBuffer.append(IFormat.getLeftString(string, 5));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.getLeftString(string2, 15));
        stringBuffer.append("    ");
        stringBuffer.append(IFormat.getLeftString(string3, 15));
        stringBuffer.append(IFormat.getSpaces(30));
        this.appendTexts(stringBuffer, string4, string5, string6);
    }

    private void appendTexts(StringBuffer stringBuffer, String string, String string2, String string3, String string4, String string5) {
        stringBuffer.append(IFormat.getLeftString(string, 5));
        this.appendTexts(stringBuffer, string2, string3, string4, string5);
    }

    private void appendTexts(StringBuffer stringBuffer, String string, String string2, String string3, String string4) {
        stringBuffer.append(IFormat.getRightString(string, 15));
        this.appendTexts(stringBuffer, string2, string3, string4);
    }

    private void appendTexts(StringBuffer stringBuffer, String object, String string, String string2) {
        if (StaIOProperties.writeDateAsText()) {
            object = string2 + " " + (String)object;
            string2 = "";
        }
        stringBuffer.append("     ");
        stringBuffer.append(IFormat.getRightString((String)object, 25));
        stringBuffer.append("     ");
        stringBuffer.append(IFormat.getRightString(string, 25));
        stringBuffer.append("     ");
        stringBuffer.append(IFormat.getRightString(string2, 10));
    }

    private void writeSchnitt(Schnitt schnitt) throws Exception {
        System.out.println("** Schnitt in .zus pruefen!");
        StringBuffer stringBuffer = new StringBuffer(210);
        stringBuffer.append(StaIOProperties.getPunktNummer(schnitt.s));
        stringBuffer.append(StaIOProperties.getPunktNummer(schnitt.p1));
        stringBuffer.append(StaIOProperties.getPunktNummer(schnitt.p2));
        stringBuffer.append(StaIOProperties.getPunktNummer(schnitt.p3));
        stringBuffer.append(StaIOProperties.getPunktNummer(schnitt.p4));
        stringBuffer.append(IFormat.f7_2.format(StaIOProperties.hMf));
        stringBuffer.append("     ");
        stringBuffer.append("               ");
        stringBuffer.append("     ");
        stringBuffer.append("               ");
        stringBuffer.append("     ");
        stringBuffer.append(IFormat.getSpaces(25));
        stringBuffer.append("     ");
        stringBuffer.append(IFormat.getLeftString("Hilfselemente", 25));
        stringBuffer.append("     ");
        stringBuffer.append("          ");
        this.zus.println(stringBuffer.toString());
    }

    private void writeBogenSchnittList(Vector vector) throws Exception {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            boolean bl = false;
            Punkt punkt = null;
            for (int i = 0; i < riss.size(); ++i) {
                Messung messung = (Messung)riss.elementAt(i);
                if (!messung.isOn() || messung.isFehler() || messung.getMessungsArt() != 260) continue;
                if (!bl) {
                    this.writeBogenSchnitt(messung);
                    punkt = messung.pz;
                    bl = true;
                    continue;
                }
                bl = false;
                if (messung.pz == punkt) continue;
                throw new Exception("Ung\u00fcltiger Bogenschnitt im Riss " + riss.getName() + ", Schnittpunkt " + punkt.nr + " ist nicht in zwei Bogenschnitten enthalten");
            }
        }
    }

    private void writeBogenSchnitt(Messung messung) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(210);
        stringBuffer.append(StaIOProperties.getPunktNummer(messung.pz));
        stringBuffer.append(StaIOProperties.getPunktNummer(messung.ps));
        stringBuffer.append(StaIOProperties.getPunktNummer(messung.getReferenz().ps));
        stringBuffer.append("               ");
        stringBuffer.append("          ");
        stringBuffer.append("     ");
        stringBuffer.append("               ");
        stringBuffer.append("     ");
        stringBuffer.append("               ");
        stringBuffer.append("     ");
        stringBuffer.append(IFormat.getSpaces(25));
        stringBuffer.append("     ");
        stringBuffer.append(IFormat.getLeftString("Hilfselemente", 25));
        stringBuffer.append("     ");
        stringBuffer.append("          ");
        this.zus.println(stringBuffer.toString());
    }

    private long getNr(Punkt punkt) {
        long l = punkt.nr;
        long l2 = punkt.buildKatNr(StaIOProperties.getPnrModus(), StaIOProperties.writeUmnumPoints() ? punkt.getNr() : punkt.nr);
        Long l3 = (Long)this.numbers.get(new Long(l2));
        if (l3 != null && l3 != l) {
            this.addException(new Exception("Die Ausgabenummer " + l2 + " wurde aus verschiedenen Auftragspunkten erzeugt: " + l3 + ", " + l));
        } else {
            this.numbers.put(new Long(l2), new Long(l));
        }
        return l2;
    }

    private void testDate(RissInfo rissInfo, String string, String string2) {
        int n;
        if (rissInfo.getTyp() != 2) {
            return;
        }
        int n2 = n = string2 == null ? 0 : string2.length();
        if (n == 0) {
            if (this.dateUse == 2) {
                this.addException(new Exception("Riss '" + string + "' enth\u00e4lt kein Datum"));
            } else {
                this.dateUse = 1;
            }
        } else {
            if (this.dateUse == 1) {
                this.addException(new Exception("Riss '" + string + "' enth\u00e4lt ein Datum, vorigen Rissen fehlt das Datum"));
            }
            this.dateUse = 2;
        }
    }

    private class Schnitt {
        Punkt s;
        Punkt p1;
        Punkt p2;
        Punkt p3;
        Punkt p4;

        private Schnitt(SystraWriter systraWriter) {
        }
    }
}

