/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.geom.DRectangle;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.GeoImageLocation;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.img.ImgIOProperties;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;

public class TflReader
extends IDataReader {
    private DataBase db;
    private LineNumberReader in = null;
    private long fileLength = 0L;

    public TflReader(File file, DataBase dataBase) throws IFileInputException {
        this(file, dataBase, null);
    }

    public TflReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) throws IFileInputException {
        super(file, iProgressViewer);
        this.db = dataBase;
        try {
            this.in = this.createReader();
        }
        catch (IOException iOException) {
            throw new IFileInputException("Datei " + file.getName() + " nicht gefunden");
        }
        if (file != null) {
            this.fileLength = file.length();
        }
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    public TflReader(URL uRL, DataBase dataBase, IProgressViewer iProgressViewer) throws IFileInputException {
        super(null, iProgressViewer);
        this.db = dataBase;
        try {
            this.in = this.createReader(uRL);
            this.setFileLength(uRL.openConnection().getContentLength());
        }
        catch (IOException iOException) {
            throw new IFileInputException("Datei " + uRL.getFile() + " nicht gefunden");
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.fileLength = uRLConnection.getContentLength();
            if (this.fileLength < 0L) {
                this.fileLength = 0L;
            }
        }
        catch (IOException iOException) {
            throw new IFileInputException("Datei " + uRL.getFile() + " konnte nicht ge\u00f6ffnet werden");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IFileInputException {
        Messager messager;
        String string = null;
        if (this.in == null) {
            throw new IFileInputException("Datei nicht gefunden: " + this.getFile().getName());
        }
        try {
            long l = 0L;
            GeoImage geoImage = null;
            messager = null;
            int n = 0;
            Object var7_15 = null;
            Object var8_16 = null;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            boolean bl = false;
            boolean bl2 = false;
            while ((string = this.in.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.startsWith("#")) continue;
                if (string.startsWith("[") && string.endsWith("]")) {
                    geoImage = new GeoImage();
                    messager = new GeoImageLocation(geoImage);
                    geoImage.setName(string.substring(1, string.length() - 1));
                    geoImage.setImageLocation((GeoImageLocation)messager);
                    DataBase.IMG.addElement(geoImage);
                    n = 0;
                } else {
                    if (n == 0) {
                        d3 = Double.valueOf(string);
                    } else if (n == 1) {
                        d5 = Double.valueOf(string);
                    } else if (n == 2) {
                        d6 = Double.valueOf(string);
                    } else if (n == 3) {
                        d4 = -Double.valueOf(string).doubleValue();
                    } else if (n == 4) {
                        d = Double.valueOf(string);
                    } else if (n == 5) {
                        d2 = Double.valueOf(string);
                        ((GeoImageLocation)messager).setLocation(d, d2);
                        d7 = Math.atan2((Math.abs(d5) + Math.abs(d6)) / 2.0, (Math.abs(d3) + Math.abs(d4)) / 2.0);
                        if (d4 < 0.0) {
                            d7 = -d7 + Math.PI;
                        }
                        if (d5 > 0.0) {
                            d7 = -d7;
                        }
                        ((GeoImageLocation)messager).setAngle(d7);
                        ((GeoImageLocation)messager).setScale((Math.abs(d3) + Math.abs(d4)) / 2.0 / Math.abs(Math.cos(d7)));
                    } else {
                        int n2 = string.indexOf("=");
                        if (n2 > 0) {
                            String string2 = string.substring(0, n2).trim();
                            String string3 = string.substring(n2 + 1).trim();
                            if (string2.equalsIgnoreCase("alpha")) {
                                geoImage.setAlpha(Integer.parseInt(string3));
                            } else if (string2.equalsIgnoreCase("alpha_alternate")) {
                                geoImage.setAlphaAlternate(Integer.parseInt(string3) > 0);
                            } else if (string2.equalsIgnoreCase("bright")) {
                                geoImage.setBright(Integer.parseInt(string3));
                            } else if (string2.equalsIgnoreCase("contrast")) {
                                geoImage.setContrast(Integer.parseInt(string3));
                            } else if (string2.equalsIgnoreCase("sharp")) {
                                geoImage.setSharp(Integer.parseInt(string3));
                            } else if (string2.equalsIgnoreCase("file")) {
                                geoImage.setPathName(string3);
                            } else if (!string2.equalsIgnoreCase("width") && !string2.equalsIgnoreCase("height")) {
                                throw new IFileInputException("unbekannter Inhalt: " + string);
                            }
                        } else {
                            throw new IFileInputException("unbekannter Inhalt: " + string);
                        }
                    }
                    ++n;
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
        }
        catch (IFileInputException iFileInputException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.in.getLineNumber(), iFileInputException.getMessage()));
            iFileInputException.printStackTrace();
        }
        catch (IOException iOException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.in.getLineNumber(), iOException.getMessage()));
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.in.getLineNumber(), exception.getMessage()));
            exception.printStackTrace();
        }
        finally {
            try {
                this.in.close();
                super.setProgress(100);
            }
            catch (Exception exception) {}
        }
        if (ImgIOProperties.readOnlyDataArea()) {
            TflReader tflReader = this;
            DRectangle dRectangle = tflReader.db.getBounds();
            for (int i = DataBase.IMG.size() - 1; i >= 0; --i) {
                boolean bl = false;
                messager = (GeoImage)DataBase.IMG.elementAt(i);
                if (((GeoImage)messager).getBounds().intersects(dRectangle)) {
                    bl = true;
                }
                if (bl) continue;
                DataBase.IMG.removeElementAt(i);
            }
        }
    }
}

