/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.io.IFreePunktReader;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.NoSuchElementException;
import java.util.Vector;

public class UmnumReader
extends IFreePunktReader {
    public UmnumReader(File file, LongHashList longHashList) {
        super(file, longHashList);
    }

    public UmnumReader(File file, LongHashList longHashList, IProgressViewer iProgressViewer) {
        super(file, longHashList, iProgressViewer);
    }

    public UmnumReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    public void read() throws IFileInputException {
        LineNumberReader lineNumberReader = null;
        String string = new String();
        try {
            lineNumberReader = this.createReader();
            long l = 0L;
            while ((string = lineNumberReader.readLine()) != null) {
                try {
                    Punkt punkt = this.lineToPunkt(string);
                    if (punkt == null) continue;
                    this.savePunkt(string, punkt);
                }
                catch (NumberFormatException numberFormatException) {
                    this.addException(new IFileInputException("Lesefehler in Zeile: " + lineNumberReader.getLineNumber() + ", ung\u00fcltige Zeichen vorgefunden.", "Zeile wurde ignoriert"));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    this.addException(new IFileInputException("Lesefehler in Zeile: " + lineNumberReader.getLineNumber() + ", vorzeitig Zeilenende erreicht.", "Zeile wurde ignoriert"));
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.addException(new IFileInputException("Lesefehler in Zeile: " + lineNumberReader.getLineNumber() + ", vorzeitig Zeilenende erreicht.", "Zeile wurde ignoriert"));
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
            lineNumberReader.close();
            super.setProgress(100);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IFileInputException("Datei " + this.inFile.getName() + " nicht gefunden");
        }
        catch (IOException iOException) {
            throw new IFileInputException("Lesefehler in Zeile: " + lineNumberReader.getLineNumber());
        }
    }

    protected Punkt savePunkt(String string, Punkt punkt) {
        Punkt punkt2 = null;
        if (this.HP != null) {
            punkt2 = (Punkt)this.HP.get(punkt.nr);
        } else if (this.VP != null) {
            for (int i = 0; i < this.VP.size(); ++i) {
                Punkt punkt3 = (Punkt)this.VP.elementAt(i);
                if (punkt3.nr != punkt.nr) continue;
                punkt2 = punkt3;
                break;
            }
        }
        if (punkt2 != null) {
            this.lineToPunkt(string, punkt2);
        } else {
            this.addException(new IFileInputException("Der Punkt " + punkt.nr + " ist nicht im Speicher vorhanden, es konnten keine neuen Parameter \u00fcbernommen werden!"));
        }
        return punkt2;
    }

    @Override
    protected Punkt lineToPunkt(String string) {
        if (string.startsWith("8")) {
            Punkt punkt = new Punkt();
            punkt.nr = Long.parseLong(string.substring(2, 15).trim());
            return punkt;
        }
        return null;
    }

    protected Punkt lineToPunkt(String string, Punkt punkt) {
        PunktParameterALK punktParameterALK;
        block22: {
            punktParameterALK = new PunktParameterALK();
            try {
                punkt.setUmnum(Long.parseLong(string.substring(16, 29).trim()));
            }
            catch (Exception exception) {
                if (string.charAt(28) != '#' && !string.substring(16, 29).trim().equals("#")) break block22;
                punkt.setUmnum(-9L);
            }
        }
        try {
            punktParameterALK.setPa(Integer.parseInt(string.substring(31, 32)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            punktParameterALK.setVa(Integer.parseInt(string.substring(34, 37).trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            punktParameterALK.setLs(Integer.parseInt(string.substring(39, 42).trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            punktParameterALK.setLg(string.charAt(44));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            punktParameterALK.setHs(Integer.parseInt(string.substring(47, 50).trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            punktParameterALK.setHg(Integer.parseInt(string.substring(52, 53)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            punktParameterALK.setEb(Integer.parseInt(string.substring(55, 57).trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            punktParameterALK.setVvt(Integer.parseInt(string.substring(58, 61).trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            punktParameterALK.setVva(Integer.parseInt(string.substring(63, 66).trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            punktParameterALK.setLz(Integer.parseInt(string.substring(67, 69).trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        punkt.initParameter(punktParameterALK);
        return punkt;
    }
}

