/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Lagegenauigkeit;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALKISExt;
import de.geocalc.kafplot.PunktSorter;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.KatasternachweisIOProperties;
import de.geocalc.kafplot.io.KatasternachweisWriter;
import de.geocalc.kafplot.io.VeraenderungIOProperties;
import de.geocalc.text.GeoNumberFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class VeraenderungWriter
extends KatasternachweisWriter {
    private int rissPage = 0;
    private static final String KOO_FEHLER = "Koordinaten-Fehler";
    private static final String NEU_KOO = "neue Koo eingef\u00fchrt";
    private static final String EOL = "\n";
    private static final String RTF_HEADER = "{\\rtf1\\ansi\\deff1\\adeflang1025\n{\\fonttbl{\\f0\\fswiss\\fprq2\\fcharset0 Arial;}}\n{\\colortbl;\\red0\\green0\\blue0;\\red128\\green128\\blue128;\\red255\\green0\\blue0;\\red0\\green128\\blue0;}\n{\\stylesheet{\\s1\\cf0\\ql\\rtlch\\af0\\afs24\\lang1081\\ltrch\\dbch\\af0\\langfe2052\\hich\\f0\\fs24\\lang1031\\loch\\f0\\fs24\\lang1031\\snext1 Normal;}}";
    private static final String CONTENT_HEADER = "{\\*\\Start SeitenInhalt}\n\\ftnbj\\ftnstart1\\ftnrstcont\\ftnnar\\aenddoc\\aftnrstcont\\aftnstart1\\aftnnar";
    private static final String DATA_HEADER = "{\\*\\Start Daten}";
    private static final String RISS_TABLE_HEADER = "{\\*\\Erste Zeile Tabellenkopf Ueberschriften}\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx624\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx1644\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx3516\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx5556\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx8052\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\cellx10205\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\fs16\\qc\\b {OA\\cell PNR\\cell Marke\\cell Koordinaten\\cell Qualit\\'e4t\\cell Bemerkungen\\cell}\\row{\\*\\Zweite Zeile Tabellenkopf Namen}\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx624\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx1644\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx2892\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx3516\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx4536\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx5556\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx6180\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx6804\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx7428\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx8052\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\cellx10205\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\fs16\\qc\\b {\\cell\\cell ABM/VMA\\cell BZA\\cell y\\cell x\\cell DES\\cell GST\\cell LZK\\cell KST\\cell\\cell}\\row{\\*\\Dritte Zeile Tabellenkopf Spaltennummern}\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx624\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx1644\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx2268\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx2892\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx3516\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx4536\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx5556\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx6180\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx6804\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx7428\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx8052\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\cellx10205\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\fs12\\qc {1\\cell 2\\cell 3\\cell 4\\cell 5\\cell 6\\cell 7\\cell 8\\cell 9\\cell 10\\cell 11\\cell 12\\cell}\\row";
    private static final String RISS_TABLE_DATA_LINE_DEF = "\\trowd\\trql\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx624\\clvertalc\\cellx1644\\clvertalc\\cellx2268\\clvertalc\\cellx2892\\clvertalc\\cellx3516\\clvertalc\\cellx4536\\clvertalc\\cellx5556\\clvertalc\\cellx6180\\clvertalc\\cellx6804\\clvertalc\\cellx7428\\clvertalc\\cellx8052\\clvertalc\\cellx10205";
    private static final String RISS_TABLE_DIFF_LINE_DEF = "\\trowd\\trql\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx624\\clvertalc\\cellx1644\\clvertalc\\cellx2268\\clvertalc\\cellx2892\\clvertalc\\cellx3516\\clvertalc\\cellx4536\\clvertalc\\cellx5556\\clvertalc\\cellx6804\\clvertalc\\cellx7428\\clvertalc\\cellx8052\\clvertalc\\cellx10205";
    private static final String RISS_TABLE_TEXT_LINE_DEF = "\\trowd\\trql\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx10205";
    private static final String ROW_START = "\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\f0\\fs20\\ql";
    private static final String ROW_END = "\\cell\\row";
    private static final String CELL = "\\cell ";
    private static final String COLOR_BLACK = "{\\cf1 ";
    private static final String COLOR_GRAY = "{\\cf2 ";
    private static final String COLOR_RED = "{\\cf3 ";
    private static final String COLOR_GREEN = "{\\cf4 ";
    private static final String COLOR_END = "}";
    private static final String END_OF_FILE = "\\pard\\plain\\n{\\*\\bkmkstart LETZTE_SEITE}{\\*\\bkmkend LETZTE_SEITE}\\n\\par }";

    public VeraenderungWriter(File file, DataBase dataBase) {
        super(file, dataBase);
        this.rissFile = file;
        this.db = dataBase;
        this.P = DataBase.P;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (DataBase.gemarkung != null) {
                Gemarkung gemarkung = Gemarkung.getGemarkung(DataBase.gemeinde, DataBase.gemarkung);
                if (gemarkung != null) {
                    stringBuffer.append(gemarkung.getName());
                    stringBuffer.append(" (");
                    stringBuffer.append(GeoNumberFormat.nr06n.format(gemarkung.getNummer()).toString());
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(DataBase.gemarkung);
                    this.addException(new IException("Keine Gemarkungsnummer f\u00fcr die Gemarkung: " + DataBase.gemarkung + " gefunden.", "\u00dcberpr\u00fcfen Sie die Einstellungen in der Konfigurationsdatei \"gemarkungen.properties\""));
                }
                this.gemarkung = stringBuffer.toString();
            }
            super.setLabelText("Sortiere...");
            super.showProgress();
            this.outFile = this.rissFile;
            printWriter = this.createWriter();
            int n = 0;
            super.setEndValue(this.P.size());
            super.setProgressBreak();
            super.setValue(0L);
            super.setLabelText("Koordinatenliste erstellen...");
            printWriter.println(RTF_HEADER);
            this.writeDocInfo(printWriter, "Ver\u00e4nderungsListe");
            this.writePageDef(printWriter, this.rissPage + 1);
            this.writePageHeader(printWriter, "Ver\u00e4nderungen - Liste");
            printWriter.println(CONTENT_HEADER);
            printWriter.println(RISS_TABLE_HEADER);
            printWriter.println(DATA_HEADER);
            int n2 = Integer.MIN_VALUE;
            PunktSorter punktSorter = new PunktSorter(this.P, 23);
            punktSorter.setProgressBar(super.getProgressBar());
            Vector vector = punktSorter.getSortedVector();
            Enumeration enumeration = vector.elements();
            while (true) {
                block21: {
                    Punkt punkt;
                    block22: {
                        if (!enumeration.hasMoreElements()) {
                            printWriter.println(END_OF_FILE);
                            printWriter.close();
                            return;
                        }
                        punkt = (Punkt)enumeration.nextElement();
                        if (!punkt.isFortfuehrung()) break block21;
                        VeraenderungWriter veraenderungWriter = this;
                        if (!veraenderungWriter.db.hasMenge()) break block22;
                        if (!DataBase.MENGE.contains(punkt)) break block21;
                    }
                    block1 : switch (punkt.getInternalPs()) {
                        case 0: {
                            switch (punkt.getPs()) {
                                case 1: 
                                case 2: {
                                    break block1;
                                }
                            }
                            if (punkt.isKatasterElement()) break;
                            break block21;
                        }
                        case 1: 
                        case 2: {
                            if (!punkt.isKatasterElement()) break block21;
                        }
                    }
                    boolean bl = false;
                    if (VeraenderungIOProperties.writeOldPoints() && punkt.getPst() != 14) {
                        PunktParameter punktParameter = punkt.getOldParameter();
                        PunktParameter punktParameter2 = punkt.getParameter();
                        if (punktParameter instanceof PunktParameterALKISExt && punktParameter2 instanceof PunktParameterALKISExt) {
                            PunktParameterALKISExt punktParameterALKISExt = (PunktParameterALKISExt)punktParameter;
                            PunktParameterALKISExt punktParameterALKISExt2 = (PunktParameterALKISExt)punktParameter2;
                            boolean bl2 = bl = !punktParameterALKISExt.equalsSoe(punktParameterALKISExt2.getSoeElements());
                        }
                    }
                    if (punkt.createKooNb() > n2) {
                        n2 = punkt.createKooNb();
                        printWriter.println(RISS_TABLE_TEXT_LINE_DEF);
                        this.writeBelegTextLine(printWriter, "", false);
                        this.writeBelegTextLine(printWriter, "Nummerierungsbezirk: 3" + Punkt.createNbAsString(punkt.createKooNb()), true);
                        printWriter.println(RISS_TABLE_DATA_LINE_DEF);
                    }
                    if (VeraenderungIOProperties.writeOldPoints() && punkt.getPst() != 14) {
                        this.writeBelegOldPointLine(printWriter, punkt, this.initBemerkung(punkt, punkt.getParameter()));
                    }
                    this.writeBelegPointLine(printWriter, punkt, bl || !VeraenderungIOProperties.writeOldPoints() ? this.initBemerkung(punkt, punkt.getOldParameter()) : new StringBuffer());
                    if (VeraenderungIOProperties.writeDiffLines() && punkt.getPst() != 14) {
                        printWriter.println(RISS_TABLE_DIFF_LINE_DEF);
                        this.writeBelegDiffPointLine(printWriter, punkt);
                        printWriter.println(RISS_TABLE_DATA_LINE_DEF);
                    }
                    if (VeraenderungIOProperties.writeVoidLines()) {
                        this.writeBelegVoidLine(printWriter);
                    }
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setProgress(n);
                    }
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    private void writePageDef(PrintWriter printWriter, int n) {
        printWriter.println("{\\*\\SeitenDefinition OpenOffice}");
        printWriter.println("{\\*\\pgdsctbl {\\pgdsc0\\pgdscuse195\\pgwsxn11906\\pghsxn16838\\marglsxn1134\\margrsxn567\\margtsxn566\\margbsxn566\\headery0 \\pgdscnxt0 Standard;}}");
        printWriter.println("{\\*\\SeitenDefinition MSWord}");
        printWriter.println("\\paperh16838\\paperw11906\\margl1134\\margr567\\margt566\\margb566\\sectd\\sbknone" + (String)(n > 1 ? "\\pgnrestart\\pgnstarts" + n : "") + "\\pgwsxn11906\\pghsxn16838\\marglsxn1134\\margrsxn567\\margtsxn2876\\margbsxn566\\headery566");
    }

    private void writePageHeader(PrintWriter printWriter, String string) {
        printWriter.println("{\\*\\Start SeitenKopf}");
        printWriter.println("{\\header");
        printWriter.println("{\\*\\Titelzeile}");
        printWriter.println("\\pard\\plain \\sb113\\sa113\\s1\\margtsxn2480\\margbsxn170 {\\rtlch \\ltrch\\loch\\f0\\fs28\\b " + string + " ( {\\field{\\*\\fldinst PAGE }{\\fldrslt 1}} / {\\field{\\*\\fldinst PAGEREF LETZTE_SEITE }{\\fldrslt 1}} )}\\par");
        printWriter.println("{\\*\\Erste KopfZeile}");
        printWriter.println("\\trowd\\trql\\trkeep\\trrh454\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx1020\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx3288\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx5357\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx7426\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx10205");
        printWriter.println("\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright");
        printWriter.println("\\ql\\fs16 Gemeinde\\cell");
        printWriter.println("\\ql\\fs20\\b " + (DataBase.gemeinde != null ? VeraenderungWriter.getRtfString(DataBase.gemeinde) : "") + "\\cell");
        printWriter.println("\\qc\\b0 " + VeraenderungWriter.getRtfString(KatasternachweisIOProperties.getVermTitle()) + "\\cell");
        printWriter.println("\\qc\\b0 " + VeraenderungWriter.getRtfString(KatasternachweisIOProperties.getAmtTitle()) + "\\cell");
        printWriter.println("\\ql\\fs16\\b0 Archivblatt*:\\cell");
        printWriter.println("\\row");
        printWriter.println("{\\*\\Zweite KopfZeile}");
        printWriter.println("\\trowd\\trql\\trkeep\\trrh454\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx1020\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx3288\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx5357\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx7426\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx10205");
        printWriter.println("\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright");
        printWriter.println("\\ql\\fs16 Gemarkung\\cell");
        printWriter.println("\\ql\\fs20\\b " + (this.gemarkung != null ? VeraenderungWriter.getRtfString(this.gemarkung) : "") + "\\cell");
        printWriter.println("\\qc\\fs16\\b " + (DataBase.vermStelle != null ? VeraenderungWriter.getRtfString(KatasternachweisIOProperties.getVermPrefix() + DataBase.vermStelle) : "") + "\\cell");
        printWriter.println("\\qc\\fs16\\b " + (DataBase.katasterAmt != null ? VeraenderungWriter.getRtfString(KatasternachweisIOProperties.getAmtPrefix() + DataBase.katasterAmt) : "") + "\\cell");
        printWriter.println("\\ql\\fs16\\b0 Antrags-Nr.*:\\cell");
        printWriter.println("\\row");
        printWriter.println("{\\*\\Dritte KopfZeile}");
        printWriter.println("\\trowd\\trql\\trkeep\\trrh454\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx1020\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx3288\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx5357\\clvertalt\\cellx7426\\clvertalt\\cellx10205");
        printWriter.println("\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright");
        printWriter.println("{\\fs16 Flur }{\\fs20\\b " + (DataBase.flur != null ? VeraenderungWriter.getRtfString(DataBase.flur) : "") + "}\\cell");
        printWriter.println("{\\fs16 Flurst\\'fcck }{\\fs20\\b " + (DataBase.flurstueck != null ? VeraenderungWriter.getRtfString(DataBase.flurstueck) : "") + "}\\cell");
        printWriter.println("\\cell\\cell");
        printWriter.println("{\\rtlch \\ltrch\\loch\\f0\\fs12\\lang1031\\i0\\b0 * wird von der Katasterbeh\\'f6rde ausgef\\'fcllt}\\cell");
        printWriter.println("\\row");
        printWriter.println("\\pard\\plain");
        printWriter.println("\\par");
        printWriter.println(COLOR_END);
        printWriter.println("{\\*\\Ende SeitenKopf}");
    }

    private void writeBelegPointLine(PrintWriter printWriter, Punkt punkt, StringBuffer stringBuffer) {
        boolean bl;
        PunktParameter punktParameter = punkt.getOldParameter();
        PunktParameter punktParameter2 = punkt.getParameter();
        boolean bl2 = punktParameter2.getPst() != 14;
        String string = punktParameter2.getPst() == 14 ? COLOR_GREEN : COLOR_BLACK;
        printWriter.print(ROW_START);
        printWriter.print(" {\\qc ");
        printWriter.print(string);
        printWriter.print(VeraenderungWriter.getPaString(punkt));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(string);
        printWriter.print(VeraenderungWriter.getPnrString(punkt));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        if (punktParameter2.getModVa() > 0) {
            printWriter.print(bl2 && punktParameter2.getModVa() != punktParameter.getModVa() ? COLOR_RED : string);
            printWriter.print(punktParameter2.getModVa());
            printWriter.print(COLOR_END);
        }
        printWriter.print(CELL);
        printWriter.print(bl2 && punktParameter2.getModVa() != punktParameter.getModVa() ? COLOR_RED : string);
        printWriter.print(VermarkungsArt.toKuerzel(punktParameter2.getModVa()));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(bl2 && punktParameter2.getModVb() != punktParameter.getModVb() ? COLOR_RED : string);
        printWriter.print(punktParameter2.getOutVb());
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        boolean bl3 = bl = punkt.dy != 0.0f || punkt.dx != 0.0f;
        if (!(punkt.isKooDiff() || punkt.getInternalPs() != 0 || punkt.getPs() != 1 && punkt.getPs() != 2)) {
            bl = false;
        }
        printWriter.print(bl2 && bl ? COLOR_RED : string);
        printWriter.print(koo33.format(punkt.y));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(bl2 && bl ? COLOR_RED : string);
        printWriter.print(koo33.format(punkt.x));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(bl2 && punktParameter2.getModEq() != punktParameter.getModEq() ? COLOR_RED : string);
        printWriter.print(punktParameter2.getOutEq());
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        if (punktParameter2.getModLg() != 0) {
            printWriter.print(bl2 && punktParameter2.getModLg() != punktParameter.getModLg() ? COLOR_RED : string);
            printWriter.print(punktParameter2.getOutLg());
        } else {
            printWriter.print(bl2 && punktParameter2.getModLl() != punktParameter.getModLl() ? COLOR_RED : string);
            printWriter.print(punktParameter2.getOutLl());
        }
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(bl2 && punktParameter2.getModLz() != punktParameter.getModLz() ? COLOR_RED : string);
        printWriter.print(VeraenderungWriter.getLzString(punktParameter2.getModLz()));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(bl2 && punktParameter2.getModLs() != punktParameter.getModLs() ? COLOR_RED : string);
        printWriter.print(punktParameter2.getOutLs());
        printWriter.print(COLOR_END);
        printWriter.print("\\cell\\ql ");
        if (punktParameter2.getKafPa() == 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\\line ");
            }
            stringBuffer.append("Hilfspunkt");
        } else if (punktParameter2.getPst() == 13) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\\line ");
            }
            stringBuffer.append("Punkt untergegangen");
        } else if (punktParameter2.getPst() == 14) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\\line ");
            }
            stringBuffer.append("Neupunkt");
        }
        printWriter.print(VeraenderungWriter.getRtfString(stringBuffer.toString()));
        printWriter.println("\\cell}\\row");
    }

    private void writeBelegOldPointLine(PrintWriter printWriter, Punkt punkt, StringBuffer stringBuffer) {
        PunktParameter punktParameter = punkt.getOldParameter();
        printWriter.print(ROW_START);
        printWriter.print(" {\\qc ");
        printWriter.print(COLOR_GRAY);
        printWriter.print(VeraenderungWriter.getPaString(punkt));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(COLOR_GRAY);
        printWriter.print(VeraenderungWriter.getPnrString(punkt));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        if (punktParameter.getModVa() > 0) {
            printWriter.print(COLOR_GRAY);
            printWriter.print(punktParameter.getModVa());
            printWriter.print(COLOR_END);
        }
        printWriter.print(CELL);
        printWriter.print(COLOR_GRAY);
        printWriter.print(VermarkungsArt.toKuerzel(punktParameter.getModVa()));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(COLOR_GRAY);
        printWriter.print(punktParameter.getOutVb());
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        DPoint dPoint = punkt.getDisplayOriginal();
        printWriter.print(COLOR_GRAY);
        printWriter.print(koo33.format(dPoint.y));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(COLOR_GRAY);
        printWriter.print(koo33.format(dPoint.x));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(COLOR_GRAY);
        printWriter.print(punktParameter.getOutEq());
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(COLOR_GRAY);
        if (punktParameter.getModLg() != 0) {
            printWriter.print(punktParameter.getOutLg());
        } else {
            printWriter.print(punktParameter.getOutLl());
        }
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(COLOR_GRAY);
        printWriter.print(VeraenderungWriter.getLzString(punktParameter.getModLz()));
        printWriter.print(COLOR_END);
        printWriter.print(CELL);
        printWriter.print(COLOR_GRAY);
        printWriter.print(punktParameter.getOutLs());
        printWriter.print(COLOR_END);
        printWriter.print("\\cell\\ql ");
        printWriter.print(COLOR_GRAY);
        printWriter.print(VeraenderungWriter.getRtfString(stringBuffer.toString()));
        printWriter.print(COLOR_END);
        printWriter.println("\\cell}\\row");
    }

    private void writeBelegDiffPointLine(PrintWriter printWriter, Punkt punkt) {
        printWriter.print(ROW_START);
        printWriter.print(" {\\qc ");
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print(CELL);
        DPoint dPoint = punkt.getDisplayOriginal();
        double d = punkt.getDistance(dPoint);
        double d2 = punkt.y - dPoint.y;
        double d3 = punkt.x - dPoint.x;
        if (d < 0.005) {
            printWriter.print(COLOR_GRAY);
            printWriter.print(dif33.format(d2));
            printWriter.print(COLOR_END);
            printWriter.print(CELL);
            printWriter.print(COLOR_GRAY);
            printWriter.print(dif33.format(d3));
            printWriter.print(COLOR_END);
            printWriter.print(CELL);
            printWriter.print(COLOR_GRAY);
            printWriter.print(dif33.format(d));
            printWriter.print(COLOR_END);
        } else {
            printWriter.print(dif33.format(d2));
            printWriter.print(CELL);
            printWriter.print(dif33.format(d3));
            printWriter.print(CELL);
            PunktParameter punktParameter = punkt.getOldParameter();
            if (d > (double)Lagegenauigkeit.createLl(punktParameter.getKafLg()) || punktParameter.getLz() == 2) {
                printWriter.print(COLOR_RED);
                printWriter.print(dif33.format(d));
                printWriter.print(COLOR_END);
            } else {
                printWriter.print(dif33.format(d));
            }
        }
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print("\\cell\\ql ");
        printWriter.println("\\cell}\\row");
    }

    private void writeBelegVoidLine(PrintWriter printWriter) {
        printWriter.print(ROW_START);
        printWriter.print(" {\\qc ");
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print(CELL);
        printWriter.print("\\cell\\ql ");
        printWriter.println("\\cell}\\row");
    }

    private void writeBelegTextLine(PrintWriter printWriter, String string, boolean bl) {
        printWriter.print(ROW_START);
        if (bl) {
            printWriter.print("\\b");
        }
        printWriter.print(" ");
        printWriter.print(VeraenderungWriter.getRtfString(string));
        printWriter.println(ROW_END);
    }

    private StringBuffer initBemerkung(Punkt punkt, PunktParameter punktParameter) {
        StringBuffer stringBuffer = new StringBuffer();
        if (VeraenderungIOProperties.writeEntstehung()) {
            if (punktParameter instanceof PunktParameterALKISExt) {
                PunktParameterALKISExt punktParameterALKISExt = (PunktParameterALKISExt)punktParameter;
                if (punktParameterALKISExt.hasSoe()) {
                    int n = 0;
                    stringBuffer.append("\\fs14");
                    Enumeration enumeration = punktParameterALKISExt.getSoeElements();
                    while (enumeration.hasMoreElements()) {
                        if (n > 0) {
                            stringBuffer.append("\\line ");
                        }
                        stringBuffer.append(enumeration.nextElement().toString());
                        ++n;
                    }
                    if (punktParameterALKISExt.hasHin()) {
                        if (n > 0) {
                            stringBuffer.append("\\line ");
                        }
                        stringBuffer.append(punktParameterALKISExt.getHin());
                    }
                }
            } else if (punkt.hasTag("ENT")) {
                stringBuffer.append("ENT:");
                stringBuffer.append(punkt.getTag("ENT").getValue());
            }
        }
        return stringBuffer;
    }
}

