/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.geodata.AbstractLage;
import de.geocalc.geodata.AbstractLageEntry;
import de.geocalc.geodata.FeatureVector;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.GeomException;
import de.geocalc.io.IFileInputException;
import de.geocalc.io.unix.UnixIOConstants;
import de.geocalc.kafplot.Buchungsstelle;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckArt;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.LageEntry;
import de.geocalc.kafplot.Name;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.io.ErrorWriter;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.wldge.WldgeIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.IntegerHashObject;
import java.io.File;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WldgeReader
extends IDataReader {
    protected FeatureVector FLST;
    protected FeatureVector ALB;
    protected FeatureVector BUCH;
    protected Flurstueck stammstueck = null;
    protected Grundbuchblatt buch = null;
    protected Name name = null;
    protected Vector TEILE = new Vector();
    protected Hashtable STRASSEN = new Hashtable();
    protected Hashtable GMD = new Hashtable();
    protected Hashtable GMK = new Hashtable();
    private LineNumberReader in = null;

    public WldgeReader(File file, FeatureVector featureVector, FeatureVector featureVector2, FeatureVector featureVector3) {
        this(file, featureVector, featureVector2, featureVector3, null);
    }

    public WldgeReader(File file, FeatureVector featureVector, FeatureVector featureVector2, FeatureVector featureVector3, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.ALB = featureVector;
        this.FLST = featureVector2;
        this.BUCH = featureVector3;
    }

    protected void saveCurrentBuch() {
        if (this.buch != null) {
            try {
                this.BUCH.put(this.buch);
                if (this.stammstueck != null) {
                    this.stammstueck.addBuchung(new Buchungsstelle(this.buch.getKennzeichen(), null, 0));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void saveCurrentName() {
        if (this.buch != null && this.name != null) {
            try {
                this.buch.addElement(this.name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void saveCurrentFlst() {
        if (this.stammstueck != null) {
            switch (WldgeIOProperties.getImportOption()) {
                case 0: {
                    this.saveCurrentFlst(this.ALB);
                    break;
                }
                case 1: {
                    this.saveCurrentFlst(this.FLST);
                    break;
                }
                default: {
                    Flurstueck flurstueck = (Flurstueck)this.FLST.get(this.stammstueck);
                    if (flurstueck == null) {
                        if (!WldgeIOProperties.isImportAll()) break;
                        this.saveCurrentFlst(this.ALB);
                        break;
                    }
                    if (this.equalsFlst(flurstueck, this.stammstueck)) {
                        this.matchCurrent(flurstueck, true);
                        break;
                    }
                    this.saveCurrentFlst(this.ALB);
                    this.matchCurrent(flurstueck, false);
                }
            }
        }
        this.TEILE.removeAllElements();
    }

    protected void matchCurrent(Flurstueck flurstueck, boolean bl) {
        flurstueck.setBuchFlaeche(this.stammstueck.getBuchFlaeche());
        flurstueck.setFlaecheRead(true);
        if (bl) {
            flurstueck.setNutzung(this.getNutzung(flurstueck.getNutzung(), this.stammstueck.getNutzung()));
        }
        flurstueck.setTeil(this.stammstueck.getTeil());
        flurstueck.setPruefzeichen(this.stammstueck.getPruefzeichen());
        flurstueck.setAktualitaet(this.stammstueck.getAktualitaet());
        flurstueck.setLage(this.stammstueck.getLage());
        flurstueck.setKlasse(this.stammstueck.getKlasse());
        flurstueck.setBerechnungsArt(this.stammstueck.getBerechnungsArt());
        Buchungsstelle buchungsstelle = this.stammstueck.getBuchung();
        flurstueck.addBuchung(buchungsstelle);
        if (bl) {
            int n = flurstueck.getArt();
            flurstueck.setArt(FlurstueckArt.getArt(FlurstueckArt.getArt(n), FlurstueckArt.getTeil(n), 1));
            Vector vector = this.FLST.getFeatureParts(flurstueck);
            boolean[] blArray = new boolean[vector.size()];
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
                int n2 = this.getBestEqualsIndex(flurstueck2, blArray);
                if (n2 >= 0) {
                    Flurstueck flurstueck3 = (Flurstueck)this.TEILE.elementAt(n2);
                    flurstueck2.setNutzung(this.getNutzung(flurstueck2.getNutzung(), flurstueck3.getNutzung()));
                    flurstueck2.setTeil(flurstueck2.getTeil());
                    flurstueck2.setBerechnungsArt(flurstueck3.getBerechnungsArt());
                    if (WldgeIOProperties.getNutzungFlaecheArt() == 0) continue;
                    flurstueck2.setBuchFlaeche(flurstueck3.getFlaeche());
                    flurstueck2.setFlaecheRead(flurstueck3.isFlaecheRead());
                    continue;
                }
                this.addException(new IException("Interner Fehler beim Abgleich. Bitte den KafPlot-Support informieren"));
            }
        }
    }

    protected boolean equalsFlst(Flurstueck flurstueck, Flurstueck flurstueck2) {
        Vector vector = this.FLST.getFeatureParts(flurstueck);
        if (vector.size() != this.TEILE.size()) {
            this.addException(new GeomException(new DPoint(flurstueck.y, flurstueck.x), flurstueck.getPolygon(), "Flurst\u00fcck: " + flurstueck.toMiniString() + " hat unterschiedliche Anzahl von Nutzungsarten. (" + this.TEILE.size() + "!=" + vector.size() + ")"));
            return false;
        }
        if (vector.size() == 0) {
            if (!this.equalsNutzung(flurstueck.getNutzung(), flurstueck2.getNutzung())) {
                this.addException(new GeomException(new DPoint(flurstueck.y, flurstueck.x), flurstueck.getPolygon(), "Flurst\u00fcck: " + flurstueck.toMiniStringWithNutzung() + " hat unterschiedliche  Nutzungsarten. (" + flurstueck.getNutzung() + "!=" + flurstueck2.getNutzung() + ")"));
                return false;
            }
        } else {
            boolean[] blArray = new boolean[vector.size()];
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                double d;
                Flurstueck flurstueck3 = (Flurstueck)enumeration.nextElement();
                int n = this.getBestEqualsIndex(flurstueck3, blArray);
                if (n < 0) {
                    this.addException(new GeomException(new DPoint(flurstueck3.y, flurstueck3.x), flurstueck3.getPolygon(), "F\u00fcr Nutzungsart: " + flurstueck3.toMiniStringWithNutzung() + " wurde keine \u00dcbereinstimmung gefunden."));
                    return false;
                }
                Flurstueck flurstueck4 = (Flurstueck)this.TEILE.elementAt(n);
                double d2 = Math.abs(flurstueck3.getFlaeche() - flurstueck4.getFlaeche());
                if (!(d2 > (d = Math.abs(WldgeIOProperties.getAddDifferenz() + flurstueck4.getFlaeche() * WldgeIOProperties.getPercentDifferenz() / 100.0)))) continue;
                this.addException(new GeomException(new DPoint(flurstueck3.y, flurstueck3.x), flurstueck3.getPolygon(), "F\u00fcr Nutzungsart: " + flurstueck3.toMiniStringWithNutzung() + " wurde die zul\u00e4ssige Fl\u00e4chendifferenz \u00fcberschritten. (d=" + IFormat.f_1.format(d2) + ")"));
                return false;
            }
        }
        return true;
    }

    protected int getBestEqualsIndex(Flurstueck flurstueck, boolean[] blArray) {
        int n = -1;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.TEILE.size(); ++i) {
            double d2;
            if (blArray[i]) continue;
            Flurstueck flurstueck2 = (Flurstueck)this.TEILE.elementAt(i);
            if (!this.equalsNutzung(flurstueck.getNutzung(), flurstueck2.getNutzung()) || !((d2 = Math.abs(flurstueck.getFlaeche() - flurstueck2.getFlaeche())) < d)) continue;
            d = d2;
            n = i;
        }
        if (n >= 0) {
            blArray[n] = true;
        }
        return n;
    }

    protected boolean equalsNutzung(int n, int n2) {
        int n3 = n / 100;
        int n4 = n2 / 100;
        switch (WldgeIOProperties.getNutzungSpec()) {
            case 2: {
                if (n2 % 100 == 0) {
                    switch (n3) {
                        case 1: 
                        case 2: {
                            return n4 == 1 || n4 == 2;
                        }
                    }
                    return n3 == n4;
                }
                if (n2 % 10 == 0) {
                    return n / 10 == n2 / 10;
                }
                return n == n2;
            }
            case 1: {
                if (n % 100 == 0) {
                    switch (n3) {
                        case 1: 
                        case 2: {
                            return n4 == 1 || n4 == 2;
                        }
                    }
                    return n3 == n4;
                }
                if (n % 10 == 0) {
                    return n / 10 == n2 / 10;
                }
                return n == n2;
            }
            case 3: {
                if (n % 100 == 0 || n2 % 100 == 0) {
                    switch (n3) {
                        case 1: 
                        case 2: {
                            return n4 == 1 || n4 == 2;
                        }
                    }
                    return n3 == n4;
                }
                if (n % 10 == 0 || n2 % 10 == 0) {
                    return n / 10 == n2 / 10;
                }
                return n == n2;
            }
        }
        return n == n2;
    }

    protected int getNutzung(int n, int n2) {
        if (n % 10 != 0) {
            return n;
        }
        if (n2 % 10 != 0) {
            return n2;
        }
        if (n % 100 != 0) {
            return n;
        }
        return n2;
    }

    protected void saveCurrentFlst(FeatureVector featureVector) {
        try {
            featureVector.put(this.stammstueck);
            Enumeration enumeration = this.TEILE.elements();
            while (enumeration.hasMoreElements()) {
                featureVector.put((Flurstueck)enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            this.addException(exception);
        }
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        try {
            this.in = this.createReader();
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler beim \u00d6ffnen der Datei: " + this.inFile.getName());
        }
        long l = 0L;
        while (true) {
            try {
                String string;
                while ((string = this.in.readLine()) != null) {
                    int n = Integer.parseInt(string.substring(0, 1));
                    block6 : switch (n) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            int n2 = Integer.parseInt(string.substring(1, 7));
                            int n3 = Integer.parseInt(string.substring(8, 14).trim());
                            String string2 = Grundbuchblatt.createKennzeichen(n2, n3);
                            if (this.buch == null || !this.buch.getKennzeichen().equals(string2)) {
                                this.buch = new Grundbuchblatt(string2);
                                this.saveCurrentBuch();
                            }
                            switch (Integer.parseInt(string.substring(26, 27))) {
                                case 1: {
                                    long l2 = Long.parseLong(string.substring(27, 31)) * 100000000L + Long.parseLong(string.substring(32, 34)) * 1000000L + Long.parseLong(string.substring(35, 37)) * 10000L + Long.parseLong(string.substring(38, 40)) * 100L + Long.parseLong(string.substring(41, 43));
                                    if (this.name == null || !this.name.getGrundbuchblatt().equals(string2) || this.name.getNummer() == l2) {
                                        this.name = new Name(string2, l2);
                                        this.saveCurrentName();
                                    }
                                    switch (Integer.parseInt(string.substring(47, 48))) {
                                        case 0: {
                                            String string3;
                                            if (string.charAt(50) != ' ') {
                                                this.name.setArt(Integer.parseInt(string.substring(49, 51).trim()));
                                            }
                                            if ((string3 = string.substring(52, 68).trim()).length() > 0) {
                                                this.name.setAnteil(UnixIOConstants.unix2Java(string3));
                                            }
                                            this.name.setAktualitaet(Integer.parseInt(string.substring(94, 98)));
                                            break block6;
                                        }
                                        case 1: {
                                            String string4 = UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 48, string.length()));
                                            if (string4.endsWith(",")) {
                                                int n4;
                                                for (n4 = string4.length() - 1; n4 >= 0 && string4.charAt(n4) == ','; --n4) {
                                                }
                                                string4 = string4.substring(0, n4 + 1);
                                            }
                                            this.name.setName(string4);
                                            break block6;
                                        }
                                        case 2: {
                                            int n5;
                                            int n6 = string.indexOf(42, 48);
                                            int n7 = n5 = n6 > 0 ? WldgeReader.indexOfDateEnd(string, n6 + 1) : -1;
                                            if (n5 > n6) {
                                                this.name.setGeburtName(UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 48, n6)));
                                                this.name.setGeburtDatum(UnixIOConstants.unix2Java(string.substring(n6 + 1, n5)));
                                                break block6;
                                            }
                                            this.name.setGeburtName(UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 48, string.length())));
                                            break block6;
                                        }
                                        case 3: {
                                            this.name.setAdresse(UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 48, string.length())));
                                            break block6;
                                        }
                                        case 4: {
                                            String string5 = WldgeReader.parseUnstruct(string, 48, string.length());
                                            if (string5.indexOf(32) == 5) {
                                                String string6 = string5.substring(0, 5);
                                                if (IFormat.hasOnlyNumbers(string6)) {
                                                    this.name.setPostleitzahl(Integer.parseInt(string6));
                                                    this.name.setOrt(UnixIOConstants.unix2Java(string5.substring(6)));
                                                    break block6;
                                                }
                                                this.name.setOrt(UnixIOConstants.unix2Java(string5));
                                                break block6;
                                            }
                                            this.name.setOrt(UnixIOConstants.unix2Java(string5));
                                            break block6;
                                        }
                                    }
                                    break block6;
                                }
                                case 2: {
                                    if (Integer.parseInt(string.substring(30, 32)) == 1) {
                                        this.buch.setZusatz(UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 33, string.length())));
                                        break block6;
                                    }
                                    this.buch.appendZusatz(UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 33, string.length())));
                                    break block6;
                                }
                                case 4: {
                                    break block6;
                                }
                                case 5: 
                                case 6: {
                                    int n8 = Integer.parseInt(string.substring(15, 19).trim());
                                    break block6;
                                }
                                case 8: {
                                    break block6;
                                }
                            }
                            break;
                        }
                        case 3: 
                        case 4: {
                            int n9 = Integer.parseInt(string.substring(1, 7));
                            int n3 = Integer.parseInt(string.substring(8, 11));
                            int n10 = Integer.parseInt(string.substring(12, 17));
                            int n11 = Integer.parseInt(string.substring(18, 21));
                            if (this.stammstueck == null || !this.stammstueck.equals(n9, n3, n10, n11)) {
                                this.saveCurrentFlst();
                                this.stammstueck = new Flurstueck(701, n9, n3, n10, n11);
                            }
                            char c = string.charAt(26);
                            switch (c) {
                                case 'B': {
                                    this.stammstueck.setTeil(0);
                                    this.stammstueck.setPruefzeichen(Integer.parseInt(string.substring(24, 25)));
                                    this.stammstueck.setBuchFlaeche(Integer.parseInt(string.substring(83, 92)));
                                    this.stammstueck.setFlaecheRead(true);
                                    if (WldgeIOProperties.isStammstueckSoll()) {
                                        this.stammstueck.setBerechnungsArt(10);
                                    }
                                    this.stammstueck.setAktualitaet(Integer.parseInt(string.substring(94, 96)));
                                    break block6;
                                }
                                case 'D': {
                                    try {
                                        if (IFormat.hasChars(string.substring(71, 79))) {
                                            this.stammstueck.y = new Double(string.substring(71, 79));
                                        }
                                    }
                                    catch (Exception exception) {
                                        throw new IException("Ung\u00fcltiger Rechtswert");
                                    }
                                    try {
                                        if (!IFormat.hasChars(string.substring(80, 88))) break block6;
                                        this.stammstueck.x = new Double(string.substring(80, 88));
                                        break block6;
                                    }
                                    catch (Exception exception) {
                                        throw new IException("Ung\u00fcltiger Hochwert");
                                    }
                                }
                                case 'F': {
                                    break block6;
                                }
                                case 'G': {
                                    LageEntry lageEntry = LageEntry.parseWldgeString(string.substring(30).trim());
                                    this.stammstueck.addLageEntry(lageEntry);
                                    break block6;
                                }
                                case 'H': {
                                    int n12 = Integer.parseInt(string.substring(30, 32));
                                    if (n12 == 1) {
                                        this.stammstueck.setLageBezeichnung(UnixIOConstants.unix2Java(string.substring(33).trim()));
                                        break block6;
                                    }
                                    this.stammstueck.setLageBezeichnung(this.stammstueck.getLageBezeichnung() + " " + UnixIOConstants.unix2Java(string.substring(33).trim()));
                                    break block6;
                                }
                                case 'K': {
                                    int n13 = Integer.parseInt(string.substring(36, 39));
                                    int n14 = Integer.parseInt(string.substring(40, 47));
                                    if ((int)this.stammstueck.getBuchFlaeche() == n14) {
                                        this.stammstueck.setNutzung(n13);
                                        break block6;
                                    }
                                    this.stammstueck.setArt(791);
                                    Flurstueck flurstueck = this.stammstueck.createNutzstueck(n13, n14);
                                    switch (WldgeIOProperties.getNutzungFlaecheArt()) {
                                        case 1: {
                                            flurstueck.setBerechnungsArt(1);
                                            flurstueck.setFlaecheRead(true);
                                            break;
                                        }
                                        case 2: {
                                            flurstueck.setBerechnungsArt(10);
                                            flurstueck.setFlaecheRead(true);
                                            break;
                                        }
                                        default: {
                                            flurstueck.setBerechnungsArt(0);
                                            flurstueck.setFlaecheRead(false);
                                        }
                                    }
                                    this.TEILE.addElement(flurstueck);
                                    break block6;
                                }
                                case 'M': {
                                    break block6;
                                }
                                case 'N': {
                                    break block6;
                                }
                                case 'P': {
                                    break block6;
                                }
                                case 'R': {
                                    break block6;
                                }
                                case 'U': {
                                    break block6;
                                }
                                case 'V': {
                                    break block6;
                                }
                                case 'W': {
                                    break block6;
                                }
                                case 'X': {
                                    int n15 = Integer.parseInt(string.substring(32, 38));
                                    int n16 = Integer.parseInt(string.substring(39, 45).trim());
                                    int n17 = Integer.parseInt(string.substring(46, 50).trim());
                                    this.stammstueck.addBuchung(new Buchungsstelle(Grundbuchblatt.createKennzeichen(n15, n16), Integer.toString(n17), 0));
                                    break block6;
                                }
                                case 'Z': {
                                    int n18;
                                    int n19 = Integer.parseInt(string.substring(32, 38));
                                    int n16 = Integer.parseInt(string.substring(39, 45).trim());
                                    String string7 = Grundbuchblatt.createKennzeichen(n19, n16);
                                    int n20 = Integer.parseInt(string.substring(46, 50).trim());
                                    if (this.buch == null || !this.buch.getKennzeichen().equals(string7)) {
                                        this.buch = new Grundbuchblatt(string7);
                                        this.saveCurrentBuch();
                                    }
                                    this.stammstueck.addBuchung(new Buchungsstelle(string7, Integer.toString(n20), 0));
                                    int n21 = n18 = string.length() < 57 || string.charAt(56) == ' ' ? 0 : Integer.parseInt(string.substring(56, 57));
                                    if (n18 == 1) {
                                        long l3 = Long.parseLong(string.substring(57, 61)) * 100000000L + Long.parseLong(string.substring(62, 64)) * 1000000L + Long.parseLong(string.substring(65, 67)) * 10000L + Long.parseLong(string.substring(68, 70)) * 100L + Long.parseLong(string.substring(71, 73));
                                        if (this.name == null || !this.name.getGrundbuchblatt().equals(string7) || this.name.getNummer() == l3) {
                                            this.name = new Name(string7, l3);
                                            this.saveCurrentName();
                                        }
                                        switch (Integer.parseInt(string.substring(76, 77))) {
                                            case 0: {
                                                String string8;
                                                if (string.charAt(79) != ' ') {
                                                    this.name.setArt(Integer.parseInt(string.substring(78, 80).trim()));
                                                }
                                                if ((string8 = string.substring(81, 97).trim()).length() > 0) {
                                                    this.name.setAnteil(UnixIOConstants.unix2Java(string8));
                                                }
                                                this.name.setAktualitaet(Integer.parseInt(string.substring(98, 102)));
                                                break;
                                            }
                                            case 1: {
                                                String string9 = UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 77, string.length()));
                                                if (string9.endsWith(",")) {
                                                    int n22;
                                                    for (n22 = string9.length() - 1; n22 >= 0 && string9.charAt(n22) == ','; --n22) {
                                                    }
                                                    string9 = string9.substring(0, n22 + 1);
                                                }
                                                this.name.setName(string9);
                                                break;
                                            }
                                            case 2: {
                                                int n23;
                                                int n24 = string.indexOf(42, 77);
                                                int n25 = n23 = n24 > 0 ? WldgeReader.indexOfDateEnd(string, n24 + 1) : -1;
                                                if (n23 > n24) {
                                                    this.name.setGeburtName(UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 77, n24)));
                                                    this.name.setGeburtDatum(UnixIOConstants.unix2Java(string.substring(n24 + 1, n23)));
                                                    break;
                                                }
                                                if (n24 > 77) break;
                                                this.name.setGeburtName(UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 77, string.length())));
                                                break;
                                            }
                                            case 3: {
                                                this.name.setAdresse(UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 77, string.length())));
                                                break;
                                            }
                                            case 4: {
                                                String string10 = WldgeReader.parseUnstruct(string, 77, string.length());
                                                if (string10.indexOf(32) == 5) {
                                                    String string11 = string10.substring(0, 5);
                                                    if (IFormat.hasOnlyNumbers(string11)) {
                                                        this.name.setPostleitzahl(Integer.parseInt(string11));
                                                        this.name.setOrt(UnixIOConstants.unix2Java(string10.substring(6)));
                                                        break;
                                                    }
                                                    this.name.setOrt(UnixIOConstants.unix2Java(string10));
                                                    break;
                                                }
                                                this.name.setOrt(UnixIOConstants.unix2Java(string10));
                                                break;
                                            }
                                        }
                                        break block6;
                                    }
                                    if (n18 != 2) break block6;
                                    if (Integer.parseInt(string.substring(60, 62)) == 1) {
                                        this.buch.setZusatz(UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 63, string.length())));
                                        break block6;
                                    }
                                    this.buch.appendZusatz(UnixIOConstants.unix2Java(WldgeReader.parseUnstruct(string, 63, string.length())));
                                    break block6;
                                }
                                default: {
                                    throw new IException("ung\u00fcltige Satzart: " + c);
                                }
                            }
                        }
                        case 5: {
                            break;
                        }
                        case 7: {
                            String string2;
                            switch (string.charAt(26)) {
                                case 'B': {
                                    long l4 = Long.parseLong(string.substring(1, 7).trim());
                                    long l5 = Long.parseLong(string.substring(8, 16).trim());
                                    String string12 = UnixIOConstants.unix2Java(string.substring(29, Math.min(59, string.length())).trim());
                                    this.GMK.put(new Long(l5 * 1000000L + l4), string12);
                                    break block6;
                                }
                                case 'D': {
                                    long l6 = Long.parseLong(string.substring(1, 13).trim());
                                    string2 = UnixIOConstants.unix2Java(string.substring(29, Math.min(59, string.length())).trim());
                                    this.GMD.put(new Long(l6), string2);
                                    break block6;
                                }
                                case 'E': {
                                    long l7 = Long.parseLong(string.substring(1, 13).trim());
                                    long l8 = Strasse.parseKey((int)l7, string.substring(13, 18));
                                    String string13 = UnixIOConstants.unix2Java(string.substring(29, 59).trim());
                                    this.STRASSEN.put(new Long(l7 * 10000000L + l8), string13);
                                    break block6;
                                }
                            }
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 9: {
                            break;
                        }
                        default: {
                            throw new IException("ung\u00fcltige Dateikennung: " + n);
                        }
                    }
                    super.setFileProgress(l += (long)(string.length() + 1));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.addException(new IException("Lesefehler in Zeile: " + this.in.getLineNumber(), exception.getMessage()));
                continue;
            }
            break;
        }
        this.saveCurrentFlst();
        this.createEntLage(this.ALB);
        this.createEntLage(this.FLST);
        this.saveGemeinden();
        super.setProgress(100);
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = this.inFile.getName();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if (this.getExceptionList().size() > 0) {
            ErrorWriter errorWriter = new ErrorWriter(new File(string + ".Import.err"), this.getExceptionList());
            errorWriter.setHeader("#Wldge-Import am " + new Date().toString());
            try {
                errorWriter.write();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void saveGemeinden() {
        boolean bl = false;
        boolean bl2 = false;
        Object object = this.GMD.keys();
        while (object.hasMoreElements()) {
            IntegerHashObject integerHashObject;
            int n;
            String string;
            Long l;
            Long l2 = (Long)object.nextElement();
            String string2 = (String)this.GMD.get(l2);
            int n2 = l2.intValue();
            Gemeinde gemeinde = Gemeinde.getGemeinde(n2);
            if (gemeinde == null) {
                gemeinde = new Gemeinde(n2, string2);
                Gemeinde.putGemeinde(gemeinde);
                bl = true;
            } else if (!gemeinde.getName().equals(string2)) {
                this.addException(new GeomException(3, "F\u00fcr die Gemeinde " + n2 + " wurde der Name ge\u00e4ndert: " + gemeinde.getName() + " >> " + string2));
                gemeinde.setName(string2);
                bl = true;
            }
            Enumeration enumeration = this.GMK.keys();
            while (enumeration.hasMoreElements()) {
                l = (Long)enumeration.nextElement();
                if ((int)(l / 1000000L) != n2) continue;
                string = (String)this.GMK.get(l);
                n = (int)(l % 1000000L);
                integerHashObject = Gemarkung.getGemarkung(n);
                if (integerHashObject == null) {
                    integerHashObject = new Gemarkung(n, string, gemeinde);
                    gemeinde.addGemarkung((Gemarkung)integerHashObject);
                    bl = true;
                    continue;
                }
                if (!((Gemarkung)integerHashObject).getName().equals(string)) {
                    this.addException(new GeomException(3, "F\u00fcr die Gemarkung " + n + " wurde der Name ge\u00e4ndert: " + ((Gemarkung)integerHashObject).getName() + " >> " + string));
                    ((Gemarkung)integerHashObject).setName(string);
                    bl = true;
                    continue;
                }
                if (((Gemarkung)integerHashObject).getGemeinde().getNummer() == n2) continue;
                this.addException(new GeomException(3, "F\u00fcr die Gemarkung " + n + " wurde die Gemeindezuordnung ge\u00e4ndert: " + ((Gemarkung)integerHashObject).getGemeinde().getName() + " >> " + string2));
                ((Gemarkung)integerHashObject).getGemeinde().removeGemarkung((Gemarkung)integerHashObject);
                gemeinde.addGemarkung((Gemarkung)integerHashObject);
                bl = true;
            }
            enumeration = this.STRASSEN.keys();
            while (enumeration.hasMoreElements()) {
                l = (Long)enumeration.nextElement();
                if ((int)(l / 10000000L) != n2) continue;
                string = (String)this.STRASSEN.get(l);
                n = (int)(l % 10000000L);
                integerHashObject = gemeinde.getStrasse(n);
                if (integerHashObject == null) {
                    integerHashObject = new Strasse(n, string, gemeinde);
                    gemeinde.addStrasse((Strasse)integerHashObject);
                    bl2 = true;
                    continue;
                }
                if (((Strasse)integerHashObject).getName().equals(string)) continue;
                this.addException(new GeomException(3, "F\u00fcr die Stra\u00dfe " + n2 + "-" + n + " wurde der Name ge\u00e4ndert: " + ((Strasse)integerHashObject).getName() + " >> " + string));
                ((Strasse)integerHashObject).setName(string);
                bl2 = true;
            }
        }
        if (WldgeIOProperties.saveGemeinden()) {
            if (bl) {
                try {
                    object = IFileWriter.createFileWriter(new File("gemarkungen.properties"));
                    Gemeinde.saveGemarkungen((PrintWriter)object, "# Aktualisierte Gemarkungsliste aus Wldge-Import am " + new Date().toString());
                    ((PrintWriter)object).close();
                    this.addException(new GeomException(3, "Gemarkungen in Datei gemarkungen.properties gesichert"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl2) {
                try {
                    object = IFileWriter.createFileWriter(new File("strassen.properties"));
                    Gemeinde.saveStrassen((PrintWriter)object, "# Aktualisierte Stra\u00dfenliste aus Wldge-Import am " + new Date().toString());
                    ((PrintWriter)object).close();
                    this.addException(new GeomException(3, "Stra\u00dfen in Datei strassen.properties gesichert"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected final void createEntLage(FeatureVector featureVector) {
        Enumeration enumeration = featureVector.elements();
        while (enumeration.hasMoreElements()) {
            AbstractLage abstractLage;
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.hasLage() || (abstractLage = flurstueck.getLage()).hasBezeichnung() || !abstractLage.hasEntries()) continue;
            StringBuffer stringBuffer = new StringBuffer();
            for (AbstractLageEntry abstractLageEntry = abstractLage.getEntry(); abstractLageEntry != null; abstractLageEntry = abstractLageEntry.getNext()) {
                String string = (String)this.STRASSEN.get(new Long((long)abstractLageEntry.getGemeinde() * 10000000L + (long)abstractLageEntry.getStrasse()));
                if (string == null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
                if (abstractLageEntry.hasHausNummer()) {
                    stringBuffer.append(" ");
                    stringBuffer.append(abstractLageEntry.getHausNummer());
                }
                if (!abstractLageEntry.hasAdressenZusatz()) continue;
                stringBuffer.append(abstractLageEntry.getAdressenZusatz());
            }
            if (stringBuffer.length() <= 0) continue;
            abstractLage.setBezeichnung(stringBuffer.toString());
        }
    }

    private static final String parseUnstruct(String string, int n, int n2) {
        int n3 = Math.min(n2, string.length());
        StringBuffer stringBuffer = new StringBuffer(Math.max(0, n2 - n));
        boolean bl = false;
        for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            if (i == n && c == ':') continue;
            if (c == ' ') {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer.append(' ');
                bl = false;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private static final int indexOfDateEnd(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        while (n < n2 && !bl2) {
            char c = string.charAt(n);
            switch (c) {
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    bl = true;
                    stringBuffer.append(c);
                    break;
                }
                case ' ': {
                    if (!bl) break;
                    bl2 = true;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
            ++n;
        }
        String string2 = stringBuffer.toString();
        int n3 = IFormat.countChar(string2, '.');
        if (n3 > 2) {
            return -1;
        }
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            try {
                int n5;
                int n6 = 0;
                if (i == 0 ? (n5 = Integer.parseInt(string2.substring((n6 = string2.lastIndexOf(46)) + 1))) < 1800 || n5 > 2006 : (i == 1 ? (n5 = Integer.parseInt(string2.substring((n6 = string2.lastIndexOf(46, n4 - 1)) + 1, n4))) < 1 || n5 > 12 : i == 2 && ((n5 = Integer.parseInt(string2.substring(0, n4))) < 1 || n5 > 31))) {
                    return -1;
                }
                n4 = n6;
                continue;
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return n;
    }
}

