/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.io.IFileWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;

public class XdesyWriter
extends IFileWriter {
    public static final String TITLE = "XdesyWriter";
    public static final String VERSION = "1.0";
    protected DataBase db;

    public XdesyWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
        this.setParameter();
    }

    protected void setParameter() {
    }

    @Override
    public void write() throws IFileOutputException {
        super.setProgress(0);
        PrintWriter printWriter = null;
        try {
            printWriter = this.createWriter();
        }
        catch (Exception exception) {
            throw new IFileOutputException("Fehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
        try {
            XdesyWriter xdesyWriter = this;
            printWriter.println("Quelle  = \"KafPlot " + xdesyWriter.db.getSourceName() + "\"");
            printWriter.println("Projekt = " + (DataBase.projekt != null ? DataBase.projekt : ""));
            printWriter.println("");
            printWriter.println("; Anschluss- und N\u00e4herungspunkte");
            XdesyWriter xdesyWriter2 = this;
            Enumeration enumeration = xdesyWriter2.db.punkte();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((Punkt)enumeration.nextElement()).toXdesyLine());
            }
            printWriter.println("");
            printWriter.println("; PolarMessungen");
            XdesyWriter xdesyWriter3 = this;
            enumeration = xdesyWriter3.db.polarRisse();
            while (enumeration.hasMoreElements()) {
                Riss riss = (Riss)enumeration.nextElement();
                printWriter.println("; Riss: " + riss.getName());
                Enumeration enumeration2 = riss.elements();
                while (enumeration2.hasMoreElements()) {
                    printWriter.println(((Messung)enumeration2.nextElement()).toXdesyLine());
                }
            }
        }
        catch (Exception exception) {
            throw new IFileOutputException("Fehler beim Schreiben der Datei: " + this.outFile.getName() + ", " + exception.getMessage());
        }
        try {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Exception exception) {
            throw new IFileOutputException("Fehler beim Schlie\u00dfen der Datei: " + this.outFile.getName());
        }
        super.setProgress(100);
    }
}

