/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.KatAmt;
import de.geocalc.kafplot.Lagegenauigkeit;
import de.geocalc.kafplot.Lagestatus;
import de.geocalc.kafplot.Lagezuverlaessigkeit;
import de.geocalc.kafplot.LinieArt;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.xml.XmlIOConstants;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class XmlWriter
extends IFileWriter
implements XmlIOConstants {
    public static final String TITLE = "XmlWriter";
    public static final String VERSION = "1.0";
    protected DataBase db;

    public XmlWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
        this.setParameter();
    }

    protected void setParameter() {
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            printWriter = this.createWriter();
            printWriter.println(XmlIOProperties.getHeader());
            printWriter.println(XmlIOProperties.open("kafplot"));
            printWriter.println(XmlIOProperties.open("ref"));
            printWriter.println(XmlIOProperties.open("punktarten"));
            Enumeration enumeration = PunktArt.arten();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((PunktArt)enumeration.nextElement()).toXmlLine());
            }
            printWriter.println(XmlIOProperties.close("punktarten"));
            printWriter.println(XmlIOProperties.open("linienarten"));
            enumeration = LinieArt.arten();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((LinieArt)enumeration.nextElement()).toXmlLine());
            }
            printWriter.println(XmlIOProperties.close("linienarten"));
            printWriter.println(XmlIOProperties.open("ebenen"));
            enumeration = Ebene.sortedElements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((Ebene)enumeration.nextElement()).toXmlLine());
            }
            printWriter.println(XmlIOProperties.close("ebenen"));
            printWriter.println(XmlIOProperties.open("objektschluesselkatalog"));
            enumeration = Oska.sortedElements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((Oska)enumeration.nextElement()).toXmlLine());
            }
            printWriter.println(XmlIOProperties.close("objektschluesselkatalog"));
            printWriter.println(XmlIOProperties.open("vermarkungen"));
            enumeration = VermarkungsArt.sortedElements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((VermarkungsArt)enumeration.nextElement()).toXmlLine());
            }
            printWriter.println(XmlIOProperties.close("vermarkungen"));
            printWriter.println(XmlIOProperties.open("lagestati"));
            enumeration = Lagestatus.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((Lagestatus)enumeration.nextElement()).toXmlLine());
            }
            printWriter.println(XmlIOProperties.close("lagestati"));
            printWriter.println(XmlIOProperties.open("lagegenauigkeiten"));
            enumeration = Lagegenauigkeit.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((Lagegenauigkeit)enumeration.nextElement()).toXmlLine());
            }
            printWriter.println(XmlIOProperties.close("lagegenauigkeiten"));
            printWriter.println(XmlIOProperties.open("lagezuverlaessigkeiten"));
            enumeration = Lagezuverlaessigkeit.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((Lagezuverlaessigkeit)enumeration.nextElement()).toXmlLine());
            }
            printWriter.println(XmlIOProperties.close("lagezuverlaessigkeiten"));
            printWriter.println(XmlIOProperties.open("aemter"));
            enumeration = KatAmt.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((KatAmt)enumeration.nextElement()).toXmlLine());
            }
            printWriter.println(XmlIOProperties.close("aemter"));
            printWriter.println(XmlIOProperties.open("gemeinden"));
            enumeration = Gemeinde.elements();
            while (enumeration.hasMoreElements()) {
                ((Gemeinde)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("gemeinden"));
            printWriter.println(XmlIOProperties.close("ref"));
            printWriter.println(XmlIOProperties.open("dat"));
            if (DataBase.projekt != null) {
                printWriter.println(XmlIOProperties.data("d_name", DataBase.projekt));
            }
            if (DataBase.vermStelle != null) {
                printWriter.println(XmlIOProperties.data("d_vermessungsstelle", DataBase.vermStelle));
            }
            if (DataBase.adresse_1 != null) {
                printWriter.println(XmlIOProperties.data("d_adresse", DataBase.adresse_1));
            }
            if (DataBase.adresse_2 != null) {
                printWriter.println(XmlIOProperties.data("d_telefon", DataBase.adresse_2));
            }
            if (DataBase.adresse_3 != null) {
                printWriter.println(XmlIOProperties.data("d_internet", DataBase.adresse_3));
            }
            if (DataBase.bearbeiter != null) {
                printWriter.println(XmlIOProperties.data("d_bearbeiter", DataBase.bearbeiter));
            }
            if (DataBase.gemeinde != null) {
                printWriter.println(XmlIOProperties.data("d_gemeinde", DataBase.gemeinde));
            }
            if (DataBase.gemarkung != null) {
                printWriter.println(XmlIOProperties.data("d_gemarkung", DataBase.gemarkung));
            }
            if (DataBase.flur != null) {
                printWriter.println(XmlIOProperties.data("d_flur", DataBase.flur));
            }
            if (DataBase.flurstueck != null) {
                printWriter.println(XmlIOProperties.data("d_flurstueck", DataBase.flurstueck));
            }
            if (DataBase.katasterAmt != null) {
                printWriter.println(XmlIOProperties.data("d_katasteramt", DataBase.katasterAmt));
            }
            if (DataBase.antrag != null) {
                printWriter.println(XmlIOProperties.data("d_antrag", DataBase.antrag));
            }
            printWriter.println(XmlIOProperties.open("punkte"));
            enumeration = DataBase.P.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((Punkt)enumeration.nextElement()).toXmlLine());
            }
            printWriter.println(XmlIOProperties.close("punkte"));
            printWriter.println(XmlIOProperties.open("messungen"));
            printWriter.println(XmlIOProperties.open("gps"));
            enumeration = DataBase.MG.elements();
            while (enumeration.hasMoreElements()) {
                ((Riss)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("gps"));
            printWriter.println(XmlIOProperties.open("polar"));
            enumeration = DataBase.MP.elements();
            while (enumeration.hasMoreElements()) {
                ((Riss)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("polar"));
            printWriter.println(XmlIOProperties.open("messband"));
            enumeration = DataBase.MM.elements();
            while (enumeration.hasMoreElements()) {
                ((Riss)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("messband"));
            printWriter.println(XmlIOProperties.open("kataster"));
            enumeration = DataBase.MK.elements();
            while (enumeration.hasMoreElements()) {
                ((Riss)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("kataster"));
            printWriter.println(XmlIOProperties.open("einrechnung"));
            enumeration = DataBase.ME.elements();
            while (enumeration.hasMoreElements()) {
                ((Riss)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("einrechnung"));
            printWriter.println(XmlIOProperties.open("vorgaben"));
            enumeration = DataBase.MV.elements();
            while (enumeration.hasMoreElements()) {
                ((Riss)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("vorgaben"));
            printWriter.println(XmlIOProperties.close("messungen"));
            printWriter.println(XmlIOProperties.open("trafosysteme"));
            enumeration = DataBase.T.elements();
            while (enumeration.hasMoreElements()) {
                ((TrafoSystem)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("trafosysteme"));
            printWriter.println(XmlIOProperties.open("bedingungen"));
            printWriter.println(XmlIOProperties.open("homogenisierung"));
            enumeration = DataBase.BH.elements();
            while (enumeration.hasMoreElements()) {
                ((Riss)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("homogenisierung"));
            printWriter.println(XmlIOProperties.open("zwangsbedingungen"));
            enumeration = DataBase.BB.elements();
            while (enumeration.hasMoreElements()) {
                ((Riss)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("zwangsbedingungen"));
            printWriter.println(XmlIOProperties.close("bedingungen"));
            printWriter.println(XmlIOProperties.open("objekte"));
            printWriter.println(XmlIOProperties.open("flurstuecke"));
            enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                ((Flurstueck)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("flurstuecke"));
            printWriter.println(XmlIOProperties.open("gebaeudeobjekte"));
            enumeration = DataBase.GEB.elements();
            while (enumeration.hasMoreElements()) {
                ((Gebaeude)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("gebaeudeobjekte"));
            printWriter.println(XmlIOProperties.open("topographieobjekte"));
            enumeration = DataBase.TOP.elements();
            while (enumeration.hasMoreElements()) {
                ((TopObject)enumeration.nextElement()).writeXmlLine(printWriter);
            }
            printWriter.println(XmlIOProperties.close("topographieobjekte"));
            printWriter.println(XmlIOProperties.close("objekte"));
            printWriter.println(XmlIOProperties.close("dat"));
            printWriter.println(XmlIOProperties.close("kafplot"));
            super.setProgress(100);
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }
}

