/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io.dat;

import de.geocalc.text.IFormat;
import java.io.IOException;

public final class SteuerDaten {
    private static SteuerDaten inputSt = null;
    private String name = null;
    private int IGK = 2;
    private int IGEV = 5;
    private int KPZ1 = 3;
    private int KPZ5 = 1;
    private int ILT4 = 4;
    private int ITER = 9;
    private int IAUS = 0;
    private int IGON = 20;
    private double saR = 0.002;
    private double ao1 = 0.01;
    private double ao3 = 5.0;
    private double mR0 = 1.0;
    private double mS0 = 1.0;
    private double m0 = 0.0;
    private double saM = 5.0;
    private double saZEF = 0.005;
    private double k = 3.3;
    private double am1 = 0.016;
    private double am2 = 1.0E-4;
    private double am3 = 0.0026;
    private double saRe = 0.02;
    private double saG = 0.02;
    private double mP0 = 1.0;
    private double saMk = 0.2;
    private double DXMIN = 0.2;
    private double HOEHE = 0.0;

    public SteuerDaten(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof SteuerDaten) {
            SteuerDaten steuerDaten = (SteuerDaten)object;
            return this.name.equalsIgnoreCase(steuerDaten.name);
        }
        return false;
    }

    public int getKPZ1() {
        return this.KPZ1;
    }

    public int getIGK() {
        return this.IGK;
    }

    public int getIGON() {
        return this.IGON;
    }

    public double getK() {
        return this.k;
    }

    public double getHoehe() {
        return this.HOEHE;
    }

    public void setHoehe(double d) {
        this.HOEHE = d;
    }

    public double getRichtungMf(double d, double d2) {
        return this.saR / Math.sqrt(d2);
    }

    public double getEdmMf(double d, double d2) {
        return (this.ao1 + this.ao3 / 1000000.0 * d) * Math.sqrt(this.mS0) / Math.sqrt(d2);
    }

    public double getEdmGw(double d, double d2) {
        double d3 = (this.ao1 + this.ao3 / 1000000.0 * d) * Math.sqrt(this.mS0) / d2;
        return d3 * d3;
    }

    public double getMassMf(double d, double d2) {
        return (this.am1 + this.am2 * d + this.am3 * Math.sqrt(Math.abs(d))) / Math.sqrt(d2);
    }

    public double getMassGw(double d, double d2) {
        double d3 = (this.am1 + this.am2 * d + this.am3 * Math.sqrt(Math.abs(d))) / d2;
        return d3 * d3;
    }

    public double getOrthoMassstabMf(double d) {
        return this.saMk / Math.sqrt(d);
    }

    public double getAbszMf(double d, double d2, double d3, double d4) {
        double d5 = (this.am1 + this.am3 * Math.sqrt(Math.abs(d))) / Math.sqrt(d3);
        if (d2 != 0.0) {
            d5 += this.saRe / Math.sqrt(d4);
        }
        return d5;
    }

    public double getOrdMf(double d, double d2, double d3) {
        double d4 = this.saG / Math.sqrt(d3);
        if (d != 0.0) {
            d4 += this.getMassMf(d, d2);
        }
        return d4;
    }

    public double getOrdGw(double d, double d2) {
        if (d2 == 0.0) {
            double d3 = this.saG / d2;
            return d3 * d3;
        }
        return this.getMassGw(d, Math.max(d2 -= this.saG, 0.001));
    }

    public double getGpsMf(double d, double d2, double d3, double d4) {
        double d5 = (d3 + d4) / 2.0;
        double d6 = Math.sqrt(d * d + d2 * d2);
        return d6 / Math.sqrt(d5) / 100000.0;
    }

    public double getGeMf(double d) {
        return this.saG / Math.sqrt(d);
    }

    public float getGeGw(double d) {
        double d2 = this.saG / d;
        return (float)(d2 * d2);
    }

    public double getRwMf(double d) {
        return this.saRe / Math.sqrt(d);
    }

    public float getRwGw(double d) {
        double d2 = this.saRe / d;
        return (float)(d2 * d2);
    }

    public static Object parsePropertiesLine(String string) throws IOException {
        block35: {
            if (string == null || string.length() == 0) {
                return null;
            }
            int n = string.indexOf(61);
            if (n < 0) {
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) == ' ') continue;
                    throw new IOException("fehlendes Trennzeichen (=) im Format");
                }
                return null;
            }
            String string2 = null;
            String string3 = null;
            try {
                string2 = string.substring(0, n).trim().toUpperCase();
                string3 = string.substring(n + 1, string.length()).trim();
            }
            catch (Exception exception) {
                throw new IOException("fehlerhaftes Format");
            }
            try {
                if (string2.equals("NAME")) {
                    inputSt = new SteuerDaten(string.substring(n + 1, string.length()).trim());
                    return inputSt;
                }
                if (string2.equals("IGK")) {
                    SteuerDaten.inputSt.IGK = Integer.parseInt(string3);
                    break block35;
                }
                if (string2.equals("IGEV")) {
                    SteuerDaten.inputSt.IGEV = Integer.parseInt(string3);
                    break block35;
                }
                if (string2.equals("KPZ1")) {
                    SteuerDaten.inputSt.KPZ1 = Integer.parseInt(string3);
                    break block35;
                }
                if (string2.equals("KPZ5")) {
                    SteuerDaten.inputSt.KPZ5 = Integer.parseInt(string3);
                    break block35;
                }
                if (string2.equals("ILT4")) {
                    SteuerDaten.inputSt.ILT4 = Integer.parseInt(string3);
                    break block35;
                }
                if (string2.equals("ITER")) {
                    SteuerDaten.inputSt.ITER = Integer.parseInt(string3);
                    break block35;
                }
                if (string2.equals("IAUS")) {
                    SteuerDaten.inputSt.IAUS = Integer.parseInt(string3);
                    break block35;
                }
                if (string2.equals("IGON")) {
                    SteuerDaten.inputSt.IGON = Integer.parseInt(string3);
                    break block35;
                }
                if (string2.equals("SAR")) {
                    SteuerDaten.inputSt.saR = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("AO1")) {
                    SteuerDaten.inputSt.ao1 = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("AO3")) {
                    SteuerDaten.inputSt.ao3 = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("MR0")) {
                    SteuerDaten.inputSt.mR0 = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("MS0")) {
                    SteuerDaten.inputSt.mS0 = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("M0")) {
                    SteuerDaten.inputSt.m0 = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("SAM")) {
                    SteuerDaten.inputSt.saM = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("SAZEF")) {
                    SteuerDaten.inputSt.saZEF = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("K")) {
                    SteuerDaten.inputSt.k = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("AM1")) {
                    SteuerDaten.inputSt.am1 = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("AM2")) {
                    SteuerDaten.inputSt.am2 = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("AM3")) {
                    SteuerDaten.inputSt.am3 = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("SARE")) {
                    SteuerDaten.inputSt.saRe = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("SAG")) {
                    SteuerDaten.inputSt.saG = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("MP0")) {
                    SteuerDaten.inputSt.mP0 = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("SAMK")) {
                    SteuerDaten.inputSt.saMk = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("DXMIN")) {
                    SteuerDaten.inputSt.DXMIN = Double.valueOf(string3);
                    break block35;
                }
                if (string2.equals("HOEHE")) {
                    SteuerDaten.inputSt.HOEHE = Double.valueOf(string3);
                    break block35;
                }
                throw new IOException("unbekannte Variable " + string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("ung\u00fcltiger Wert " + string3 + " in der Variablen " + string2);
            }
            catch (NullPointerException nullPointerException) {
                throw new IOException("ein Steuerdatensatz mu\u00df mit der Variablen NAME beginnen");
            }
        }
        return null;
    }

    public static SteuerDaten parseDatLine(String string, int n, SteuerDaten steuerDaten) throws NumberFormatException {
        int n2 = string.length();
        if (steuerDaten == null) {
            steuerDaten = new SteuerDaten("");
        }
        int n3 = 0;
        if (n == 2) {
            try {
                n3 = 0;
                steuerDaten.IGK = Integer.parseInt(string.substring(0, 2).trim());
                n3 = 2;
                steuerDaten.IGEV = Integer.parseInt(string.substring(2, 4).trim());
                n3 = 4;
                steuerDaten.KPZ1 = Integer.parseInt(string.substring(4, 6).trim());
                n3 = 6;
                steuerDaten.KPZ5 = Integer.parseInt(string.substring(6, 8).trim());
                n3 = 8;
                steuerDaten.saR = Double.valueOf(string.substring(8, 16).trim());
                n3 = 16;
                steuerDaten.ao1 = Double.valueOf(string.substring(16, 24).trim());
                n3 = 24;
                steuerDaten.ao3 = Double.valueOf(string.substring(24, 32).trim());
                n3 = 32;
                steuerDaten.mR0 = Double.valueOf(string.substring(32, 40).trim());
                n3 = 40;
                steuerDaten.mS0 = Double.valueOf(string.substring(40, 48).trim());
                n3 = 48;
                steuerDaten.m0 = Double.valueOf(string.substring(48, 56).trim());
                n3 = 56;
                steuerDaten.saM = Double.valueOf(string.substring(56, 64).trim());
                n3 = 64;
                steuerDaten.saZEF = Double.valueOf(string.substring(64, 72).trim());
                n3 = 72;
                steuerDaten.k = Double.valueOf(string.substring(72, Math.min(80, n2)).trim());
            }
            catch (Exception exception) {
                throw new NumberFormatException("Fehler beim Lesen der ersten Steuerdatenzeile in Spalte " + n3);
            }
        }
        try {
            double d;
            n3 = 0;
            steuerDaten.ILT4 = Integer.parseInt(string.substring(0, 2).trim());
            n3 = 2;
            steuerDaten.ITER = Integer.parseInt(string.substring(2, 4).trim());
            n3 = 4;
            steuerDaten.IAUS = Integer.parseInt(string.substring(4, 6).trim());
            n3 = 6;
            steuerDaten.IGON = Integer.parseInt(string.substring(6, 8).trim());
            n3 = 8;
            steuerDaten.am1 = Double.valueOf(string.substring(8, 16).trim());
            n3 = 16;
            steuerDaten.am2 = Double.valueOf(string.substring(16, 24).trim());
            n3 = 24;
            steuerDaten.am3 = Double.valueOf(string.substring(24, 32).trim());
            n3 = 32;
            steuerDaten.saRe = Double.valueOf(string.substring(32, 40).trim());
            n3 = 40;
            steuerDaten.saG = Double.valueOf(string.substring(40, 48).trim());
            n3 = 48;
            steuerDaten.mP0 = Double.valueOf(string.substring(48, 56).trim());
            n3 = 56;
            steuerDaten.saMk = Double.valueOf(string.substring(56, 64).trim());
            n3 = 64;
            steuerDaten.DXMIN = Double.valueOf(string.substring(64, Math.min(72, n2)).trim());
            if (n2 > 72) {
                n3 = 72;
                d = Double.valueOf(string.substring(72, Math.min(80, n2)).trim());
            } else {
                d = 0.0;
            }
            steuerDaten.HOEHE = d;
        }
        catch (Exception exception) {
            throw new NumberFormatException("Fehler beim Lesen der zweiten Steuerdatenzeile in Spalte " + n3);
        }
        return steuerDaten;
    }

    public String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer(160);
        stringBuffer.append(IFormat.i2.format(this.IGK).toString());
        stringBuffer.append(IFormat.i2.format(this.IGEV).toString());
        stringBuffer.append(IFormat.i2.format(this.KPZ1).toString());
        stringBuffer.append(IFormat.i2.format(this.KPZ5).toString());
        stringBuffer.append(IFormat.f3_4.format(this.saR).toString());
        stringBuffer.append(IFormat.f3_4.format(this.ao1).toString());
        stringBuffer.append(IFormat.f3_4.format(this.ao3).toString());
        stringBuffer.append(IFormat.f3_4.format(this.mR0).toString());
        stringBuffer.append(IFormat.f3_4.format(this.mS0).toString());
        stringBuffer.append(IFormat.f3_4.format(this.m0).toString());
        stringBuffer.append(IFormat.f3_4.format(this.saM).toString());
        stringBuffer.append(IFormat.f3_4.format(this.saZEF).toString());
        stringBuffer.append(IFormat.f3_4.format(this.k).toString());
        stringBuffer.append(IFormat.EOL);
        stringBuffer.append(IFormat.i2.format(this.ILT4).toString());
        stringBuffer.append(IFormat.i2.format(this.ITER).toString());
        stringBuffer.append(IFormat.i2.format(this.IAUS).toString());
        stringBuffer.append(IFormat.i2.format(this.IGON).toString());
        stringBuffer.append(IFormat.f3_4.format(this.am1).toString());
        stringBuffer.append(IFormat.f3_4.format(this.am2).toString());
        stringBuffer.append(IFormat.f3_4.format(this.am3).toString());
        stringBuffer.append(IFormat.f3_4.format(this.saRe).toString());
        stringBuffer.append(IFormat.f3_4.format(this.saG).toString());
        stringBuffer.append(IFormat.f3_4.format(this.mP0).toString());
        stringBuffer.append(IFormat.f3_4.format(this.saMk).toString());
        stringBuffer.append(IFormat.f3_4.format(this.DXMIN).toString());
        if (this.HOEHE > 0.0) {
            stringBuffer.append(IFormat.f3_4.format(this.HOEHE).toString());
        }
        return stringBuffer.toString();
    }
}

