/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io.gg;

import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.io.gg.GGKey;
import de.geocalc.text.GeoNumberFormat;
import java.io.DataOutput;
import java.util.StringTokenizer;
import java.util.Vector;

public final class GGObject
extends Vector {
    public static final int NORMAL = 0;
    public static final int SPLINE = 1;
    public static final int BESCHRIFTUNG = 2;
    private String name;
    private int art;
    private int eb;
    private int typ;
    private GGObject oberObject;
    public double x;
    public double y;

    public final int compareTo(DataContainer dataContainer) {
        return 1;
    }

    public void setArt(int n) {
        this.art = n;
    }

    public int getArt() {
        return this.art;
    }

    public void setEb(int n) {
        this.eb = n;
    }

    public int getEb() {
        return this.eb;
    }

    public void setTyp(int n) {
        this.typ = n;
    }

    public int getTyp() {
        return this.typ;
    }

    public void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public final void setOberObject(GGObject gGObject) {
        this.oberObject = gGObject;
    }

    public final GGObject getOberObject() {
        return this.oberObject;
    }

    public final String getFinalName() {
        if (this.oberObject != null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.oberObject.getFinalName();
            if (string != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append("\t");
            if (this.name != null) {
                stringBuffer.append(this.name);
            }
            return stringBuffer.toString();
        }
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void copyGeom(GGObject gGObject, int n) {
        boolean bl = true;
        block3: for (int i = 0; i < gGObject.size(); ++i) {
            GGKey gGKey = (GGKey)gGObject.elementAt(i);
            switch (gGKey.getTyp()) {
                case 172: {
                    bl = false;
                    continue block3;
                }
                default: {
                    if (bl) {
                        if (n != 1 && n != 3) continue block3;
                        this.addElement(gGKey);
                        continue block3;
                    }
                    if (n != 2 && n != 3) continue block3;
                    this.addElement(gGKey);
                }
            }
        }
    }

    public final Flurstueck toFlurstueck() throws NumberFormatException {
        Flurstueck flurstueck = new Flurstueck();
        String string = this.getFinalName().trim();
        if (string.indexOf("\t") >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t-_/\\");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                switch (n) {
                    case 0: {
                        flurstueck.setGemarkung(Integer.parseInt(string2));
                        break;
                    }
                    case 1: {
                        flurstueck.setFlur(Integer.parseInt(string2));
                        break;
                    }
                    case 2: {
                        flurstueck.setZaehler(Integer.parseInt(string2));
                        flurstueck.setNenner(0);
                        break;
                    }
                    case 3: {
                        flurstueck.setNenner(Integer.parseInt(string2));
                    }
                }
                ++n;
            }
        } else if (string.length() == 19) {
            flurstueck.setGemarkung(Integer.parseInt(string.substring(0, 6)));
            flurstueck.setFlur(Integer.parseInt(string.substring(6, 9)));
            flurstueck.setZaehler(Integer.parseInt(string.substring(9, 14)));
            flurstueck.setNenner(Integer.parseInt(string.substring(14, 17)));
        } else if (string.length() == 9) {
            flurstueck.setGemarkung(Integer.parseInt(string.substring(0, 6)));
            flurstueck.setFlur(Integer.parseInt(string.substring(6, 9)));
        }
        flurstueck.setTeil(0);
        flurstueck.x = this.x;
        flurstueck.y = this.y;
        flurstueck.setOska(this.art);
        if (flurstueck.getZaehler() != -1) {
            flurstueck.setArt(700);
        } else if (flurstueck.getFlur() != -1) {
            flurstueck.setArt(300);
        } else if (flurstueck.getGemarkung() != -1) {
            flurstueck.setArt(200);
        }
        return flurstueck;
    }

    public final Gebaeude toGebaeude() throws NumberFormatException {
        GebaeudeKennzeichen gebaeudeKennzeichen = GebaeudeKennzeichen.parseOutFormat(this.getFinalName().trim());
        if (gebaeudeKennzeichen != null) {
            gebaeudeKennzeichen.x = this.x;
            gebaeudeKennzeichen.y = this.y;
        }
        Gebaeude gebaeude = new Gebaeude(gebaeudeKennzeichen);
        gebaeude.setOska(this.art);
        gebaeude.x = this.x;
        gebaeude.y = this.y;
        return gebaeude;
    }

    public final TopObject toTopObject() throws NumberFormatException {
        TopObject topObject = new TopObject();
        String string = this.getFinalName();
        if (string != null && (string = string.trim()).length() > 0) {
            topObject.setBezeichnung(string);
        }
        topObject.x = this.x;
        topObject.y = this.y;
        topObject.setOska(this.art);
        return topObject;
    }

    public void writeObject(DataOutput dataOutput) {
    }

    public String getClassName() {
        return "GGObj";
    }

    public String getObjectName() {
        return this.getFinalName();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GGObj: ");
        switch (this.typ) {
            case 0: {
                stringBuffer.append('N');
                break;
            }
            case 1: {
                stringBuffer.append('S');
                break;
            }
            case 2: {
                stringBuffer.append('B');
                break;
            }
            default: {
                stringBuffer.append('U');
            }
        }
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr04n.format(this.art).toString());
        stringBuffer.append(" ");
        stringBuffer.append(this.getFinalName());
        return stringBuffer.toString();
    }
}

