/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io.kpv;

import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.TrafoGewicht;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class KpvIOProperties {
    private static final Hashtable ppVal = new Hashtable();
    private static final Hashtable ppIds = new Hashtable();
    private static final Hashtable lpVal = new Hashtable();
    private static final Hashtable lpIds = new Hashtable();
    private static final Hashtable mgVal = new Hashtable();
    private static final Hashtable mgIds = new Hashtable();
    private static final Hashtable tgVal = new Hashtable();
    private static final Hashtable tgIds = new Hashtable();
    public static final int ALL_AREA = 0;
    public static final int FORTF_AREA = 1;
    public static final int GEMARKUNG_AREA = 2;
    public static final int VER = 204;
    public static final int UVER = 105;
    public static int RVER = 204;
    private static Hashtable gemarkungen = new Hashtable();
    private static boolean writeErrors = false;
    private static boolean writeStatistik = true;
    private static int areaSwitch = 0;

    public static void setAreaSwitch(int n) {
        areaSwitch = n;
    }

    public static int getAreaSwitch() {
        return areaSwitch;
    }

    public static void writeStatistik(boolean bl) {
        writeStatistik = bl;
    }

    public static boolean writeStatistik() {
        return writeStatistik;
    }

    public static void writeErrors(boolean bl) {
        writeErrors = bl;
    }

    public static boolean writeErrors() {
        return writeErrors;
    }

    public static void setGemarkungen(String string) {
        KpvIOProperties.clearGemarkungen();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                KpvIOProperties.addGemarkung(Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (Exception exception) {}
        }
    }

    public static void addGemarkung(int n) {
        Integer n2 = new Integer(n);
        gemarkungen.put(n2, n2);
    }

    public static boolean hasGemarkung(int n) {
        return gemarkungen.get(new Integer(n)) != null;
    }

    public static void clearGemarkungen() {
        gemarkungen.clear();
    }

    public static void setPunktParameter(int n, PunktParameter punktParameter) {
        Integer n2 = new Integer(n);
        ppVal.put(n2, punktParameter);
        ppIds.put(punktParameter, n2);
    }

    public static short getPunktParameterId(PunktParameter punktParameter) {
        Integer n = (Integer)ppIds.get(punktParameter);
        return n != null ? n.shortValue() : (short)0;
    }

    public static PunktParameter getPunktParameterVal(int n) {
        PunktParameter punktParameter = (PunktParameter)ppVal.get(new Integer(n));
        return punktParameter != null ? punktParameter : PunktParameter.VOID;
    }

    public static void setLinieParameter(int n, LinieParameter linieParameter) {
        Integer n2 = new Integer(n);
        lpVal.put(n2, linieParameter);
        lpIds.put(linieParameter, n2);
    }

    public static short getLinieParameterId(LinieParameter linieParameter) {
        try {
            return ((Integer)lpIds.get(linieParameter)).shortValue();
        }
        catch (Exception exception) {
            System.out.println(linieParameter);
            return 0;
        }
    }

    public static LinieParameter getLinieParameterVal(int n) {
        return (LinieParameter)lpVal.get(new Integer(n));
    }

    public static void setMessungGewicht(int n, MessungGewicht messungGewicht) {
        Integer n2 = new Integer(n);
        mgVal.put(n2, messungGewicht);
        mgIds.put(messungGewicht, n2);
    }

    public static short getMessungGewichtId(MessungGewicht messungGewicht) {
        Integer n = (Integer)mgIds.get(messungGewicht);
        return n.shortValue();
    }

    public static MessungGewicht getMessungGewichtVal(int n) {
        return (MessungGewicht)mgVal.get(new Integer(n));
    }

    public static void setTrafoGewicht(int n, TrafoGewicht trafoGewicht) {
        Integer n2 = new Integer(n);
        tgVal.put(n2, trafoGewicht);
        tgIds.put(trafoGewicht, n2);
    }

    public static short getTrafoGewichtId(TrafoGewicht trafoGewicht) {
        return ((Integer)tgIds.get(trafoGewicht)).shortValue();
    }

    public static TrafoGewicht getTrafoGewichtVal(int n) {
        return (TrafoGewicht)tgVal.get(new Integer(n));
    }

    public static void flushTables() {
        ppVal.clear();
        ppIds.clear();
        lpVal.clear();
        lpIds.clear();
        mgVal.clear();
        mgIds.clear();
        tgVal.clear();
        tgIds.clear();
    }
}

