/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io.sta;

import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.NummerZuschlag;
import de.geocalc.kafplot.Punkt;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;

public final class StaIOProperties {
    public static final String SYS_TYP_ORTHO = "   ";
    public static final String SYS_TYP_DIGIT = "DIG";
    public static final String SYS_TYP_FLUCHT = "FLU";
    public static final String SYS_TYP_ABSTAND = "APL";
    public static final String SYS_TYP_PARALLEL_ABSTAND = "PMA";
    public static final String SYS_TYP_SPANNMASS = "SPN";
    public static final String SYS_TYP_SCHNITT = "GRS";
    public static final String SYS_TYP_RECHTER_WINKEL = "REW";
    public static final String SYS_TYP_GERADE = "GER";
    public static final String SYS_TYP_PARALLEL = "PAR";
    public static final String SYS_TYP_KOORD = "KOO";
    public static final String SYS_TYP_POLAR = "POL";
    public static final String KAN_TYP_SPANNMASS = "     ";
    public static final String KAN_TYP_POLAR = "POLAR";
    public static final String KAN_TYP_IDENT = "IDENT";
    public static final String END_BLOCK = "";
    public static final String LIST_HILFSELEM = "Hilfselemente";
    public static String SYS_NAME_ORTHO = "M";
    public static String SYS_NAME_FLUCHT = "D";
    public static String SYS_NAME_PARALLEL = "P";
    public static String SYS_NAME_SPANNMASS = "S";
    public static String SYS_NAME_TRAFO = "L";
    public static String SYS_NAME_ABSTAND = "A";
    public static String SYS_NAME_POLAR = "W";
    public static String SYS_NAME_GPS = "G";
    public static String SYS_NAME_RECHTWINKEL = "R";
    public static String SYS_NAME_DELIM = "";
    private static boolean writeUnusedPoints = true;
    private static boolean writeUmnumPoints = true;
    private static boolean writePointMf = false;
    private static boolean writeAllAsDigit = false;
    private static boolean writeBogenSchnittDef = true;
    private static boolean writeDateAsText = false;
    private static boolean writeErrorValues = true;
    private static boolean writeSystemGewicht = true;
    private static boolean writeIndividualGewicht = false;
    private static boolean writeApproxPoints = false;
    public static int pnrModus = 15;
    public static double mfFactor = 1.0;
    public static double aMf = 50.0;
    public static double hMf = 999.0;
    public static double eMf = 9999.0;
    private static NummerZuschlag lokNrZuschlag = null;

    public static String kanTypToSysTyp(String string) {
        if (string.equals(KAN_TYP_SPANNMASS)) {
            return SYS_TYP_SPANNMASS;
        }
        if (string.equals(KAN_TYP_POLAR)) {
            return SYS_TYP_POLAR;
        }
        return SYS_TYP_SPANNMASS;
    }

    public static boolean writeUnusedPoints() {
        return writeUnusedPoints;
    }

    public static void writeUnusedPoints(boolean bl) {
        writeUnusedPoints = bl;
    }

    public static boolean writeUmnumPoints() {
        return writeUmnumPoints;
    }

    public static void writeUmnumPoints(boolean bl) {
        writeUmnumPoints = bl;
    }

    public static boolean writePointMf() {
        return writePointMf;
    }

    public static void writePointMf(boolean bl) {
        writePointMf = bl;
    }

    public static boolean writeAllAsDigit() {
        return writeAllAsDigit;
    }

    public static void writeAllAsDigit(boolean bl) {
        writeAllAsDigit = bl;
    }

    public static boolean writeBogenSchnittDef() {
        return writeBogenSchnittDef;
    }

    public static void writeBogenSchnittDef(boolean bl) {
        writeBogenSchnittDef = bl;
    }

    public static boolean writeErrorValues() {
        return writeErrorValues;
    }

    public static void writeErrorValues(boolean bl) {
        writeErrorValues = bl;
    }

    public static boolean writeDateAsText() {
        return writeDateAsText;
    }

    public static void writeDateAsText(boolean bl) {
        writeDateAsText = bl;
    }

    public static boolean writeSystemGewicht() {
        return writeSystemGewicht;
    }

    public static void writeSystemGewicht(boolean bl) {
        writeSystemGewicht = bl;
    }

    public static boolean writeIndividualGewicht() {
        return writeIndividualGewicht;
    }

    public static void writeIndividualGewicht(boolean bl) {
        writeIndividualGewicht = bl;
    }

    public static boolean writeApproxPoints() {
        return writeApproxPoints;
    }

    public static void writeApproxPoints(boolean bl) {
        writeApproxPoints = bl;
    }

    public static int getPnrModus() {
        return pnrModus;
    }

    public static void setPnrModus(int n) {
        pnrModus = n;
    }

    public static void setLokalNrZuschlag(NummerZuschlag nummerZuschlag) {
        lokNrZuschlag = nummerZuschlag;
    }

    public static NummerZuschlag getLokalNrZuschlag() {
        return lokNrZuschlag;
    }

    public static String getPunktNummer(Punkt punkt) {
        StringBuffer stringBuffer = new StringBuffer(15);
        if (punkt.isKatasterPunkt()) {
            stringBuffer.append(GeoNumberFormat.nr.format(punkt.buildKatNr(pnrModus, writeUmnumPoints)).toString());
        } else {
            NummerZuschlag nummerZuschlag = StaIOProperties.getLokalNrZuschlag();
            if (nummerZuschlag == null) {
                stringBuffer.append(GeoNumberFormat.nr.format(punkt.getNr(writeUmnumPoints)).toString());
            } else {
                String string = Long.toString(nummerZuschlag.getNummer(punkt.getNr(writeUmnumPoints)));
                int n = string.length();
                if (n > 5) {
                    int n2 = n - 6;
                    char[] cArray = string.toCharArray();
                    if (cArray[n2] == '0') {
                        cArray[n2] = 88;
                    }
                    string = String.valueOf(cArray);
                }
                stringBuffer.append(string);
            }
        }
        return IFormat.getRightString(stringBuffer.toString(), 15);
    }

    public static String createGmkFlurString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (DataBase.gemarkung != null && DataBase.flur != null) {
            Gemarkung gemarkung = Gemarkung.getGemarkung(DataBase.gemeinde, DataBase.gemarkung);
            if (gemarkung != null) {
                stringBuffer.append(GeoNumberFormat.nr04n.format(gemarkung.getNummer()).toString());
            }
            stringBuffer.append(GeoNumberFormat.nr03n.format(Integer.parseInt(IFormat.getFirstNumbers(DataBase.flur))).toString());
        }
        return stringBuffer.toString();
    }

    public static double getMfFactor() {
        return mfFactor;
    }

    public static void setMfFactor(double d) {
        mfFactor = d;
    }

    public static String listToString(int n) {
        switch (n) {
            case 101: {
                return "Punkte";
            }
            case 201: {
                return "PolAufmass";
            }
            case 202: {
                return "GpsAufmass";
            }
            case 203: {
                return "LokAufmass";
            }
            case 204: {
                return "Nachweis";
            }
            case 205: {
                return "Vorgaben";
            }
            case 206: {
                return "Fluchtung";
            }
            case 301: {
                return "NivAufmass";
            }
            case 302: {
                return "PolAufmass";
            }
            case 401: {
                return "Trafo";
            }
            case 402: {
                return "Digit";
            }
            case 601: {
                return "Homogen";
            }
            case 602: {
                return "Homogen";
            }
        }
        return "ohne";
    }
}

