/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io.sta;

import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.TrafoGewicht;
import java.util.Enumeration;
import java.util.Vector;

public class StaSigma {
    private static final StaSigma DEFAULT_MLI = new StaSigma(0.0f, "MLI-N-010", 0.1f, 0.1f);
    private static final StaSigma DEFAULT_SPN = new StaSigma(0.0f, "SPN-N-010", 0.1f);
    private static final StaSigma DEFAULT_FLU = new StaSigma(0.0f, "MLI-N-000", 0.0f, 0.001f);
    private static final StaSigma DEFAULT_FLU5 = new StaSigma(0.0f, "MLI-N-005", 0.0f, 0.05f);
    private static final StaSigma DEFAULT_DIG = new StaSigma(0.0f, "DIG-4-010", 0.1f);
    static Vector mli = new Vector();
    static Vector spn = new Vector();
    static Vector dig = new Vector();
    float k1;
    float s1;
    float s2;
    float s3;
    float s4;
    String name;

    public StaSigma() {
    }

    public StaSigma(float f, String string, float f2) {
        this(f, string, 0.0f, f2, 0.0f, 0.0f);
    }

    public StaSigma(float f, String string, float f2, float f3) {
        this(f, string, f2, f3, 0.0f, 0.0f);
    }

    public StaSigma(float f, String string, float f2, float f3, float f4, float f5) {
        this.k1 = f;
        this.name = string;
        this.s1 = f2;
        this.s2 = f3;
        this.s3 = f4;
        this.s4 = f5;
    }

    public String getName() {
        return this.name;
    }

    public float getS1() {
        return this.s1;
    }

    public float getS2() {
        return this.s2;
    }

    public static final StaSigma getMliSigma(MessungGewicht messungGewicht) {
        if (messungGewicht != null) {
            float f = messungGewicht.getMid();
            Enumeration enumeration = mli.elements();
            while (enumeration.hasMoreElements()) {
                StaSigma staSigma = (StaSigma)enumeration.nextElement();
                if (!(staSigma.k1 <= f)) continue;
                return staSigma;
            }
        }
        return DEFAULT_MLI;
    }

    public static final StaSigma getFluSigma(MessungGewicht messungGewicht) {
        if (messungGewicht.getG3() < 1.0f) {
            return DEFAULT_FLU5;
        }
        return DEFAULT_FLU;
    }

    public static final StaSigma getSpnSigma(MessungGewicht messungGewicht) {
        if (messungGewicht != null) {
            float f = messungGewicht.getMid();
            Enumeration enumeration = spn.elements();
            while (enumeration.hasMoreElements()) {
                StaSigma staSigma = (StaSigma)enumeration.nextElement();
                if (!(staSigma.k1 <= f)) continue;
                return staSigma;
            }
        }
        return DEFAULT_SPN;
    }

    public static final StaSigma getMliSigma(float f, float f2) {
        StaSigma staSigma = null;
        Enumeration enumeration = mli.elements();
        while (enumeration.hasMoreElements()) {
            StaSigma staSigma2 = (StaSigma)enumeration.nextElement();
            if (staSigma2.s1 < f && staSigma2.s2 < f2) {
                return staSigma2;
            }
            staSigma = staSigma2;
        }
        return staSigma;
    }

    public static final StaSigma getDigSigma(TrafoGewicht trafoGewicht) {
        if (trafoGewicht != null) {
            StaSigma staSigma = null;
            float f = trafoGewicht.getG1();
            Enumeration enumeration = dig.elements();
            while (enumeration.hasMoreElements()) {
                StaSigma staSigma2 = (StaSigma)enumeration.nextElement();
                if (f <= staSigma2.k1) {
                    return staSigma2;
                }
                staSigma = staSigma2;
            }
            return staSigma;
        }
        return DEFAULT_DIG;
    }

    static {
        mli.addElement(new StaSigma(5.0f, "MLI-N-000", 0.03f, 0.03f));
        mli.addElement(new StaSigma(1.5f, "MLI-N-005", 0.05f, 0.05f));
        mli.addElement(new StaSigma(1.0f, "MLI-N-006", 0.06f, 0.06f));
        mli.addElement(new StaSigma(0.7f, "MLI-N-008", 0.08f, 0.08f));
        mli.addElement(new StaSigma(0.6f, "MLI-N-010", 0.1f, 0.1f));
        mli.addElement(new StaSigma(0.5f, "MLI-N-011", 0.11f, 0.11f));
        mli.addElement(new StaSigma(0.4f, "MLI-N-012", 0.12f, 0.12f));
        mli.addElement(new StaSigma(0.3f, "MLI-N-013", 0.13f, 0.13f));
        mli.addElement(new StaSigma(0.2f, "MLI-N-015", 0.15f, 0.15f));
        mli.addElement(new StaSigma(0.0f, "MLI-N-020", 0.2f, 0.2f));
        spn.addElement(new StaSigma(1.5f, "SPN-N-005", 0.05f));
        spn.addElement(new StaSigma(1.0f, "SPN-N-006", 0.06f));
        spn.addElement(new StaSigma(0.7f, "SPN-N-008", 0.08f));
        spn.addElement(new StaSigma(0.6f, "SPN-N-010", 0.1f));
        spn.addElement(new StaSigma(0.4f, "SPN-N-012", 0.12f));
        spn.addElement(new StaSigma(0.2f, "SPN-N-015", 0.15f));
        spn.addElement(new StaSigma(0.0f, "SPN-N-020", 0.2f));
        dig.addElement(new StaSigma(0.05f, "DIG-4-005", 0.05f));
        dig.addElement(new StaSigma(0.1f, "DIG-4-010", 0.1f));
        dig.addElement(new StaSigma(0.2f, "DIG-4-020", 0.2f));
        dig.addElement(new StaSigma(0.3f, "DIG-4-050", 0.5f));
        dig.addElement(new StaSigma(2.0f, "DIG-4-200", 2.0f));
        dig.addElement(new StaSigma(3.0f, "DIG-4-300", 3.0f));
        dig.addElement(new StaSigma(4.0f, "DIG-4-400", 4.0f));
    }
}

