/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io.xml;

import de.geocalc.kafplot.io.xml.XmlIOConstants;
import de.geocalc.text.IFormat;

public class XmlIOProperties
implements XmlIOConstants {
    private static String tab = "  ";
    public static String TAB = "";

    public static void shiftRight() {
        StringBuffer stringBuffer = new StringBuffer(TAB);
        stringBuffer.append(tab);
        TAB = stringBuffer.toString();
    }

    public static void shiftLeft() {
        TAB = TAB.length() >= tab.length() ? TAB.substring(0, TAB.length() - tab.length()) : "";
    }

    public static void setTabulatorWidth(int n) {
        tab = IFormat.getSpaces(n);
    }

    public static int getTabulatorWidth() {
        return tab.length();
    }

    public static String getTabulator() {
        return TAB;
    }

    public static String getHeader() {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>" + EOL + "<!DOCTYPE kafplot SYSTEM \"kafplot.dtd\">" + EOL + "<?xml-stylesheet type=\"text/xsl\" href=\"kafplot.xsl\" ?>";
    }

    public static String open(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAB);
        stringBuffer.append('<');
        stringBuffer.append(string);
        stringBuffer.append('>');
        XmlIOProperties.shiftRight();
        return stringBuffer.toString();
    }

    public static String openln(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAB);
        stringBuffer.append('<');
        stringBuffer.append(string);
        stringBuffer.append('>');
        stringBuffer.append(EOL);
        XmlIOProperties.shiftRight();
        return stringBuffer.toString();
    }

    public static String open(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAB);
        stringBuffer.append('<');
        stringBuffer.append(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(">");
        XmlIOProperties.shiftRight();
        return stringBuffer.toString();
    }

    public static String openln(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAB);
        stringBuffer.append('<');
        stringBuffer.append(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(">");
        stringBuffer.append(EOL);
        XmlIOProperties.shiftRight();
        return stringBuffer.toString();
    }

    public static String close(String string) {
        XmlIOProperties.shiftLeft();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAB);
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String closeln(String string) {
        XmlIOProperties.shiftLeft();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAB);
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append('>');
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public static String data(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAB);
        stringBuffer.append('<');
        stringBuffer.append(string);
        stringBuffer.append('>');
        stringBuffer.append(XmlIOProperties.legal(string2));
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String dataln(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAB);
        stringBuffer.append('<');
        stringBuffer.append(string);
        stringBuffer.append('>');
        stringBuffer.append(XmlIOProperties.legal(string2));
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append('>');
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public static String data(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAB);
        stringBuffer.append('<');
        stringBuffer.append(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(" />");
        return stringBuffer.toString();
    }

    public static String dataln(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAB);
        stringBuffer.append('<');
        stringBuffer.append(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(" />");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public static String att(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("=\"");
        stringBuffer.append(XmlIOProperties.legal(string2));
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    private static String legal(String string) {
        return string;
    }
}

