/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.text;

import de.geocalc.text.DecimalFormatSymbols;
import de.geocalc.text.DigitList;
import de.geocalc.text.NumberFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Locale;

public class DecimalFormat
extends NumberFormat {
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    private transient DigitList digitList = new DigitList();
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private int multiplier = 1;
    private byte groupingSize = (byte)3;
    private boolean decimalSeparatorAlwaysShown = false;
    private transient boolean isCurrencyFormat = false;
    private DecimalFormatSymbols symbols = null;
    private boolean useExponentialNotation;
    private byte minExponentDigits;
    private boolean exponentSignAlwaysShown = false;
    private BigDecimal roundingIncrement = null;
    private transient double roundingDouble = 0.0;
    private int roundingMode = 6;
    private int formatWidth = 0;
    private char pad = (char)32;
    private int padPosition = 0;
    static final int currentSerialVersion = 2;
    private int serialVersionOnStream = 2;
    public static final int PAD_BEFORE_PREFIX = 0;
    public static final int PAD_AFTER_PREFIX = 1;
    public static final int PAD_BEFORE_SUFFIX = 2;
    public static final int PAD_AFTER_SUFFIX = 3;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    static final String PATTERN_EXPONENT = "E";
    static final char PATTERN_PAD_ESCAPE = '*';
    static final char PATTERN_PLUS_SIGN = '+';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    static final long serialVersionUID = 864413376551465018L;

    public DecimalFormat() {
        Locale locale = Locale.getDefault();
        String string = DecimalFormat.getPattern(locale, 0);
        this.symbols = new DecimalFormatSymbols(locale);
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string) {
        this.symbols = new DecimalFormatSymbols(Locale.getDefault());
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        this.applyPattern(string, false);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer) {
        return this.format(d, stringBuffer, new FieldPosition(1));
    }

    public StringBuffer format(long l, StringBuffer stringBuffer) {
        return this.format(l, stringBuffer, new FieldPosition(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        if (Double.isNaN(d)) {
            stringBuffer.append(this.symbols.getNaN());
            this.addPadding(stringBuffer, false, false);
            return stringBuffer;
        }
        boolean bl2 = bl = d < 0.0 || d == 0.0 && 1.0 / d < 0.0;
        if (bl) {
            d = -d;
        }
        if (this.multiplier != 1) {
            d *= (double)this.multiplier;
        }
        if (this.roundingDouble > 0.0) {
            d = this.roundingDouble * DecimalFormat.round(d / this.roundingDouble, this.roundingMode, bl);
        }
        if (Double.isInfinite(d)) {
            stringBuffer.append(bl ? this.negativePrefix : this.positivePrefix);
            stringBuffer.append(this.symbols.getInfinity());
            stringBuffer.append(bl ? this.negativeSuffix : this.positiveSuffix);
            this.addPadding(stringBuffer, true, bl);
            return stringBuffer;
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(d, this.useExponentialNotation ? this.getMinimumIntegerDigits() + this.getMaximumFractionDigits() : this.getMaximumFractionDigits(), !this.useExponentialNotation);
            return this.subformat(stringBuffer, fieldPosition, bl, false);
        }
    }

    private static double round(double d, int n, boolean bl) {
        switch (n) {
            case 2: {
                return bl ? Math.floor(d) : Math.ceil(d);
            }
            case 3: {
                return bl ? Math.ceil(d) : Math.floor(d);
            }
            case 1: {
                return Math.floor(d);
            }
            case 0: {
                return Math.ceil(d);
            }
            case 6: {
                double d2 = Math.floor(d);
                if (d - d2 != 0.5) {
                    return Math.rint(d);
                }
                return (d2 /= 2.0) == Math.floor(d2) ? Math.floor(d) : Math.floor(d) + 1.0;
            }
            case 5: {
                return d - Math.floor(d) <= 0.5 ? Math.floor(d) : Math.ceil(d);
            }
            case 4: {
                return d - Math.floor(d) < 0.5 ? Math.floor(d) : Math.ceil(d);
            }
            case 7: {
                if (d != Math.floor(d)) {
                    throw new ArithmeticException("Rounding necessary");
                }
                return d;
            }
        }
        throw new IllegalArgumentException("Invalid rounding mode: " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        if (this.roundingIncrement != null) {
            return this.format(BigDecimal.valueOf(l), stringBuffer, fieldPosition);
        }
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        if (this.multiplier != 1) {
            boolean bl3 = false;
            if (l < 0L) {
                long l2 = Long.MIN_VALUE / (long)this.multiplier;
                bl3 = l < l2;
            } else {
                long l3 = Long.MAX_VALUE / (long)this.multiplier;
                boolean bl4 = bl3 = l > l3;
            }
            if (bl3) {
                return this.format(BigInteger.valueOf(bl ? -l : l), stringBuffer, fieldPosition);
            }
        }
        l *= (long)this.multiplier;
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(l, this.useExponentialNotation ? this.getMinimumIntegerDigits() + this.getMaximumFractionDigits() : 0);
            return this.subformat(stringBuffer, fieldPosition, bl, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.roundingIncrement != null) {
            return this.format(new BigDecimal(bigInteger), stringBuffer, fieldPosition);
        }
        if (this.multiplier != 1) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(this.multiplier));
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(bigInteger, this.useExponentialNotation ? this.getMinimumIntegerDigits() + this.getMaximumFractionDigits() : 0);
            return this.subformat(stringBuffer, fieldPosition, bigInteger.signum() < 0, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.multiplier != 1) {
            bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(this.multiplier));
        }
        if (this.roundingIncrement != null) {
            bigDecimal = bigDecimal.divide(this.roundingIncrement, 0, this.roundingMode).multiply(this.roundingIncrement);
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(bigDecimal, this.useExponentialNotation ? this.getMinimumIntegerDigits() + this.getMaximumFractionDigits() : this.getMaximumFractionDigits(), !this.useExponentialNotation);
            return this.subformat(stringBuffer, fieldPosition, bigDecimal.signum() < 0, false);
        }
    }

    private StringBuffer subformat(StringBuffer stringBuffer, FieldPosition fieldPosition, boolean bl, boolean bl2) {
        char c = this.symbols.getZeroDigit();
        int n = c - 48;
        char c2 = this.symbols.getGroupingSeparator();
        char c3 = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
        int n2 = this.getMaximumIntegerDigits();
        int n3 = this.getMinimumIntegerDigits();
        if (this.digitList.isZero()) {
            this.digitList.decimalAt = 0;
        }
        stringBuffer.append(bl ? this.negativePrefix : this.positivePrefix);
        if (this.useExponentialNotation) {
            boolean bl3;
            int n4;
            int n5 = this.digitList.decimalAt;
            if (n2 > 1 && n2 != n3) {
                n5 = n5 > 0 ? (n5 - 1) / n2 : n5 / n2 - 1;
                n5 *= n2;
            } else {
                n5 -= n3 > 0 || this.getMinimumFractionDigits() > 0 ? n3 : 1;
            }
            int n6 = n3 + this.getMinimumFractionDigits();
            int n7 = this.digitList.isZero() ? n3 : this.digitList.decimalAt - n5;
            int n8 = this.digitList.count;
            if (n6 > n8) {
                n8 = n6;
            }
            if (n7 > n8) {
                n8 = n7;
            }
            for (n4 = 0; n4 < n8; ++n4) {
                if (n4 == n7) {
                    stringBuffer.append(c3);
                }
                stringBuffer.append(n4 < this.digitList.count ? (char)(this.digitList.digits[n4] + n) : c);
            }
            if (fieldPosition.getField() == 0 || fieldPosition.getField() == 1) {
                // empty if block
            }
            stringBuffer.append(this.symbols.getExponentSeparator());
            if (this.digitList.isZero()) {
                n5 = 0;
            }
            boolean bl4 = bl3 = n5 < 0;
            if (bl3) {
                n5 = -n5;
                stringBuffer.append(this.symbols.getMinusSign());
            } else if (this.exponentSignAlwaysShown) {
                stringBuffer.append(this.symbols.getPlusSign());
            }
            this.digitList.set(n5);
            for (n4 = this.digitList.decimalAt; n4 < this.minExponentDigits; ++n4) {
                stringBuffer.append(c);
            }
            for (n4 = 0; n4 < this.digitList.decimalAt; ++n4) {
                stringBuffer.append(n4 < this.digitList.count ? (char)(this.digitList.digits[n4] + n) : c);
            }
        } else {
            boolean bl5;
            int n9;
            int n10 = n3;
            int n11 = 0;
            if (this.digitList.decimalAt > 0 && n10 < this.digitList.decimalAt) {
                n10 = this.digitList.decimalAt;
            }
            if (n10 > n2) {
                n10 = n2;
                n11 = this.digitList.decimalAt - n10;
            }
            int n12 = stringBuffer.length();
            for (n9 = n10 - 1; n9 >= 0; --n9) {
                if (n9 < this.digitList.decimalAt && n11 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n11++] + n));
                } else {
                    stringBuffer.append(c);
                }
                if (!this.isGroupingUsed() || n9 <= 0 || this.groupingSize == 0 || n9 % this.groupingSize != 0) continue;
                stringBuffer.append(c2);
            }
            boolean bl6 = bl5 = this.getMinimumFractionDigits() > 0 || !bl2 && n11 < this.digitList.count;
            if (!bl5 && stringBuffer.length() == n12) {
                stringBuffer.append(c);
            }
            if (this.decimalSeparatorAlwaysShown || bl5) {
                stringBuffer.append(c3);
            }
            for (n9 = 0; n9 < this.getMaximumFractionDigits() && (n9 < this.getMinimumFractionDigits() || !bl2 && n11 < this.digitList.count); ++n9) {
                if (-1 - n9 > this.digitList.decimalAt - 1) {
                    stringBuffer.append(c);
                    continue;
                }
                if (!bl2 && n11 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n11++] + n));
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        stringBuffer.append(bl ? this.negativeSuffix : this.positiveSuffix);
        this.addPadding(stringBuffer, true, bl);
        return stringBuffer;
    }

    private final void addPadding(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        int n;
        if (this.formatWidth > 0 && (n = this.formatWidth - stringBuffer.length()) > 0) {
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.pad;
            }
            switch (this.padPosition) {
                case 1: {
                    if (bl) {
                        stringBuffer.insert(bl2 ? this.negativePrefix.length() : this.positivePrefix.length(), cArray);
                        break;
                    }
                }
                case 0: {
                    stringBuffer.insert(0, cArray);
                    break;
                }
                case 2: {
                    if (bl) {
                        stringBuffer.insert(stringBuffer.length() - (bl2 ? this.negativeSuffix.length() : this.positiveSuffix.length()), cArray);
                        break;
                    }
                }
                case 3: {
                    stringBuffer.append(cArray);
                }
            }
        }
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        int n;
        int n2;
        if (this.formatWidth > 0) {
            for (n2 = n = parsePosition.getIndex(); n2 < string.length() && string.charAt(n2) == this.pad; ++n2) {
            }
            parsePosition.setIndex(n2);
        }
        if (string.regionMatches(parsePosition.getIndex(), this.symbols.getNaN(), 0, this.symbols.getNaN().length())) {
            parsePosition.setIndex(parsePosition.getIndex() + this.symbols.getNaN().length());
            return new Double(Double.NaN);
        }
        boolean[] blArray = new boolean[2];
        if (!this.subparse(string, parsePosition, this.digitList, false, blArray)) {
            parsePosition.setIndex(n);
            return null;
        }
        if (this.formatWidth < 0) {
            for (n2 = parsePosition.getIndex(); n2 < string.length() && string.charAt(n2) == this.pad; ++n2) {
            }
            parsePosition.setIndex(n2);
        }
        if (blArray[0]) {
            return new Double(blArray[1] ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
        }
        if (!blArray[1] && this.digitList.isZero()) {
            return new Double(-0.0);
        }
        int n3 = this.multiplier;
        while (n3 % 10 == 0) {
            --this.digitList.decimalAt;
            n3 /= 10;
        }
        if (n3 == 1 && this.digitList.isIntegral()) {
            BigInteger bigInteger = this.digitList.getBigInteger(blArray[1]);
            return bigInteger.bitLength() < 64 ? new Long(bigInteger.longValue()) : bigInteger;
        }
        BigDecimal bigDecimal = this.digitList.getBigDecimal(blArray[1]);
        if (n3 != 1) {
            bigDecimal = bigDecimal.divide(BigDecimal.valueOf(n3), 6);
        }
        return bigDecimal;
    }

    private final boolean subparse(String string, ParsePosition parsePosition, DigitList digitList, boolean bl, boolean[] blArray) {
        int n = parsePosition.getIndex();
        int n2 = parsePosition.getIndex();
        boolean bl2 = string.regionMatches(n, this.positivePrefix, 0, this.positivePrefix.length());
        boolean bl3 = string.regionMatches(n, this.negativePrefix, 0, this.negativePrefix.length());
        if (bl2 && bl3) {
            if (this.positivePrefix.length() > this.negativePrefix.length()) {
                bl3 = false;
            } else if (this.positivePrefix.length() < this.negativePrefix.length()) {
                bl2 = false;
            }
        }
        if (bl2) {
            n += this.positivePrefix.length();
        } else if (bl3) {
            n += this.negativePrefix.length();
        } else {
            return false;
        }
        blArray[0] = false;
        if (!bl && string.regionMatches(n, this.symbols.getInfinity(), 0, this.symbols.getInfinity().length())) {
            n += this.symbols.getInfinity().length();
            blArray[0] = true;
        } else {
            digitList.count = 0;
            digitList.decimalAt = 0;
            char c = this.symbols.getZeroDigit();
            char c2 = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
            char c3 = this.symbols.getGroupingSeparator();
            String string2 = this.symbols.getExponentSeparator();
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = -1;
            while (n < string.length()) {
                char c4 = string.charAt(n);
                n4 = c4 - c;
                if (n4 < 0 || n4 > 9) {
                    n4 = Character.digit(c4, 10);
                }
                if (n4 == 0) {
                    n6 = -1;
                    bl6 = true;
                    if (digitList.count == 0) {
                        if (bl4) {
                            --digitList.decimalAt;
                        }
                    } else {
                        ++n5;
                        digitList.append((char)(n4 + 48));
                    }
                } else if (n4 > 0 && n4 <= 9) {
                    bl6 = true;
                    ++n5;
                    digitList.append((char)(n4 + 48));
                    n6 = -1;
                } else if (!bl && c4 == c2) {
                    if (this.isParseIntegerOnly() || bl4) break;
                    digitList.decimalAt = n5;
                    bl4 = true;
                } else if (!bl && c4 == c3 && this.isGroupingUsed()) {
                    if (bl4) break;
                    n6 = n;
                } else {
                    if (bl || bl5 || !string.regionMatches(n, string2, 0, string2.length())) break;
                    boolean bl7 = false;
                    int n7 = n + string2.length();
                    if (n7 < string.length()) {
                        c4 = string.charAt(n7);
                        if (c4 == this.symbols.getPlusSign()) {
                            ++n7;
                        } else if (c4 == this.symbols.getMinusSign()) {
                            ++n7;
                            bl7 = true;
                        }
                    }
                    DigitList digitList2 = new DigitList();
                    digitList2.count = 0;
                    while (n7 < string.length()) {
                        n4 = string.charAt(n7) - c;
                        if (n4 < 0 || n4 > 9) {
                            n4 = Character.digit(c4, 10);
                        }
                        if (n4 < 0 || n4 > 9) break;
                        digitList2.append((char)(n4 + 48));
                        ++n7;
                    }
                    if (digitList2.count <= 0) break;
                    digitList2.decimalAt = digitList2.count;
                    n3 = (int)digitList2.getLong();
                    if (bl7) {
                        n3 = -n3;
                    }
                    n = n7;
                    bl5 = true;
                    break;
                }
                ++n;
            }
            if (n6 != -1) {
                n = n6;
            }
            if (!bl4) {
                digitList.decimalAt = n5;
            }
            digitList.decimalAt += n3;
            if (!bl6 && n5 == 0) {
                parsePosition.setIndex(n2);
                return false;
            }
        }
        if (bl2) {
            bl2 = string.regionMatches(n, this.positiveSuffix, 0, this.positiveSuffix.length());
        }
        if (bl3) {
            bl3 = string.regionMatches(n, this.negativeSuffix, 0, this.negativeSuffix.length());
        }
        if (bl2 && bl3) {
            if (this.positiveSuffix.length() > this.negativeSuffix.length()) {
                bl3 = false;
            } else if (this.positiveSuffix.length() < this.negativeSuffix.length()) {
                bl2 = false;
            }
        }
        if (bl2 == bl3) {
            return false;
        }
        parsePosition.setIndex(n + (bl2 ? this.positiveSuffix.length() : this.negativeSuffix.length()));
        blArray[1] = bl2;
        return parsePosition.getIndex() != n2;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return (DecimalFormatSymbols)this.symbols.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        try {
            this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Bad multiplier: " + n);
        }
        this.multiplier = n;
    }

    public BigDecimal getRoundingIncrement() {
        return this.roundingIncrement;
    }

    public void setRoundingIncrement(BigDecimal bigDecimal) {
        int n;
        int n2 = n = bigDecimal == null ? 0 : bigDecimal.compareTo(BigDecimal.valueOf(0L));
        if (n < 0) {
            throw new IllegalArgumentException("Illegal rounding increment");
        }
        if (n == 0) {
            this.roundingIncrement = null;
            this.roundingDouble = 0.0;
        } else {
            this.roundingIncrement = bigDecimal;
            this.roundingDouble = bigDecimal.doubleValue();
        }
    }

    public void setRoundingIncrement(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Illegal rounding increment");
        }
        this.roundingDouble = d;
        this.roundingIncrement = d > 0.0 ? new BigDecimal(String.valueOf(d)) : null;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int n) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("Invalid rounding mode: " + n);
        }
        this.roundingMode = n;
    }

    public int getFormatWidth() {
        return this.formatWidth;
    }

    public void setFormatWidth(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal format width");
        }
        this.formatWidth = n;
    }

    public char getPadCharacter() {
        return this.pad;
    }

    public void setPadCharacter(char c) {
        this.pad = c;
    }

    public int getPadPosition() {
        return this.padPosition;
    }

    public void setPadPosition(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Illegal pad position");
        }
        this.padPosition = n;
    }

    public boolean isScientificNotation() {
        return this.useExponentialNotation;
    }

    public void setScientificNotation(boolean bl) {
        this.useExponentialNotation = bl;
        if (this.useExponentialNotation && this.minExponentDigits < 1) {
            this.minExponentDigits = 1;
        }
    }

    public byte getMinimumExponentDigits() {
        return this.minExponentDigits;
    }

    public void setMinimumExponentDigits(byte by) {
        if (by < 1) {
            throw new IllegalArgumentException("Exponent digits must be >= 1");
        }
        this.minExponentDigits = by;
    }

    public boolean isExponentSignAlwaysShown() {
        return this.exponentSignAlwaysShown;
    }

    public void setExponentSignAlwaysShown(boolean bl) {
        this.exponentSignAlwaysShown = bl;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int n) {
        this.groupingSize = (byte)n;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorAlwaysShown = bl;
    }

    @Override
    public Object clone() {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)super.clone();
            decimalFormat.symbols = (DecimalFormatSymbols)this.symbols.clone();
            return decimalFormat;
        }
        catch (Exception exception) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        return this.positivePrefix.equals(decimalFormat.positivePrefix) && this.positiveSuffix.equals(decimalFormat.positiveSuffix) && this.negativePrefix.equals(decimalFormat.negativePrefix) && this.negativeSuffix.equals(decimalFormat.negativeSuffix) && this.multiplier == decimalFormat.multiplier && this.groupingSize == decimalFormat.groupingSize && this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.useExponentialNotation == decimalFormat.useExponentialNotation && (!this.useExponentialNotation || this.minExponentDigits == decimalFormat.minExponentDigits) && this.symbols.equals(decimalFormat.symbols);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 37 + this.positivePrefix.hashCode();
    }

    public String toPattern() {
        return this.toPattern(false);
    }

    public String toLocalizedPattern() {
        return this.toPattern(true);
    }

    private void appendAffix(StringBuffer stringBuffer, String string, boolean bl) {
        boolean bl2;
        if (bl) {
            bl2 = string.indexOf(this.symbols.getZeroDigit()) >= 0 || string.indexOf(this.symbols.getGroupingSeparator()) >= 0 || string.indexOf(this.symbols.getDecimalSeparator()) >= 0 || string.indexOf(this.symbols.getPercent()) >= 0 || string.indexOf(this.symbols.getPerMill()) >= 0 || string.indexOf(this.symbols.getDigit()) >= 0 || string.indexOf(this.symbols.getPatternSeparator()) >= 0 || string.indexOf(this.symbols.getExponentSeparator()) >= 0;
        } else {
            boolean bl3 = bl2 = string.indexOf(48) >= 0 || string.indexOf(44) >= 0 || string.indexOf(46) >= 0 || string.indexOf(37) >= 0 || string.indexOf(8240) >= 0 || string.indexOf(35) >= 0 || string.indexOf(59) >= 0 || string.indexOf(PATTERN_EXPONENT) >= 0;
        }
        if (bl2) {
            stringBuffer.append('\'');
        }
        if (string.indexOf(39) < 0) {
            stringBuffer.append(string);
        } else {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                stringBuffer.append(c);
                if (c != '\'') continue;
                stringBuffer.append(c);
            }
        }
        if (bl2) {
            stringBuffer.append('\'');
        }
    }

    private String toPattern(boolean bl) {
        int n;
        String string;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        char c = bl ? (char)this.symbols.getZeroDigit() : (char)'0';
        char c2 = bl ? (char)this.symbols.getDigit() : (char)'#';
        char c3 = bl ? (char)this.symbols.getGroupingSeparator() : (char)',';
        int n3 = 0;
        String string2 = null;
        int n4 = n2 = this.formatWidth > 0 ? this.padPosition : -1;
        String string3 = this.formatWidth > 0 ? new StringBuffer(2).append(bl ? this.symbols.getPadEscape() : (char)'*').append(this.pad).toString() : (string = null);
        if (this.roundingIncrement != null) {
            n = this.roundingIncrement.scale();
            string2 = this.roundingIncrement.movePointRight(n).toString();
            n3 = string2.length() - n;
        }
        for (int i = 0; i < 2; ++i) {
            int n5;
            int n6;
            int n7 = stringBuffer.length();
            if (n2 == 0) {
                stringBuffer.append(string);
            }
            this.appendAffix(stringBuffer, i == 0 ? this.positivePrefix : this.negativePrefix, bl);
            if (n2 == 1) {
                stringBuffer.append(string);
            }
            int n8 = stringBuffer.length();
            for (n = n6 = this.useExponentialNotation ? this.getMaximumIntegerDigits() : Math.max(Math.max(this.groupingSize, this.getMinimumIntegerDigits()), n3) + 1; n > 0; --n) {
                if (this.isGroupingUsed() && this.groupingSize != 0 && n % this.groupingSize == 0 && n < n6 && !this.useExponentialNotation) {
                    stringBuffer.append(c3);
                }
                if (string2 != null && (n5 = n3 - n) >= 0 && n5 < string2.length()) {
                    stringBuffer.append((char)(string2.charAt(n5) - 48 + c));
                    continue;
                }
                stringBuffer.append(n <= this.getMinimumIntegerDigits() ? c : c2);
            }
            if (this.getMaximumFractionDigits() > 0 || this.decimalSeparatorAlwaysShown) {
                stringBuffer.append(bl ? this.symbols.getDecimalSeparator() : (char)'.');
            }
            n5 = n3;
            for (n = 0; n < this.getMaximumFractionDigits(); ++n) {
                if (string2 != null && n5 < string2.length()) {
                    stringBuffer.append(n5 < 0 ? c : (char)(string2.charAt(n5) - 48 + c));
                    ++n5;
                    continue;
                }
                stringBuffer.append(n < this.getMinimumFractionDigits() ? c : c2);
            }
            if (this.useExponentialNotation) {
                stringBuffer.append(bl ? this.symbols.getExponentSeparator() : PATTERN_EXPONENT);
                if (this.exponentSignAlwaysShown) {
                    stringBuffer.append(bl ? this.symbols.getPlusSign() : (char)'+');
                }
                for (n = 0; n < this.minExponentDigits; ++n) {
                    stringBuffer.append(c);
                }
            }
            if (string != null && !this.useExponentialNotation) {
                int n9 = this.formatWidth - stringBuffer.length() + n8 - (i == 0 ? this.positivePrefix.length() + this.positiveSuffix.length() : this.negativePrefix.length() + this.negativeSuffix.length());
                while (n9 > 0) {
                    stringBuffer.insert(n8, c2);
                    if (!this.isGroupingUsed() || this.groupingSize == 0 || ++n6 % this.groupingSize != 0 || --n9 <= 1) continue;
                    stringBuffer.insert(n8, c3);
                    --n9;
                }
            }
            if (n2 == 2) {
                stringBuffer.append(string);
            }
            if (i == 0) {
                this.appendAffix(stringBuffer, this.positiveSuffix, bl);
                if (n2 == 3) {
                    stringBuffer.append(string);
                }
                if (this.negativeSuffix.equals(this.positiveSuffix) && this.negativePrefix.equals(this.symbols.getMinusSign() + this.positivePrefix)) {
                    i = 2;
                    continue;
                }
                stringBuffer.append(bl ? this.symbols.getPatternSeparator() : (char)';');
                continue;
            }
            this.appendAffix(stringBuffer, this.negativeSuffix, bl);
            if (n2 != 3) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void applyPattern(String string) {
        this.applyPattern(string, false);
    }

    public void applyLocalizedPattern(String string) {
        this.applyPattern(string, true);
    }

    /*
     * Unable to fully structure code
     */
    private void applyPattern(String var1_1, boolean var2_2) {
        var3_3 = 48;
        var4_4 = 44;
        var5_5 = 46;
        var6_6 = 37;
        var7_7 = 8240;
        var8_8 = 35;
        var9_9 = 59;
        var10_10 = "E";
        var11_11 = '+';
        var12_12 = 42;
        if (var2_2) {
            var3_3 = this.symbols.getZeroDigit();
            var4_4 = this.symbols.getGroupingSeparator();
            var5_5 = this.symbols.getDecimalSeparator();
            var6_6 = this.symbols.getPercent();
            var7_7 = this.symbols.getPerMill();
            var8_8 = this.symbols.getDigit();
            var9_9 = this.symbols.getPatternSeparator();
            var10_10 = this.symbols.getExponentSeparator();
            var11_11 = this.symbols.getPlusSign();
            var12_12 = this.symbols.getPadEscape();
        }
        var13_13 = var3_3 + 9;
        var14_14 = false;
        var15_15 = 0;
        for (var16_16 = 0; var16_16 < 2 && var15_15 < var1_1.length(); ++var16_16) {
            var17_17 = 1;
            var18_18 = 0;
            var19_19 = 0;
            var20_20 = 0;
            var21_21 = new StringBuffer();
            var22_22 = new StringBuffer();
            var23_23 = -1;
            var24_24 = 1;
            var25_25 = 0;
            var26_26 = 0;
            var27_27 = 0;
            var28_28 = -1;
            var29_29 = -1;
            var30_30 = '\u0000';
            var31_31 = -1;
            var32_32 = 0L;
            var34_33 = -1;
            var35_34 = false;
            var36_35 = false;
            var37_36 = var21_21;
            var38_37 = var15_15;
            block6: while (var15_15 < var1_1.length()) {
                var39_38 = var1_1.charAt(var15_15);
                switch (var17_17) {
                    case 0: {
                        if (var39_38 == var8_8) {
                            if (var26_26 > 0) {
                                ++var27_27;
                            } else {
                                ++var25_25;
                            }
                            if (var28_28 >= 0 && var23_23 < 0) {
                                var28_28 = (byte)(var28_28 + 1);
                            }
                        } else if (var39_38 >= var3_3 && var39_38 <= var13_13) {
                            if (var27_27 > 0) {
                                throw new IllegalArgumentException("Unexpected '0' in pattern \"" + var1_1 + "\"");
                            }
                            ++var26_26;
                            if (var28_28 >= 0 && var23_23 < 0) {
                                var28_28 = (byte)(var28_28 + 1);
                            }
                            if (var39_38 != var3_3) {
                                var40_39 = var25_25 + var26_26 + var27_27;
                                if (var31_31 >= 0) {
                                    while (var31_31 < var40_39) {
                                        var32_32 *= 10L;
                                        ++var31_31;
                                    }
                                } else {
                                    var31_31 = var40_39;
                                }
                                var32_32 += (long)(var39_38 - var3_3);
                            }
                        } else if (var39_38 == var4_4) {
                            if (var23_23 >= 0) {
                                throw new IllegalArgumentException("Grouping separator after decimal in pattern \"" + var1_1 + "\"");
                            }
                            var28_28 = 0;
                        } else if (var39_38 == var5_5) {
                            if (var23_23 >= 0) {
                                throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + var1_1 + "\"");
                            }
                            var23_23 = var25_25 + var26_26 + var27_27;
                        } else {
                            if (var1_1.regionMatches(var15_15, var10_10, 0, var10_10.length())) {
                                if (var34_33 >= 0) {
                                    throw new IllegalArgumentException("Multiple exponential symbols in pattern \"" + var1_1 + "\"");
                                }
                                if (var28_28 >= 0) {
                                    throw new IllegalArgumentException("Grouping separator in exponential pattern \"" + var1_1 + "\"");
                                }
                                if (var15_15 + 1 < var1_1.length() && var1_1.charAt(var15_15 + 1) == var11_11) {
                                    var35_34 = true;
                                    ++var15_15;
                                }
                                var34_33 = 0;
                                while (++var15_15 < var1_1.length() && var1_1.charAt(var15_15) == var3_3) {
                                    var34_33 = (byte)(var34_33 + 1);
                                }
                                if (var25_25 + var26_26 < 1 || var34_33 < 1) {
                                    throw new IllegalArgumentException("Malformed exponential pattern \"" + var1_1 + "\"");
                                }
                            }
                            var17_17 = 2;
                            var37_36 = var22_22;
                            var19_19 = var15_15--;
                        }
                        ** GOTO lbl158
                    }
                    case 1: 
                    case 2: {
                        if (var39_38 != var8_8 && var39_38 != var4_4 && var39_38 != var5_5 && (var39_38 < var3_3 || var39_38 > var13_13)) ** GOTO lbl110
                        if (var17_17 != 1) ** GOTO lbl-1000
                        var17_17 = 0;
                        var18_18 = var15_15--;
                        ** GOTO lbl158
lbl110:
                        // 1 sources

                        if (var39_38 != 164) ** GOTO lbl118
                        var40_39 = var15_15 + 1 < var1_1.length() && var1_1.charAt(var15_15 + 1) == '\u00a4' ? 1 : 0;
                        var37_36.append(var40_39 != 0 ? this.symbols.getInternationalCurrencySymbol() : this.symbols.getCurrencySymbol());
                        if (var40_39 != 0) {
                            ++var15_15;
                        }
                        var36_35 = true;
                        ** GOTO lbl158
lbl118:
                        // 1 sources

                        if (var39_38 != 39) ** GOTO lbl124
                        if (var15_15 + 1 >= var1_1.length() || var1_1.charAt(var15_15 + 1) != '\'') ** GOTO lbl122
                        ++var15_15;
                        ** GOTO lbl-1000
lbl122:
                        // 1 sources

                        var17_17 += 2;
                        ** GOTO lbl158
lbl124:
                        // 1 sources

                        if (var39_38 == var9_9) {
                            if (var17_17 == 1 || var16_16 == 1) {
                                throw new IllegalArgumentException("Unquoted special character '" + (char)var39_38 + "' in pattern \"" + var1_1 + "\"");
                            }
                            var20_20 = var15_15++;
                            break block6;
                        }
                        if (var39_38 != var6_6 && var39_38 != var7_7) ** GOTO lbl139
                        if (var24_24 != 1) {
                            throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + var1_1 + "\"");
                        }
                        if (var39_38 == var6_6) {
                            var24_24 = 100;
                            var39_38 = this.symbols.getPercent();
                        } else {
                            var24_24 = 1000;
                            var39_38 = this.symbols.getPerMill();
                        }
                        ** GOTO lbl-1000
lbl139:
                        // 1 sources

                        if (var39_38 == var12_12) {
                            if (var29_29 >= 0) {
                                throw new IllegalArgumentException("Multiple pad specifiers");
                            }
                            if (var15_15 + 1 == var1_1.length()) {
                                throw new IllegalArgumentException("Invalid pad specifier");
                            }
                            var29_29 = var15_15++;
                            var30_30 = var1_1.charAt(var15_15);
                        } else lbl-1000:
                        // 5 sources

                        {
                            var37_36.append((char)var39_38);
                        }
                        ** GOTO lbl158
                    }
                    case 3: 
                    case 4: {
                        if (var39_38 != 39) ** GOTO lbl156
                        if (var15_15 + 1 >= var1_1.length() || var1_1.charAt(var15_15 + 1) != '\'') {
                            var17_17 -= 2;
                        } else {
                            ++var15_15;
lbl156:
                            // 2 sources

                            var37_36.append((char)var39_38);
                        }
                    }
lbl158:
                    // 13 sources

                    default: {
                        ++var15_15;
                        continue block6;
                    }
                }
            }
            if (var19_19 == 0) {
                var19_19 = var1_1.length();
            }
            if (var20_20 == 0) {
                var20_20 = var1_1.length();
            }
            if (var26_26 == 0 && var25_25 > 0 && var23_23 >= 0) {
                var39_38 = var23_23;
                if (var39_38 == 0) {
                    ++var39_38;
                }
                var27_27 = var25_25 - var39_38;
                var25_25 = var39_38 - 1;
                var26_26 = 1;
            }
            if (var23_23 < 0 && var27_27 > 0 || var23_23 >= 0 && (var23_23 < var25_25 || var23_23 > var25_25 + var26_26) || var28_28 == 0 || var17_17 > 2) {
                throw new IllegalArgumentException("Malformed pattern \"" + var1_1 + "\"");
            }
            if (var29_29 >= 0) {
                if (var29_29 == var38_37) {
                    var29_29 = 0;
                } else if (var29_29 + 2 == var18_18) {
                    var29_29 = 1;
                } else if (var29_29 == var19_19) {
                    var29_29 = 2;
                } else if (var29_29 + 2 == var20_20) {
                    var29_29 = 3;
                } else {
                    throw new IllegalArgumentException("Illegal pad position");
                }
            }
            if (var16_16 == 0) {
                this.positivePrefix = this.negativePrefix = var21_21.toString();
                this.positiveSuffix = this.negativeSuffix = var22_22.toString();
                v0 = this.useExponentialNotation = var34_33 >= 0;
                if (this.useExponentialNotation) {
                    this.minExponentDigits = (byte)var34_33;
                    this.exponentSignAlwaysShown = var35_34;
                }
                this.isCurrencyFormat = var36_35;
                var39_38 = var25_25 + var26_26 + var27_27;
                var40_39 = var23_23 >= 0 ? var23_23 : var39_38;
                this.setMinimumIntegerDigits(var40_39 - var25_25);
                this.setMaximumIntegerDigits(this.useExponentialNotation != false ? var25_25 + this.getMinimumIntegerDigits() : 0x7FFFFFFF);
                this.setMaximumFractionDigits(var23_23 >= 0 ? var39_38 - var23_23 : 0);
                this.setMinimumFractionDigits(var23_23 >= 0 ? var25_25 + var26_26 - var23_23 : 0);
                this.setGroupingUsed(var28_28 > 0);
                this.groupingSize = (byte)(var28_28 > 0 ? var28_28 : 0);
                this.multiplier = var24_24;
                this.setDecimalSeparatorAlwaysShown(var23_23 == 0 || var23_23 == var39_38);
                if (var29_29 >= 0) {
                    this.padPosition = var29_29;
                    this.formatWidth = var21_21.length() + var22_22.length() + var19_19 - var18_18;
                    this.pad = var30_30;
                } else {
                    this.formatWidth = 0;
                }
                if (var32_32 != 0L) {
                    var41_40 = var31_31 - var40_39;
                    this.roundingIncrement = BigDecimal.valueOf(var32_32, var41_40 > 0 ? var41_40 : 0);
                    if (var41_40 < 0) {
                        this.roundingIncrement = this.roundingIncrement.movePointRight(-var41_40);
                    }
                    this.roundingDouble = this.roundingIncrement.doubleValue();
                    this.roundingMode = 6;
                    continue;
                }
                this.setRoundingIncrement(null);
                continue;
            }
            this.negativePrefix = var21_21.toString();
            this.negativeSuffix = var22_22.toString();
            var14_14 = true;
        }
        if (!var14_14 || this.negativePrefix.equals(this.positivePrefix) && this.negativeSuffix.equals(this.positiveSuffix)) {
            this.negativeSuffix = this.positiveSuffix;
            this.negativePrefix = this.symbols.getMinusSign() + this.positivePrefix;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 2) {
            this.exponentSignAlwaysShown = false;
            this.roundingDouble = 0.0;
            this.roundingIncrement = null;
            this.roundingMode = 6;
            this.formatWidth = 0;
            this.pad = (char)32;
            this.padPosition = 0;
            if (this.serialVersionOnStream < 1) {
                this.useExponentialNotation = false;
            }
        }
        this.serialVersionOnStream = 2;
        this.digitList = new DigitList();
    }
}

