/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.text;

import java.math.BigDecimal;
import java.math.BigInteger;

final class DigitList
implements Cloneable {
    public static final int MAX_LONG_DIGITS = 19;
    public static final int DBL_DIG = 17;
    public int decimalAt = 0;
    public int count = 0;
    public byte[] digits = new byte[19];
    private static byte[] LONG_MIN_REP;
    private static final double LOG10;

    DigitList() {
    }

    private void ensureCapacity(int n, int n2) {
        if (n > this.digits.length) {
            byte[] byArray = new byte[n * 2];
            System.arraycopy(this.digits, 0, byArray, 0, n2);
            this.digits = byArray;
        }
    }

    boolean isZero() {
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == 48) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    public void append(int n) {
        this.ensureCapacity(this.count + 1, this.count);
        this.digits[this.count++] = (byte)n;
    }

    public final double getDouble() {
        if (this.count == 0) {
            return 0.0;
        }
        StringBuffer stringBuffer = new StringBuffer(this.count);
        stringBuffer.append('.');
        for (int i = 0; i < this.count; ++i) {
            stringBuffer.append((char)this.digits[i]);
        }
        stringBuffer.append('E');
        stringBuffer.append(Integer.toString(this.decimalAt));
        return Double.valueOf(stringBuffer.toString());
    }

    public final long getLong() {
        if (this.count == 0) {
            return 0L;
        }
        if (this.isLongMIN_VALUE()) {
            return Long.MIN_VALUE;
        }
        StringBuffer stringBuffer = new StringBuffer(this.count);
        for (int i = 0; i < this.decimalAt; ++i) {
            stringBuffer.append(i < this.count ? (char)this.digits[i] : (char)'0');
        }
        return Long.parseLong(stringBuffer.toString());
    }

    public BigInteger getBigInteger(boolean bl) {
        int n;
        if (this.isZero()) {
            return BigInteger.valueOf(0L);
        }
        StringBuffer stringBuffer = new StringBuffer(this.count);
        if (!bl) {
            stringBuffer.append('-');
        }
        for (n = 0; n < this.count; ++n) {
            stringBuffer.append((char)this.digits[n]);
        }
        n = this.decimalAt;
        while (n-- > this.count) {
            stringBuffer.append('0');
        }
        return new BigInteger(stringBuffer.toString());
    }

    public BigDecimal getBigDecimal(boolean bl) {
        int n;
        if (this.isZero()) {
            return BigDecimal.valueOf(0L);
        }
        StringBuffer stringBuffer = new StringBuffer(this.count + 1);
        if (!bl) {
            stringBuffer.append('-');
        }
        if ((n = this.decimalAt) < 0) {
            stringBuffer.append('.');
            while (n < 0) {
                stringBuffer.append('0');
                ++n;
            }
            n = -1;
        }
        for (int i = 0; i < this.count; ++i) {
            if (n == i) {
                stringBuffer.append('.');
            }
            stringBuffer.append((char)this.digits[i]);
        }
        while (n-- > this.count) {
            stringBuffer.append('0');
        }
        return new BigDecimal(stringBuffer.toString());
    }

    boolean isIntegral() {
        while (this.count > 0 && this.digits[this.count - 1] == 48) {
            --this.count;
        }
        return this.count == 0 || this.decimalAt >= this.count;
    }

    boolean fitsIntoLong(boolean bl) {
        while (this.count > 0 && this.digits[this.count - 1] == 48) {
            --this.count;
        }
        if (this.count == 0) {
            return bl;
        }
        if (this.decimalAt < this.count || this.decimalAt > 19) {
            return false;
        }
        if (this.decimalAt < 19) {
            return true;
        }
        for (int i = 0; i < this.count; ++i) {
            byte by = this.digits[i];
            byte by2 = LONG_MIN_REP[i];
            if (by > by2) {
                return false;
            }
            if (by >= by2) continue;
            return true;
        }
        if (this.count < this.decimalAt) {
            return true;
        }
        return !bl;
    }

    public final void set(double d, int n) {
        this.set(d, n, true);
    }

    final void set(double d, int n, boolean bl) {
        if (d == 0.0) {
            d = 0.0;
        }
        String string = Double.toString(d);
        this.decimalAt = -1;
        this.count = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                this.decimalAt = this.count;
                continue;
            }
            if (c == 'e' || c == 'E') {
                n2 = Integer.valueOf(string.substring(i + 1));
                break;
            }
            if (this.count >= 19) continue;
            if (!bl2) {
                boolean bl3 = bl2 = c != '0';
                if (!bl2 && this.decimalAt != -1) {
                    ++n3;
                }
            }
            if (!bl2) continue;
            this.digits[this.count++] = (byte)c;
        }
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        this.decimalAt += n2 - n3;
        if (bl) {
            if (-this.decimalAt > n) {
                this.count = 0;
                return;
            }
            if (-this.decimalAt == n) {
                if (this.shouldRoundUp(0)) {
                    this.count = 1;
                    ++this.decimalAt;
                    this.digits[0] = 49;
                } else {
                    this.count = 0;
                }
                return;
            }
        }
        while (this.count > 1 && this.digits[this.count - 1] == 48) {
            --this.count;
        }
        this.round(bl ? n + this.decimalAt : n);
    }

    private boolean shouldRoundUp(int n) {
        boolean bl = false;
        if (this.digits[n] > 53) {
            return true;
        }
        if (this.digits[n] == 53) {
            for (int i = n + 1; i < this.count; ++i) {
                if (this.digits[i] == 48) continue;
                return true;
            }
            return n == 0 || this.digits[n - 1] % 2 != 0;
        }
        return false;
    }

    public final void round(int n) {
        if (n > 0 && n < this.count) {
            if (this.shouldRoundUp(n)) {
                do {
                    if (--n < 0) {
                        this.digits[0] = 49;
                        ++this.decimalAt;
                        n = 0;
                        break;
                    }
                    int n2 = n;
                    this.digits[n2] = (byte)(this.digits[n2] + 1);
                } while (this.digits[n] > 57);
                ++n;
            }
            this.count = n;
        }
    }

    public final void set(long l) {
        this.set(l, 0);
    }

    public final void set(long l, int n) {
        if (l <= 0L) {
            if (l == Long.MIN_VALUE) {
                this.count = 19;
                this.decimalAt = 19;
                System.arraycopy(LONG_MIN_REP, 0, this.digits, 0, this.count);
            } else {
                this.count = 0;
                this.decimalAt = 0;
            }
        } else {
            int n2 = 19;
            while (l > 0L) {
                this.digits[--n2] = (byte)(48L + l % 10L);
                l /= 10L;
            }
            this.decimalAt = 19 - n2;
            int n3 = 18;
            while (this.digits[n3] == 48) {
                --n3;
            }
            this.count = n3 - n2 + 1;
            System.arraycopy(this.digits, n2, this.digits, 0, this.count);
        }
        if (n > 0) {
            this.round(n);
        }
    }

    public final void set(BigInteger bigInteger, int n) {
        String string = bigInteger.toString();
        this.count = this.decimalAt = string.length();
        while (this.count > 1 && string.charAt(this.count - 1) == '0') {
            --this.count;
        }
        int n2 = 0;
        if (string.charAt(0) == '-') {
            ++n2;
            --this.count;
            --this.decimalAt;
        }
        this.ensureCapacity(this.count, 0);
        for (int i = 0; i < this.count; ++i) {
            this.digits[i] = (byte)string.charAt(i + n2);
        }
        if (n > 0) {
            this.round(n);
        }
    }

    private void setBigDecimalDigits(String string, int n, boolean bl) {
        int n2;
        int n3 = -1;
        int n4 = string.length() - 1;
        int n5 = -1;
        for (n2 = 0; (n3 < 0 || n5 < 0) && n2 <= n4; ++n2) {
            char c = string.charAt(n2);
            if (c == '.') {
                n5 = n2;
                continue;
            }
            if (n3 >= 0 || c < '1' || c > '9') continue;
            n3 = n2;
        }
        if (n3 < 0) {
            this.clear();
            return;
        }
        while ((n2 = (int)string.charAt(n4)) == 48 || n2 == 46) {
            --n4;
        }
        if (n5 < 0) {
            n5 = string.length();
        }
        this.count = n4 - n3;
        if (n5 < n3 || n5 > n4) {
            ++this.count;
        }
        this.decimalAt = n5 - n3;
        if (this.decimalAt < 0) {
            ++this.decimalAt;
        }
        this.ensureCapacity(this.count, 0);
        for (n2 = 0; n2 < this.count; ++n2) {
            this.digits[n2] = (byte)string.charAt(n3++);
            if (n3 != n5) continue;
            ++n3;
        }
        this.round(bl ? n + this.decimalAt : n);
    }

    public final void set(BigDecimal bigDecimal, int n, boolean bl) {
        this.setBigDecimalDigits(bigDecimal.toString(), n, bl);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitList)) {
            return false;
        }
        DigitList digitList = (DigitList)object;
        if (this.count != digitList.count || this.decimalAt != digitList.decimalAt) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == digitList.digits[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.decimalAt;
        for (int i = 0; i < this.count; ++i) {
            n = n * 37 + this.digits[i];
        }
        return n;
    }

    private boolean isLongMIN_VALUE() {
        if (this.decimalAt != this.count || this.count != 19) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == LONG_MIN_REP[i]) continue;
            return false;
        }
        return true;
    }

    private static final int log10(double d) {
        double d2 = Math.log(d) / LOG10;
        int n = (int)Math.floor(d2);
        if (d2 > 0.0 && d >= Math.pow(10.0, n + 1)) {
            ++n;
        } else if (d2 < 0.0 && d < Math.pow(10.0, n)) {
            --n;
        }
        return n;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer("0.");
        for (int i = 0; i < this.count; ++i) {
            stringBuffer.append((char)this.digits[i]);
        }
        stringBuffer.append("x10^");
        stringBuffer.append(this.decimalAt);
        return stringBuffer.toString();
    }

    static {
        String string = Long.toString(Long.MIN_VALUE);
        LONG_MIN_REP = new byte[19];
        for (int i = 0; i < 19; ++i) {
            DigitList.LONG_MIN_REP[i] = (byte)string.charAt(i + 1);
        }
        LOG10 = Math.log(10.0);
    }
}

