/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.text;

public class Pattern {
    public static final char SPACE = ' ';
    public static final char ALL = '*';
    public static final char NUMBER = '0';
    public static final char LETTER = 'A';
    public static final char PUNCT = '.';
    public static final char KOMMA = ',';
    public static final char NUMBER_OR_SPACE = '~';
    public static final char NUMBER_OR_PUNCT = ':';
    public static final char NUMBER_OR_KOMMA = ';';
    public static final char DIGIT = '#';
    public static final char MATH = '+';
    public static final int LENGTH_XOR = 0;
    public static final int LENGTH_OR = 1;
    public static final int LENGTH_AND = 2;
    public static final int LENGTH_MIN = 3;
    public static final int LENGTH_MAX = 4;
    private String pattern = "";
    private int length = 0;

    public Pattern() {
    }

    public Pattern(String string) {
        this(string, 0);
    }

    public Pattern(String string, int n) {
        this.pattern = string;
        this.length = n;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public boolean contains(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = this.pattern.length();
        int n2 = string.length();
        switch (this.length) {
            case 0: {
                break;
            }
            case 1: {
                if (n != n2) break;
                return false;
            }
            case 2: {
                if (n == n2) break;
                return false;
            }
            case 3: {
                if (n <= n2) break;
                return false;
            }
            case 4: {
                if (n >= n2) break;
                return false;
            }
        }
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (this.contains(this.pattern.charAt(i), string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean contains(char c, char c2) {
        switch (c) {
            case ' ': {
                return c2 == ' ';
            }
            case '*': {
                return true;
            }
            case '0': {
                return Character.isDigit(c2);
            }
            case '~': {
                return Character.isDigit(c2) || c2 == ' ';
            }
            case ':': {
                return Character.isDigit(c2) || c2 == '.';
            }
            case ';': {
                return Character.isDigit(c2) || c2 == ',';
            }
            case '#': {
                return Character.isDigit(c2) || c2 == ' ' || c2 == '.' || c2 == '-' || c2 == '+';
            }
            case 'A': {
                return Character.isLetter(c2);
            }
            case '.': {
                return c2 == '.';
            }
            case ',': {
                return c2 == ',';
            }
            case '+': {
                return c2 == '+' || c2 == '-' || c2 == '*' || c2 == '/';
            }
        }
        return false;
    }
}

