/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.util.Filter;
import java.util.Enumeration;
import java.util.Hashtable;

public class CharacterFilter
extends Filter {
    private Hashtable possibleChars = new Hashtable();
    private Hashtable contentChars = new Hashtable();

    public CharacterFilter() {
        this("", true);
    }

    public CharacterFilter(String string) {
        this(string, true);
    }

    public CharacterFilter(String string, boolean bl) {
        super(bl);
        this.setBounds(this.possibleChars, string);
        this.setBounds(this.contentChars, string);
    }

    public void setBounds(String string) throws Exception {
        this.contentChars.clear();
        for (int i = 0; i < string.length(); ++i) {
            Character c = new Character(string.charAt(i));
            if (this.possibleChars.get(c) == null) {
                throw new Exception("Ung\u00fcltiges Zeichen '" + c.charValue() + "'");
            }
            this.contentChars.put(c, c);
        }
    }

    private void setBounds(Hashtable hashtable, String string) {
        for (int i = 0; i < string.length(); ++i) {
            Character c = new Character(string.charAt(i));
            hashtable.put(c, c);
        }
    }

    public String getBounds() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.contentChars.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(((Character)enumeration.nextElement()).toString());
        }
        return stringBuffer.toString();
    }

    public boolean isValidValue(char c) {
        if (this.isEnabled()) {
            return this.contentChars.get(new Character(c)) != null;
        }
        return true;
    }

    @Override
    public boolean isValidValue(Object object) {
        if (object instanceof Character) {
            return this.contentChars.get(object) != null;
        }
        return false;
    }
}

