/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.util.ClearListEntry;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ClearList {
    protected transient ClearListEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public ClearList(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new ClearListEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public ClearList(int n) {
        this(n, 2.5f);
    }

    public ClearList(float f) {
        this(101, f);
    }

    public ClearList() {
        this(101, 2.5f);
    }

    public int size() {
        return this.count;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    public final boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = (object.hashCode() & Integer.MAX_VALUE) % this.table.length;
        ClearListEntry clearListEntry = this.table[n];
        while (clearListEntry != null) {
            if (clearListEntry.value.equals(object)) {
                return true;
            }
            clearListEntry = clearListEntry.next;
        }
        return false;
    }

    public final Object get(Object object) {
        int n = (object.hashCode() & Integer.MAX_VALUE) % this.table.length;
        ClearListEntry clearListEntry = this.table[n];
        while (clearListEntry != null) {
            if (clearListEntry.value.equals(object)) {
                return clearListEntry.value;
            }
            clearListEntry = clearListEntry.next;
        }
        return null;
    }

    private void rehash() {
        int n = this.table.length;
        ClearListEntry[] clearListEntryArray = this.table;
        int n2 = n * 2 + 1;
        ClearListEntry[] clearListEntryArray2 = new ClearListEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = clearListEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            ClearListEntry clearListEntry = clearListEntryArray[n3];
            while (clearListEntry != null) {
                ClearListEntry clearListEntry2 = clearListEntry;
                clearListEntry = clearListEntry.next;
                int n4 = (clearListEntry2.value.hashCode() & Integer.MAX_VALUE) % n2;
                clearListEntry2.next = clearListEntryArray2[n4];
                clearListEntryArray2[n4] = clearListEntry2;
            }
        }
    }

    public final Object put(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.table.length;
        ClearListEntry clearListEntry = this.table[n2];
        while (clearListEntry != null) {
            if (clearListEntry.value.equals(object)) {
                Object object2 = clearListEntry.value;
                clearListEntry.value = object;
                return object2;
            }
            clearListEntry = clearListEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            n2 = (n & Integer.MAX_VALUE) % this.table.length;
        }
        clearListEntry = new ClearListEntry();
        clearListEntry.value = object;
        clearListEntry.next = this.table[n2];
        this.table[n2] = clearListEntry;
        ++this.count;
        return null;
    }

    public final Object set(Object object) {
        Object object2 = this.put(object);
        return object2 != null ? object2 : object;
    }

    public final Object remove(Object object) {
        int n = (object.hashCode() & Integer.MAX_VALUE) % this.table.length;
        ClearListEntry clearListEntry = this.table[n];
        ClearListEntry clearListEntry2 = null;
        while (clearListEntry != null) {
            if (clearListEntry.value.equals(object)) {
                if (clearListEntry2 != null) {
                    clearListEntry2.next = clearListEntry.next;
                } else {
                    this.table[n] = clearListEntry.next;
                }
                --this.count;
                return clearListEntry.value;
            }
            clearListEntry2 = clearListEntry;
            clearListEntry = clearListEntry.next;
        }
        return null;
    }

    public final void clear() {
        int n = this.table.length;
        while (--n >= 0) {
            this.table[n] = null;
        }
        this.count = 0;
    }

    public Enumeration elements() {
        return new ClearListEnumerator(this, this.table);
    }

    class ClearListEnumerator
    implements Enumeration {
        int index;
        ClearListEntry[] table;
        ClearListEntry entry;

        ClearListEnumerator(ClearList clearList, ClearListEntry[] clearListEntryArray) {
            this.table = clearListEntryArray;
            this.index = clearListEntryArray.length;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                ClearListEntry clearListEntry = this.entry;
                this.entry = clearListEntry.next;
                return clearListEntry.value;
            }
            throw new NoSuchElementException("ClearListEnumerator");
        }
    }
}

