/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.lang.ValueOutOfBoundsException;
import de.geocalc.util.NumberFilter;
import java.util.StringTokenizer;

public class DoubleFilter
extends NumberFilter {
    private double min_Value = Double.MIN_VALUE;
    private double max_Value = Double.MAX_VALUE;
    private double min = this.min_Value;
    private double max = this.max_Value;

    public DoubleFilter() {
        this(Double.MIN_VALUE, Double.MAX_VALUE, true);
    }

    public DoubleFilter(double d, double d2) {
        this(d, d2, true);
    }

    public DoubleFilter(double d, double d2, boolean bl) {
        super(bl);
        this.min_Value = d;
        this.max_Value = d2;
        try {
            this.setBounds(d, d2);
        }
        catch (ValueOutOfBoundsException valueOutOfBoundsException) {
            // empty catch block
        }
    }

    public void setMinValue(double d) {
        this.min_Value = d;
        this.min = Math.max(this.min, this.min_Value);
    }

    public void setMaxValue(double d) {
        this.max_Value = d;
        this.max = Math.min(this.max, this.max_Value);
    }

    public void setMinimum(double d) throws ValueOutOfBoundsException {
        if (!(d >= this.min_Value)) {
            this.min = this.min_Value;
            throw new ValueOutOfBoundsException("Wert au\u00dferhalb des g\u00fcltigen Bereichs: " + d + " < " + this.min_Value);
        }
        this.min = d;
    }

    @Override
    public void setMinimum(Number number) throws ValueOutOfBoundsException {
        this.setMinimum(number.doubleValue());
    }

    @Override
    public void setMinimum(String string) throws NumberFormatException, ValueOutOfBoundsException {
        try {
            this.setMinimum(new Double(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Ung\u00fcltige Zeichen im Eingabeformat: " + string);
        }
    }

    @Override
    public Number getMinimum() {
        return new Double(this.min);
    }

    public void setMaximum(double d) throws ValueOutOfBoundsException {
        if (!(d <= this.max_Value)) {
            this.max = this.max_Value;
            throw new ValueOutOfBoundsException("Wert au\u00dferhalb des g\u00fcltigen Bereichs: " + d + " > " + this.max_Value);
        }
        this.max = d;
    }

    @Override
    public void setMaximum(Number number) throws ValueOutOfBoundsException {
        this.setMaximum(number.doubleValue());
    }

    @Override
    public void setMaximum(String string) throws NumberFormatException, ValueOutOfBoundsException {
        try {
            this.setMaximum(new Double(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Ung\u00fcltige Zeichen im Eingabeformat: " + string);
        }
    }

    @Override
    public Number getMaximum() {
        return new Double(this.max);
    }

    public void setBounds(double d, double d2) throws ValueOutOfBoundsException {
        this.min = Math.max(this.min_Value, d);
        this.max = Math.min(this.max_Value, d2);
        if (d < this.min_Value || d2 > this.max_Value) {
            throw new ValueOutOfBoundsException("Wert au\u00dferhalb des g\u00fcltigen Bereichs");
        }
    }

    @Override
    public void setBounds(String string) throws ValueOutOfBoundsException, NumberFormatException {
        double d = this.min_Value;
        double d2 = this.max_Value;
        boolean bl = false;
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        String string2 = null;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if (bl2) continue;
            try {
                d = new Double(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        try {
            d2 = new Double(string2);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (string.startsWith("-")) {
            d = this.min_Value;
        } else if (string.endsWith("-")) {
            d2 = this.max_Value;
        }
        this.setBounds(d, d2);
        if (bl) {
            throw new NumberFormatException("Ung\u00fcltige Zeichen im Eingabeformat");
        }
    }

    public boolean isValidValue(double d) {
        if (this.isEnabled()) {
            return d >= this.min && d <= this.max;
        }
        return true;
    }

    @Override
    public boolean isValidValue(Object object) {
        if (object instanceof Double) {
            return this.isValidValue((Double)object);
        }
        return false;
    }
}

