/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.util.VoidEnumerator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class HashStack {
    protected Hashtable table = null;

    public HashStack() {
        this.table = new Hashtable(8);
    }

    public HashStack(int n) {
        this.table = new Hashtable(n);
    }

    public void clear() {
        this.table.clear();
    }

    public int size() {
        return this.table.size();
    }

    public void remove(Object object) {
        this.table.remove(object);
    }

    public Object put(Object object, Object object2) {
        HashStackEntry hashStackEntry = new HashStackEntry(this, object2);
        HashStackEntry hashStackEntry2 = this.table.put(object, hashStackEntry);
        if (hashStackEntry2 != null) {
            hashStackEntry.setNext(hashStackEntry2);
        }
        return hashStackEntry2;
    }

    public boolean hasKey(Object object) {
        return this.table.get(object) != null;
    }

    protected Object get(Object object) {
        return this.table.get(object);
    }

    public Enumeration keys() {
        return this.table.keys();
    }

    public Enumeration elements(Object object) {
        HashStackEntry hashStackEntry = (HashStackEntry)this.table.get(object);
        if (hashStackEntry == null) {
            return VoidEnumerator.instance();
        }
        return new HashStackEntryEnumerator(this, hashStackEntry);
    }

    public int countElements(Object object) {
        int n = 0;
        Enumeration enumeration = this.elements(object);
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        return n;
    }

    final class HashStackEntry {
        Object value = null;
        HashStackEntry next = null;

        HashStackEntry(HashStack hashStack, Object object) {
            this.value = object;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public void setNext(HashStackEntry hashStackEntry) {
            this.next = hashStackEntry;
        }

        public HashStackEntry getNext() {
            return this.next;
        }
    }

    final class HashStackEntryEnumerator
    implements Enumeration {
        HashStackEntry entry = null;

        HashStackEntryEnumerator(HashStack hashStack, HashStackEntry hashStackEntry) {
            this.entry = hashStackEntry;
        }

        @Override
        public boolean hasMoreElements() {
            return this.entry != null;
        }

        public Object nextElement() {
            if (this.entry == null) {
                throw new NoSuchElementException("HashStackEntryEnumerator");
            }
            Object object = this.entry.getValue();
            this.entry = this.entry.getNext();
            return object;
        }
    }
}

