/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.lang.ValueOutOfBoundsException;
import de.geocalc.util.NumberFilter;
import java.util.StringTokenizer;

public class IntegerFilter
extends NumberFilter {
    private int min_Value = Integer.MIN_VALUE;
    private int max_Value = Integer.MAX_VALUE;
    private int min = this.min_Value;
    private int max = this.max_Value;

    public IntegerFilter() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE, true);
    }

    public IntegerFilter(int n, int n2) {
        this(n, n2, true);
    }

    public IntegerFilter(int n, int n2, boolean bl) {
        super(bl);
        this.min_Value = n;
        this.max_Value = n2;
        try {
            this.setBounds(n, n2);
        }
        catch (ValueOutOfBoundsException valueOutOfBoundsException) {
            // empty catch block
        }
    }

    public void setMinValue(int n) {
        this.min_Value = n;
        this.min = Math.max(this.min, this.min_Value);
    }

    public void setMaxValue(int n) {
        this.max_Value = n;
        this.max = Math.min(this.max, this.max_Value);
    }

    public void setMinimum(int n) {
        this.min = n >= this.min_Value ? n : this.min_Value;
    }

    @Override
    public void setMinimum(Number number) {
        this.setMinimum(number.intValue());
    }

    @Override
    public void setMinimum(String string) throws NumberFormatException {
        try {
            this.setMinimum(new Integer(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Ung\u00fcltige Zeichen im Eingabeformat: " + string);
        }
    }

    @Override
    public Number getMinimum() {
        return new Integer(this.min);
    }

    public void setMaximum(int n) {
        this.max = n <= this.max_Value ? n : this.max_Value;
    }

    @Override
    public void setMaximum(Number number) {
        this.setMaximum(number.intValue());
    }

    @Override
    public void setMaximum(String string) throws NumberFormatException {
        try {
            this.setMaximum(new Integer(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Ung\u00fcltige Zeichen im Eingabeformat: " + string);
        }
    }

    @Override
    public Number getMaximum() {
        return new Integer(this.max);
    }

    public void setBounds(int n, int n2) throws ValueOutOfBoundsException {
        this.min = Math.max(this.min_Value, n);
        this.max = Math.min(this.max_Value, n2);
        if (n < this.min_Value || n2 > this.max_Value) {
            throw new ValueOutOfBoundsException("Wert au\u00dferhalb des g\u00fcltigen Bereichs");
        }
    }

    @Override
    public void setBounds(String string) throws ValueOutOfBoundsException, NumberFormatException {
        int n = this.min_Value;
        int n2 = this.max_Value;
        boolean bl = false;
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        String string2 = null;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if (bl2) continue;
            try {
                n = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        try {
            n2 = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (string.startsWith("-")) {
            n = this.min_Value;
        } else if (string.endsWith("-")) {
            n2 = this.max_Value;
        }
        this.setBounds(n, n2);
        if (bl) {
            throw new NumberFormatException("Ung\u00fcltige Zeichen im Eingabeformat");
        }
    }

    public boolean isValidValue(int n) {
        if (this.isEnabled()) {
            return n >= this.min && n <= this.max;
        }
        return true;
    }

    @Override
    public boolean isValidValue(Object object) {
        if (object instanceof Integer) {
            return this.isValidValue((Integer)object);
        }
        return false;
    }
}

