/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.util.IntegerHashObject;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IntegerHashList {
    public static final int SORT_UP = 0;
    public static final int SORT_DOWN = 1;
    private transient IntegerHashListEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public IntegerHashList(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new IntegerHashListEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public IntegerHashList(int n) {
        this(n, 2.5f);
    }

    public IntegerHashList(float f) {
        this(101, f);
    }

    public IntegerHashList() {
        this(101, 2.5f);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration elements() {
        return new IntegerHashListEnumerator();
    }

    public synchronized Enumeration sortedElements() {
        return this.sortedElements(0);
    }

    public synchronized Enumeration sortedElements(int n) {
        if (n == 1) {
            return new SortedDownIntegerHashListEnumerator();
        }
        return new SortedIntegerHashListEnumerator();
    }

    public synchronized boolean contains(IntegerHashObject integerHashObject) {
        if (integerHashObject == null) {
            throw new NullPointerException();
        }
        return this.containsKey(integerHashObject.intHashKey());
    }

    public synchronized boolean containsKey(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.table.length;
        IntegerHashListEntry integerHashListEntry = this.table[n2];
        while (integerHashListEntry != null) {
            if (integerHashListEntry.value.intHashKey() == n) {
                return true;
            }
            integerHashListEntry = integerHashListEntry.next;
        }
        return false;
    }

    public synchronized IntegerHashObject get(IntegerHashObject integerHashObject) {
        return this.get(integerHashObject.intHashKey());
    }

    public synchronized IntegerHashObject get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.table.length;
        IntegerHashListEntry integerHashListEntry = this.table[n2];
        while (integerHashListEntry != null) {
            if (integerHashListEntry.value.intHashKey() == n) {
                return integerHashListEntry.value;
            }
            integerHashListEntry = integerHashListEntry.next;
        }
        return null;
    }

    private void rehash() {
        int n = this.table.length;
        IntegerHashListEntry[] integerHashListEntryArray = this.table;
        int n2 = n * 2 + 1;
        IntegerHashListEntry[] integerHashListEntryArray2 = new IntegerHashListEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = integerHashListEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IntegerHashListEntry integerHashListEntry = integerHashListEntryArray[n3];
            while (integerHashListEntry != null) {
                IntegerHashListEntry integerHashListEntry2 = integerHashListEntry;
                integerHashListEntry = integerHashListEntry.next;
                int n4 = (integerHashListEntry2.value.intHashKey() & Integer.MAX_VALUE) % n2;
                integerHashListEntry2.next = integerHashListEntryArray2[n4];
                integerHashListEntryArray2[n4] = integerHashListEntry2;
            }
        }
    }

    public synchronized IntegerHashObject put(IntegerHashObject integerHashObject) {
        if (integerHashObject == null) {
            throw new NullPointerException();
        }
        int n = integerHashObject.intHashKey();
        int n2 = (n & Integer.MAX_VALUE) % this.table.length;
        IntegerHashListEntry integerHashListEntry = this.table[n2];
        while (integerHashListEntry != null) {
            if (integerHashListEntry.value.intHashKey() == n) {
                IntegerHashObject integerHashObject2 = integerHashListEntry.value;
                integerHashListEntry.value = integerHashObject;
                return integerHashObject2;
            }
            integerHashListEntry = integerHashListEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            n2 = (n & Integer.MAX_VALUE) % this.table.length;
        }
        integerHashListEntry = new IntegerHashListEntry();
        integerHashListEntry.value = integerHashObject;
        integerHashListEntry.next = this.table[n2];
        this.table[n2] = integerHashListEntry;
        ++this.count;
        return null;
    }

    public final IntegerHashObject remove(IntegerHashObject integerHashObject) {
        return this.remove(integerHashObject.intHashKey());
    }

    public synchronized IntegerHashObject remove(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.table.length;
        IntegerHashListEntry integerHashListEntry = this.table[n2];
        IntegerHashListEntry integerHashListEntry2 = null;
        while (integerHashListEntry != null) {
            if (integerHashListEntry.value.intHashKey() == n) {
                if (integerHashListEntry2 != null) {
                    integerHashListEntry2.next = integerHashListEntry.next;
                } else {
                    this.table[n2] = integerHashListEntry.next;
                }
                --this.count;
                return integerHashListEntry.value;
            }
            integerHashListEntry2 = integerHashListEntry;
            integerHashListEntry = integerHashListEntry.next;
        }
        return null;
    }

    public synchronized void clear() {
        int n = this.table.length;
        while (--n >= 0) {
            this.table[n] = null;
        }
        this.count = 0;
    }

    public void printDebug() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null) {
                ++n;
                n2 = 0;
                System.out.print("|");
                continue;
            }
            n = 0;
            ++n2;
            int n6 = 0;
            IntegerHashListEntry integerHashListEntry = this.table[i];
            while (integerHashListEntry != null) {
                integerHashListEntry = integerHashListEntry.next;
                ++n6;
            }
            System.out.print(n6);
            n3 += n6;
            n5 = Math.max(n5, n6);
            ++n4;
        }
        System.out.println("");
        System.out.println("belegt: " + this.table.length + " M:" + n4 + " max:" + n5 + " Belegung: " + (double)n3 / (double)n4);
    }

    private static class IntegerHashListEntry {
        IntegerHashObject value;
        IntegerHashListEntry next;

        private IntegerHashListEntry() {
        }
    }

    private class IntegerHashListEnumerator
    implements Enumeration {
        IntegerHashListEntry[] table;
        int index;
        IntegerHashListEntry entry;

        IntegerHashListEnumerator() {
            this.table = IntegerHashList.this.table;
            this.index = this.table.length;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                IntegerHashListEntry integerHashListEntry = this.entry;
                this.entry = integerHashListEntry.next;
                return integerHashListEntry.value;
            }
            throw new NoSuchElementException("HashListEnumerator");
        }
    }

    private class SortedDownIntegerHashListEnumerator
    implements Enumeration {
        int max = Integer.MIN_VALUE;
        int size = 0;
        IntegerHashListEntry[] table;
        IntegerHashObject next;

        SortedDownIntegerHashListEnumerator() {
            this.table = IntegerHashList.this.table;
            IntegerHashListEnumerator integerHashListEnumerator = new IntegerHashListEnumerator();
            while (integerHashListEnumerator.hasMoreElements()) {
                IntegerHashObject integerHashObject = (IntegerHashObject)integerHashListEnumerator.nextElement();
                int n = integerHashObject.intHashKey();
                if (n <= this.max) continue;
                this.max = n;
                this.next = integerHashObject;
            }
            this.size = this.table.length / 50;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            IntegerHashObject integerHashObject = this.next;
            this.next = null;
            int n = this.max - this.size;
            while (--this.max > n) {
                this.next = IntegerHashList.this.get(this.max);
                if (this.next == null) continue;
                return integerHashObject;
            }
            ++this.max;
            int n2 = Integer.MIN_VALUE;
            IntegerHashListEnumerator integerHashListEnumerator = new IntegerHashListEnumerator();
            while (integerHashListEnumerator.hasMoreElements()) {
                IntegerHashObject integerHashObject2 = (IntegerHashObject)integerHashListEnumerator.nextElement();
                int n3 = integerHashObject2.intHashKey();
                if (n3 >= this.max || n3 <= n2) continue;
                n2 = n3;
                this.next = integerHashObject2;
            }
            this.max = n2;
            return integerHashObject;
        }
    }

    private class SortedIntegerHashListEnumerator
    implements Enumeration {
        int min = Integer.MAX_VALUE;
        int size = 0;
        IntegerHashListEntry[] table;
        IntegerHashObject next;

        SortedIntegerHashListEnumerator() {
            this.table = IntegerHashList.this.table;
            IntegerHashListEnumerator integerHashListEnumerator = new IntegerHashListEnumerator();
            while (integerHashListEnumerator.hasMoreElements()) {
                IntegerHashObject integerHashObject = (IntegerHashObject)integerHashListEnumerator.nextElement();
                int n = integerHashObject.intHashKey();
                if (n >= this.min) continue;
                this.min = n;
                this.next = integerHashObject;
            }
            this.size = this.table.length / 50;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            IntegerHashObject integerHashObject = this.next;
            this.next = null;
            int n = this.min + this.size;
            while (++this.min < n) {
                this.next = IntegerHashList.this.get(this.min);
                if (this.next == null) continue;
                return integerHashObject;
            }
            --this.min;
            int n2 = Integer.MAX_VALUE;
            IntegerHashListEnumerator integerHashListEnumerator = new IntegerHashListEnumerator();
            while (integerHashListEnumerator.hasMoreElements()) {
                IntegerHashObject integerHashObject2 = (IntegerHashObject)integerHashListEnumerator.nextElement();
                int n3 = integerHashObject2.intHashKey();
                if (n3 <= this.min || n3 >= n2) continue;
                n2 = n3;
                this.next = integerHashObject2;
            }
            this.min = n2;
            return integerHashObject;
        }
    }
}

