/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.lang.ValueOutOfBoundsException;
import de.geocalc.util.IntegerFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class IntegerListFilter
extends IntegerFilter {
    private int[] keys = new int[0];
    private boolean[] vals = new boolean[0];
    private Hashtable<String, Integer> translator = null;

    public IntegerListFilter(int[] nArray, boolean bl) {
        this.setSwitchable(bl);
        this.keys = nArray;
        this.vals = new boolean[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.vals[i] = true;
        }
    }

    public void setTranslator(Hashtable<String, Integer> hashtable) {
        this.translator = hashtable;
    }

    @Override
    public void setBounds(String string) throws ValueOutOfBoundsException, NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",; ");
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.setValue(string2, true);
        }
    }

    public void setValue(String string, boolean bl) throws ValueOutOfBoundsException, NumberFormatException {
        int n = -1;
        if (this.translator != null) {
            Integer n2 = this.translator.get(string);
            if (n2 != null) {
                n = n2;
            }
        } else {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("Ung\u00fcltige Zeichen im Eingabeformat: " + string);
            }
        }
        int n3 = this.search(n);
        if (n3 < 0) {
            throw new ValueOutOfBoundsException("Wert au\u00dferhalb des g\u00fcltigen Bereichs: " + string);
        }
        this.vals[n3] = bl;
    }

    public String getBounds() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.vals[i]) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.getKeyString(this.keys[i]));
        }
        return stringBuffer.toString();
    }

    public String[] getBoundsArray(boolean bl) {
        int n = 0;
        if (bl) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!this.vals[i]) continue;
                ++n;
            }
        } else {
            n = this.keys.length;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < this.keys.length; ++i) {
            if (bl && !this.vals[i]) continue;
            stringArray[i] = this.getKeyString(this.keys[i]);
        }
        return stringArray;
    }

    private String getKeyString(int n) {
        if (this.translator != null) {
            Enumeration<String> enumeration = this.translator.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (this.translator.get(string) != n) continue;
                return string;
            }
        }
        return Integer.toString(n);
    }

    @Override
    public boolean isValidValue(int n) {
        if (this.isEnabled()) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] != n) continue;
                return this.vals[i];
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidValue(Object object) {
        if (object instanceof Integer) {
            return this.isValidValue((Integer)object);
        }
        return false;
    }

    private int search(int n) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] != n) continue;
            return i;
        }
        return -1;
    }
}

