/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.util.VoidEnumerator;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class KeyedHashtable
extends Dictionary
implements Cloneable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private static final long serialVersionUID = 1421746759512286392L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private volatile transient Set keySet = null;
    private volatile transient Set entrySet = null;
    private volatile transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public KeyedHashtable(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public KeyedHashtable(int n) {
        this(n, 0.75f);
    }

    public KeyedHashtable() {
        this(11, 0.75f);
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return this.getEnumeration(0);
    }

    public synchronized Enumeration elements() {
        return this.getEnumeration(1);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public synchronized boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public synchronized Object get(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public synchronized Object getKey(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return entry.key;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = (n << 1) + 1;
        if (n2 - 0x7FFFFFF7 > 0) {
            if (n == 0x7FFFFFF7) {
                return;
            }
            n2 = 0x7FFFFFF7;
        }
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                Object object3 = entry.value;
                entry.value = object2;
                return object3;
            }
            entry = entry.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entry = entryArray[n2];
        entryArray[n2] = new Entry(n, object, object2, entry);
        ++this.count;
        return null;
    }

    public synchronized Object remove(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                ++this.modCount;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                Object object2 = entry.value;
                entry.value = null;
                return object2;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            KeyedHashtable keyedHashtable = (KeyedHashtable)super.clone();
            keyedHashtable.table = new Entry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                keyedHashtable.table[n] = this.table[n] != null ? (Entry)this.table[n].clone() : null;
            }
            keyedHashtable.keySet = null;
            keyedHashtable.entrySet = null;
            keyedHashtable.values = null;
            keyedHashtable.modCount = 0;
            return keyedHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private Enumeration getEnumeration(int n) {
        if (this.count == 0) {
            return VoidEnumerator.instance();
        }
        return new Enumerator(n, false);
    }

    public synchronized int hashCode() {
        int n = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return n;
        }
        this.loadFactor = -this.loadFactor;
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                n += entry.key.hashCode() ^ entry.value.hashCode();
                entry = entry.next;
            }
        }
        this.loadFactor = -this.loadFactor;
        return n;
    }

    public String getHashInfos() {
        int n = 0;
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            if (entryArray[i] == null) continue;
            ++n;
        }
        return "KeyedHashtable[" + entryArray.length + "]: " + n * 100 / entryArray.length + "%";
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        protected Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }

    private class Enumerator
    implements Enumeration,
    Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        boolean iterator;
        protected int expectedModCount;

        Enumerator(int n, boolean bl) {
            this.table = KeyedHashtable.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = KeyedHashtable.this.modCount;
            this.type = n;
            this.iterator = bl;
        }

        @Override
        public boolean hasMoreElements() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            return entry != null;
        }

        public Object nextElement() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            if (entry != null) {
                Entry entry2 = this.lastReturned = this.entry;
                this.entry = entry2.next;
                return this.type == 0 ? entry2.key : (this.type == 1 ? entry2.value : entry2);
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        public Object next() {
            if (KeyedHashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (KeyedHashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            KeyedHashtable keyedHashtable = KeyedHashtable.this;
            synchronized (keyedHashtable) {
                Entry[] entryArray = KeyedHashtable.this.table;
                int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
                Entry entry = entryArray[n];
                Entry entry2 = null;
                while (entry != null) {
                    if (entry == this.lastReturned) {
                        ++KeyedHashtable.this.modCount;
                        ++this.expectedModCount;
                        if (entry2 == null) {
                            entryArray[n] = entry.next;
                        } else {
                            entry2.next = entry.next;
                        }
                        --KeyedHashtable.this.count;
                        this.lastReturned = null;
                        return;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }
}

