/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.lang.ValueOutOfBoundsException;
import de.geocalc.util.NumberFilter;
import java.util.StringTokenizer;

public class LongFilter
extends NumberFilter {
    private long min_Value = Integer.MIN_VALUE;
    private long max_Value = Integer.MAX_VALUE;
    private long min = this.min_Value;
    private long max = this.max_Value;

    public LongFilter() {
        this(Long.MIN_VALUE, Long.MAX_VALUE, true);
    }

    public LongFilter(long l, long l2) {
        this(l, l2, true);
    }

    public LongFilter(long l, long l2, boolean bl) {
        super(bl);
        this.min_Value = l;
        this.max_Value = l2;
        try {
            this.setBounds(l, l2);
        }
        catch (ValueOutOfBoundsException valueOutOfBoundsException) {
            // empty catch block
        }
    }

    public void setMinValue(long l) {
        this.min_Value = l;
        this.min = Math.max(this.min, this.min_Value);
    }

    public void setMaxValue(long l) {
        this.max_Value = l;
        this.max = Math.min(this.max, this.max_Value);
    }

    public void setMinimum(long l) throws ValueOutOfBoundsException {
        if (l < this.min_Value) {
            this.min = this.min_Value;
            throw new ValueOutOfBoundsException("Wert au\u00dferhalb des g\u00fcltigen Bereichs: " + l + " < " + this.min_Value);
        }
        this.min = l;
    }

    @Override
    public void setMinimum(Number number) throws ValueOutOfBoundsException {
        this.setMinimum(number.longValue());
    }

    @Override
    public void setMinimum(String string) throws NumberFormatException, ValueOutOfBoundsException {
        try {
            this.setMinimum(new Long(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Ung\u00fcltige Zeichen im Eingabeformat: " + string);
        }
    }

    @Override
    public Number getMinimum() {
        return new Long(this.min);
    }

    public void setMaximum(long l) throws ValueOutOfBoundsException {
        if (l > this.max_Value) {
            this.max = this.max_Value;
            throw new ValueOutOfBoundsException("Wert au\u00dferhalb des g\u00fcltigen Bereichs: " + l + " > " + this.max_Value);
        }
        this.max = l;
    }

    @Override
    public void setMaximum(Number number) throws ValueOutOfBoundsException {
        this.setMaximum(number.longValue());
    }

    @Override
    public void setMaximum(String string) throws NumberFormatException, ValueOutOfBoundsException {
        try {
            this.setMaximum(new Long(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Ung\u00fcltige Zeichen im Eingabeformat: " + string);
        }
    }

    @Override
    public Number getMaximum() {
        return new Long(this.max);
    }

    public void setBounds(long l, long l2) throws ValueOutOfBoundsException {
        this.min = Math.max(this.min_Value, l);
        this.max = Math.min(this.max_Value, l2);
        if (l < this.min_Value || l2 > this.max_Value) {
            throw new ValueOutOfBoundsException("Wert au\u00dferhalb des g\u00fcltigen Bereichs");
        }
    }

    @Override
    public void setBounds(String string) throws ValueOutOfBoundsException, NumberFormatException {
        long l = this.min_Value;
        long l2 = this.max_Value;
        boolean bl = false;
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        String string2 = null;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if (bl2) continue;
            try {
                l = new Long(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        try {
            l2 = new Long(string2);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (string.startsWith("-")) {
            l = this.min_Value;
        } else if (string.endsWith("-")) {
            l2 = this.max_Value;
        }
        this.setBounds(l, l2);
        if (bl) {
            throw new NumberFormatException("Ung\u00fcltige Zeichen im Eingabeformat");
        }
    }

    public boolean isValidValue(long l) {
        if (this.isEnabled()) {
            return l >= this.min && l <= this.max;
        }
        return true;
    }

    @Override
    public boolean isValidValue(Object object) {
        if (object instanceof Long) {
            return this.isValidValue((Long)object);
        }
        return false;
    }
}

