/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.util.LongHashListEntry;
import de.geocalc.util.LongHashListEnumerator;
import de.geocalc.util.LongHashObject;
import java.util.Enumeration;

public class LongHashList
implements Cloneable {
    private transient LongHashListEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public LongHashList(int n, float f) {
        if (n < 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException(n + "|" + f);
        }
        n = Math.max(n, 1);
        this.loadFactor = f;
        this.table = new LongHashListEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public LongHashList(int n) {
        this(n, 2.5f);
    }

    public LongHashList(float f) {
        this(101, f);
    }

    public LongHashList() {
        this(101, 2.5f);
    }

    public final int size() {
        return this.count;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    public Object clone() {
        try {
            LongHashList longHashList = (LongHashList)super.clone();
            longHashList.table = new LongHashListEntry[this.table.length];
            System.arraycopy(this.table, 0, longHashList.table, 0, this.table.length);
            return longHashList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final synchronized Enumeration elements() {
        return new LongHashListEnumerator(this.table);
    }

    public final synchronized boolean contains(LongHashObject longHashObject) {
        if (longHashObject == null) {
            throw new NullPointerException();
        }
        return this.containsKey(longHashObject.longHashKey());
    }

    public final synchronized boolean containsKey(long l) {
        int n = (int)((l & Long.MAX_VALUE) % (long)this.table.length);
        LongHashListEntry longHashListEntry = this.table[n];
        while (longHashListEntry != null) {
            if (longHashListEntry.value.longHashKey() == l) {
                return true;
            }
            longHashListEntry = longHashListEntry.next;
        }
        return false;
    }

    public final synchronized LongHashObject get(long l) {
        int n = (int)((l & Long.MAX_VALUE) % (long)this.table.length);
        LongHashListEntry longHashListEntry = this.table[n];
        while (longHashListEntry != null) {
            if (longHashListEntry.value.longHashKey() == l) {
                return longHashListEntry.value;
            }
            longHashListEntry = longHashListEntry.next;
        }
        return null;
    }

    private void rehash() {
        int n = this.table.length;
        LongHashListEntry[] longHashListEntryArray = this.table;
        int n2 = n * 2 + 1;
        LongHashListEntry[] longHashListEntryArray2 = new LongHashListEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = longHashListEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            LongHashListEntry longHashListEntry = longHashListEntryArray[n3];
            while (longHashListEntry != null) {
                LongHashListEntry longHashListEntry2 = longHashListEntry;
                longHashListEntry = longHashListEntry.next;
                int n4 = (int)((longHashListEntry2.value.longHashKey() & Long.MAX_VALUE) % (long)n2);
                longHashListEntry2.next = longHashListEntryArray2[n4];
                longHashListEntryArray2[n4] = longHashListEntry2;
            }
        }
    }

    public synchronized LongHashObject put(LongHashObject longHashObject) {
        if (longHashObject == null) {
            throw new NullPointerException();
        }
        long l = longHashObject.longHashKey();
        int n = (int)((l & Long.MAX_VALUE) % (long)this.table.length);
        LongHashListEntry longHashListEntry = this.table[n];
        while (longHashListEntry != null) {
            if (longHashListEntry.value.longHashKey() == l) {
                LongHashObject longHashObject2 = longHashListEntry.value;
                longHashListEntry.value = longHashObject;
                return longHashObject2;
            }
            longHashListEntry = longHashListEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            n = (int)((l & Long.MAX_VALUE) % (long)this.table.length);
        }
        longHashListEntry = new LongHashListEntry();
        longHashListEntry.value = longHashObject;
        longHashListEntry.next = this.table[n];
        this.table[n] = longHashListEntry;
        ++this.count;
        return null;
    }

    public final synchronized LongHashObject remove(LongHashObject longHashObject) {
        return this.remove(longHashObject.longHashKey());
    }

    public final synchronized LongHashObject remove(long l) {
        int n = (int)((l & Long.MAX_VALUE) % (long)this.table.length);
        LongHashListEntry longHashListEntry = this.table[n];
        LongHashListEntry longHashListEntry2 = null;
        while (longHashListEntry != null) {
            if (longHashListEntry.value.longHashKey() == l) {
                if (longHashListEntry2 != null) {
                    longHashListEntry2.next = longHashListEntry.next;
                } else {
                    this.table[n] = longHashListEntry.next;
                }
                --this.count;
                return longHashListEntry.value;
            }
            longHashListEntry2 = longHashListEntry;
            longHashListEntry = longHashListEntry.next;
        }
        return null;
    }

    public final synchronized void clear() {
        int n = this.table.length;
        while (--n >= 0) {
            this.table[n] = null;
        }
        this.count = 0;
    }

    public void printDebug() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null) continue;
            ++n;
            int n3 = 0;
            LongHashListEntry longHashListEntry = this.table[i];
            while (longHashListEntry != null) {
                longHashListEntry = longHashListEntry.next;
                ++n3;
            }
            n2 = Math.max(n2, n3);
        }
        System.out.println("Size: " + this.table.length + " Belegt:" + n + " (" + (double)n / (double)this.table.length + "%) max einzelne Belegung: " + n2);
    }
}

