/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class NumberTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int maxPosition;
    private String str;

    public NumberTokenizer(String string) {
        this.str = string;
        this.maxPosition = string.length();
    }

    private void skipDelimiters() {
        while (this.currentPosition < this.maxPosition && !this.isNumber(this.str.charAt(this.currentPosition))) {
            ++this.currentPosition;
        }
    }

    public boolean hasMoreTokens() {
        this.skipDelimiters();
        return this.currentPosition < this.maxPosition;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public String nextToken() {
        this.skipDelimiters();
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int n = this.currentPosition;
        while (this.currentPosition < this.maxPosition && this.isNumber(this.str.charAt(this.currentPosition))) {
            ++this.currentPosition;
        }
        return this.str.substring(n, this.currentPosition);
    }

    public Object nextElement() {
        return this.nextToken();
    }

    private boolean isNumber(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }
}

