/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.util.Comparable;
import de.geocalc.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SortableVector
extends Vector {
    public SortableVector() {
    }

    public SortableVector(int n) {
        super(n);
    }

    public SortableVector(Enumeration enumeration) {
        super(100);
        this.copyElements(enumeration);
    }

    public SortableVector(Enumeration enumeration, Comparator comparator) {
        this(enumeration);
        this.sort(comparator);
    }

    public SortableVector(Vector vector) {
        super(vector.size());
        this.copyElements(vector.elements());
    }

    public SortableVector(Vector vector, Comparator comparator) {
        this(vector);
        this.sort(comparator);
    }

    public SortableVector(Hashtable hashtable) {
        super(hashtable.size());
        this.copyElements(hashtable.elements());
    }

    public SortableVector(Hashtable hashtable, Comparator comparator) {
        this(hashtable);
        this.sort(comparator);
    }

    private void copyElements(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.addElement(enumeration.nextElement());
        }
    }

    public void sort() {
        Object[] objectArray = (Object[])this.elementData.clone();
        SortableVector.mergeSort(objectArray, this.elementData, 0, this.elementCount);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && ((Comparable)objectArray2[j - 1]).compareTo((Comparable)objectArray2[j]) > 0; --j) {
                    SortableVector.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = n + n2 >> 1;
        SortableVector.mergeSort(objectArray2, objectArray, n, n4);
        SortableVector.mergeSort(objectArray2, objectArray, n4, n2);
        if (((Comparable)objectArray[n4 - 1]).compareTo((Comparable)objectArray[n4]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            objectArray2[i] = n6 >= n2 || n5 < n4 && ((Comparable)objectArray[n5]).compareTo(objectArray[n6]) <= 0 ? objectArray[n5++] : objectArray[n6++];
        }
    }

    public void sort(Comparator comparator) {
        Object[] objectArray = (Object[])this.elementData.clone();
        SortableVector.mergeSort(objectArray, this.elementData, 0, this.elementCount, comparator);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, Comparator comparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && comparator.compare(objectArray2[j - 1], objectArray2[j]) > 0; --j) {
                    SortableVector.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = n + n2 >> 1;
        SortableVector.mergeSort(objectArray2, objectArray, n, n4, comparator);
        SortableVector.mergeSort(objectArray2, objectArray, n4, n2, comparator);
        if (comparator.compare(objectArray[n4 - 1], objectArray[n4]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            objectArray2[i] = n6 >= n2 || n5 < n4 && comparator.compare(objectArray[n5], objectArray[n6]) <= 0 ? objectArray[n5++] : objectArray[n6++];
        }
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }
}

