/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util;

import de.geocalc.util.IntegerHashList;
import de.geocalc.util.Sortable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class SortedList {
    Entry first = null;
    int elements = 0;

    public SortedList() {
    }

    public SortedList(Vector vector) {
        this(vector.elements());
    }

    public SortedList(Hashtable hashtable) {
        this(hashtable.elements());
    }

    public SortedList(IntegerHashList integerHashList) {
        this(integerHashList.elements());
    }

    public SortedList(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.add((Sortable)enumeration.nextElement());
        }
    }

    public void add(Sortable sortable) {
        ++this.elements;
        Entry entry = this.first;
        if (entry == null || sortable.isLt(entry.getObject())) {
            this.first = new Entry(this, sortable, entry);
            return;
        }
        while (entry.getNext() != null) {
            if (sortable.isLt(entry.getNext().getObject())) {
                Entry entry2 = new Entry(this, sortable, entry.getNext());
                entry.setNext(entry2);
                return;
            }
            entry = entry.getNext();
        }
        entry.setNext(new Entry(this, sortable, null));
    }

    public int size() {
        return this.elements;
    }

    public Enumeration elements() {
        return new SortedListEnumerator(this, this.first);
    }

    class Entry {
        Sortable obj;
        Entry next;

        Entry(SortedList sortedList, Sortable sortable, Entry entry) {
            this.obj = sortable;
            this.next = entry;
        }

        Sortable getObject() {
            return this.obj;
        }

        Entry getNext() {
            return this.next;
        }

        void setNext(Entry entry) {
            this.next = entry;
        }
    }

    class SortedListEnumerator
    implements Enumeration {
        Entry e = null;

        SortedListEnumerator(SortedList sortedList, Entry entry) {
            this.e = entry;
        }

        @Override
        public boolean hasMoreElements() {
            return this.e != null;
        }

        public Object nextElement() {
            if (this.e == null) {
                throw new NoSuchElementException("SortedListEnumerator");
            }
            Entry entry = this.e;
            this.e = this.e.getNext();
            return entry.getObject();
        }
    }
}

