/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.util.sml;

public class Tag {
    public static final char NO = '\u0000';
    public static final char BEFORE = '#';
    public static final char APPEND = '&';
    public static final char REPLACE = '!';
    public static final char UN1 = '\u00a7';
    public static final char UN2 = '$';
    private static final char OPEN = '<';
    private static final char CLOSE = '>';
    private static final char GLEICH = '=';
    private static final char SPACE = ' ';
    private String name = null;
    private String value = null;

    public Tag(String string) {
        this(string, null);
    }

    public Tag(String string, long l) {
        this(string, Long.toString(l));
    }

    public Tag(String string, String string2) {
        this.name = string;
        this.value = string2;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getValue() {
        if (this.hasControl()) {
            return this.value.substring(1);
        }
        return this.value;
    }

    public boolean hasControl() {
        return this.value != null && this.value.length() > 0 && this.isControl(this.value.charAt(0));
    }

    public char getControl() {
        return this.hasControl() ? this.value.charAt(0) : (char)'\u0000';
    }

    private boolean isControl(char c) {
        switch (c) {
            case '!': 
            case '#': 
            case '$': 
            case '&': 
            case '\u00a7': {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof Tag) {
            return ((Tag)object).getName().equals(this.getName());
        }
        if (object instanceof String) {
            return this.name.equalsIgnoreCase((String)object);
        }
        return false;
    }

    public String toString() {
        return Tag.toString(this.name, this.value);
    }

    public static boolean isTag(String string) {
        boolean bl = false;
        boolean bl2 = false;
        block5: for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            switch (c) {
                case '>': {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                    continue block5;
                }
                case '<': {
                    if (!bl) {
                        return false;
                    }
                    bl2 = true;
                    bl = false;
                    continue block5;
                }
                case ' ': {
                    continue block5;
                }
                default: {
                    if (bl) continue block5;
                    return false;
                }
            }
        }
        return bl2;
    }

    public static boolean hasTag(String string) {
        int n = string.indexOf(60);
        return n >= 0 && string.indexOf(62, n) > n;
    }

    private static boolean isTag(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = n;
        while (string.charAt(n) == ' ' && n++ < n2) {
        }
        boolean bl = false;
        do {
            switch (string.charAt(n4)) {
                case ' ': 
                case '=': 
                case '>': {
                    bl = true;
                }
            }
        } while (!bl && n4++ < n2);
        return n4 > n && string.substring(n, n4).equalsIgnoreCase(string2);
    }

    public static boolean hasTag(String string, String string2) {
        if (Tag.hasTag(string)) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (string.charAt(i) != '<' || !Tag.isTag(string, string2, i + 1)) continue;
                return true;
            }
        }
        return false;
    }

    public static String removeTag(String string, String string2) {
        int n = string.length();
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    if (!Tag.isTag(string, string2, i + 1)) break;
                    n2 = i;
                    break;
                }
                case '>': {
                    if (n2 <= -1) break;
                    n3 = i + 1;
                }
            }
            if (n3 > -1) break;
        }
        if (n2 == 0) {
            return string.substring(n3);
        }
        if (n2 > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n2));
            stringBuffer.append(string.substring(n3, n));
            return stringBuffer.toString();
        }
        return string;
    }

    public static Tag parseTag(String string) {
        int n = string.indexOf(61);
        if (n > 0) {
            return new Tag(string.substring(0, n), string.substring(n + 1));
        }
        return new Tag(string);
    }

    public static Tag parseTag(String string, String string2) {
        if (string != null) {
            int n = string.length();
            for (int i = n - 1; i >= 0; --i) {
                if (string.charAt(i) != '<' || !Tag.isTag(string, string2, i + 1)) continue;
                int n2 = string.indexOf(61, i + 1);
                int n3 = string.indexOf(62, i + 1);
                if (n3 <= 0) continue;
                if (n2 > 0 && n2 < n3) {
                    return new Tag(string.substring(i + 1, n2), string.substring(n2 + 1, n3));
                }
                return new Tag(string.substring(i + 1, n3));
            }
        }
        return null;
    }

    public static String parseText(String string) {
        String string2;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        block4: for (int i = n = 0; i < n2; ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    if (n >= 0) {
                        stringBuffer.append(string.substring(n, i));
                    }
                    n = -1;
                    continue block4;
                }
                case '>': {
                    n = i + 1;
                }
            }
        }
        if (n >= 0) {
            stringBuffer.append(string.substring(n));
        }
        return (string2 = stringBuffer.toString().trim()).length() > 0 ? string2 : null;
    }

    public static String toString(String string, long l) {
        return Tag.toString(string, Long.toString(l));
    }

    public static String toString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(string.toUpperCase());
        if (string2 != null) {
            stringBuffer.append('=');
            stringBuffer.append(string2);
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }
}

