/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.webservice;

import de.geocalc.text.IFormat;
import de.geocalc.webservice.BoundingBox;
import de.geocalc.webservice.Layer;
import de.geocalc.webservice.Srs;
import de.geocalc.xml.Att;
import de.geocalc.xml.Node;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Capability {
    public String sName;
    public String sTitle;
    public String sAbstract;
    public String sKeywords;
    public String sContactPersonPrimaryPerson;
    public String sContactPersonPrimaryOrganization;
    public String sContactPosition;
    public String sContactAddressType;
    public String sContactAddressAdress;
    public String sContactAddressCity;
    public String sContactAddressStateOrProvince;
    public String sContactAddressPostCode;
    public String sContactAddressCountry;
    public String sContactVoiceTelefone;
    public String sContactFacsimileTelephone;
    public String sContactElectronicMailAddress;
    public String sGetOnlineResource = "http://127.0.0.1:8000/";
    public String sPostOnlineResource = "http://127.0.0.1:8000/";
    private double lminx;
    private double lminy;
    private double lmaxx;
    private double lmaxy;
    private double minScale;
    private double maxScale;
    private Vector<Layer> layers = new Vector();
    private Vector<Srs> systems = new Vector();
    private Vector<BoundingBox> boxes = new Vector();

    public void setOnlineResource(String string, int n) {
        this.sGetOnlineResource = "http://" + string + ":" + n + "/";
        this.sPostOnlineResource = "http://" + string + ":" + n + "/";
    }

    public void setBox(double d, double d2, double d3, double d4) {
        this.lminx = d;
        this.lminy = d2;
        this.lmaxx = d3;
        this.lmaxy = d4;
    }

    public void setScale(double d, double d2) {
        this.minScale = d;
        this.maxScale = d2;
    }

    public void addLayer(Layer layer) {
        this.layers.addElement(layer);
    }

    public void addSRS(Srs srs) {
        this.systems.addElement(srs);
    }

    public void addBox(BoundingBox boundingBox) {
        this.boxes.addElement(boundingBox);
    }

    public String toXml() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Object object;
            Node node;
            Node node2 = new Node("DCPType");
            Node node3 = new Node("HTTP");
            node2.addNode(node3);
            Node node4 = new Node("Get");
            node3.addNode(node4);
            Node node5 = new Node("OnlineResource");
            node5.addAtt(new Att("xmlns:xlink", "http://www.w3.org/1999/xlink"));
            node5.addAtt(new Att("xlink:href", this.sGetOnlineResource));
            node4.addNode(node5);
            Node node6 = new Node("Post");
            node3.addNode(node6);
            Node node7 = new Node("OnlineResource");
            node7.addAtt(new Att("xmlns:xlink", "http://www.w3.org/1999/xlink"));
            node7.addAtt(new Att("xlink:href", this.sPostOnlineResource));
            node6.addNode(node5);
            stringBuffer.append("<?xml version='1.0' encoding='ISO-8859-1' standalone='no' ?><!DOCTYPE WMT_MS_Capabilities SYSTEM 'http://schemas.opengeospatial.net/wms/1.1.1/capabilities_1_1_1.dtd' [ <!ELEMENT VendorSpecificCapabilities EMPTY> ]>");
            Node node8 = new Node("WMT_MS_Capabilities");
            node8.addAtt(new Att("version", "1.1.1"));
            Node node9 = new Node("Service");
            node8.addNode(node9);
            if (this.sName != null) {
                node9.addNode(new Node("Name", this.sName));
            }
            if (this.sTitle != null) {
                node9.addNode(new Node("Title", this.sTitle));
            }
            if (this.sKeywords != null) {
                node = new Node("KeywordList");
                node9.addNode(node);
                object = new StringTokenizer(this.sKeywords, ",;");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    node.addNode(new Node("Keyword", ((StringTokenizer)object).nextToken()));
                }
            }
            node = new Node("ContactInformation");
            node9.addNode(node);
            if (this.sContactPersonPrimaryPerson != null) {
                node.addNode(new Node("ContactPersonPrimaryPerson", this.sContactPersonPrimaryPerson));
            }
            if (this.sContactPersonPrimaryOrganization != null) {
                node.addNode(new Node("ContactPersonPrimaryOrganization", this.sContactPersonPrimaryOrganization));
            }
            if (this.sContactPosition != null) {
                node.addNode(new Node("ContactPersonPrimaryOrganization", this.sContactPosition));
            }
            object = new Node("ContactAddress");
            node.addNode((Node)object);
            if (this.sContactAddressType != null) {
                ((Node)object).addNode(new Node("AddressType", this.sContactAddressType));
            }
            if (this.sContactAddressAdress != null) {
                ((Node)object).addNode(new Node("Address", this.sContactAddressAdress));
            }
            if (this.sContactAddressCity != null) {
                ((Node)object).addNode(new Node("City", this.sContactAddressCity));
            }
            if (this.sContactAddressStateOrProvince != null) {
                ((Node)object).addNode(new Node("StateOrProvince", this.sContactAddressStateOrProvince));
            }
            if (this.sContactAddressPostCode != null) {
                ((Node)object).addNode(new Node("PostCode", this.sContactAddressPostCode));
            }
            if (this.sContactAddressCountry != null) {
                ((Node)object).addNode(new Node("Country", this.sContactAddressCountry));
            }
            if (this.sContactVoiceTelefone != null) {
                node.addNode(new Node("ContactVoiceTelephone", this.sContactVoiceTelefone));
            }
            if (this.sContactFacsimileTelephone != null) {
                node.addNode(new Node("ContactFacsimileTelephone", this.sContactFacsimileTelephone));
            }
            if (this.sContactElectronicMailAddress != null) {
                node.addNode(new Node("ContactElectronicMailAddress", this.sContactElectronicMailAddress));
            }
            Node node10 = new Node("Capability");
            Node node11 = new Node("Request");
            Node node12 = new Node("GetCapabilities");
            node12.addNode(new Node("Format", "application/vnd.ogc.wms_xml"));
            node12.addNode(node2);
            node11.addNode(node12);
            Node node13 = new Node("GetMap");
            node13.addNode(new Node("Format", "image/png"));
            node13.addNode(new Node("Format", "image/jpeg"));
            node13.addNode(new Node("Format", "image/gif"));
            node13.addNode(new Node("Format", "image/wbmp"));
            node13.addNode(new Node("Format", "image/tiff"));
            node13.addNode(node2);
            node11.addNode(node13);
            Node node14 = new Node("GetFeatureInfo");
            node14.addNode(new Node("Format", "text/xml"));
            node14.addNode(new Node("Format", "text/html"));
            node14.addNode(new Node("Format", "text/plain"));
            node14.addNode(node2);
            node11.addNode(node14);
            Node node15 = new Node("DescribeLayer");
            node15.addNode(new Node("Format", "text/xml"));
            node15.addNode(node2);
            Node node16 = new Node("GetLegendGraphic");
            node11.addNode(node16);
            node10.addNode(node11);
            Node node17 = new Node("Exception");
            node17.addNode(new Node("Format", "application/vnd.ogc.se_xml"));
            node10.addNode(node17);
            Node node18 = new Node("Layer");
            node18.addNode(new Node("Title", "KafPlotWebMapService"));
            Enumeration<Layer> enumeration = this.systems.elements();
            while (enumeration.hasMoreElements()) {
                node18.addNode(enumeration.nextElement().toNode());
            }
            if (this.lminx != 0.0 || this.lmaxx != 0.0) {
                enumeration = new Node("LatLonBoundingBox");
                ((Node)((Object)enumeration)).addAtt(new Att("minx", IFormat.f0_4.format(this.lminx)));
                ((Node)((Object)enumeration)).addAtt(new Att("miny", IFormat.f0_4.format(this.lminy)));
                ((Node)((Object)enumeration)).addAtt(new Att("maxx", IFormat.f0_4.format(this.lmaxx)));
                ((Node)((Object)enumeration)).addAtt(new Att("maxy", IFormat.f0_4.format(this.lmaxy)));
                node18.addNode((Node)((Object)enumeration));
            }
            enumeration = this.boxes.elements();
            while (enumeration.hasMoreElements()) {
                node18.addNode(enumeration.nextElement().toNode());
            }
            if (this.minScale != 0.0 || this.maxScale != 0.0) {
                enumeration = new Node("ScaleHint");
                ((Node)((Object)enumeration)).addAtt(new Att("min", IFormat.f_1.format(this.minScale)));
                ((Node)((Object)enumeration)).addAtt(new Att("max", IFormat.f_1.format(this.maxScale)));
                node18.addNode((Node)((Object)enumeration));
            }
            enumeration = this.layers.elements();
            while (enumeration.hasMoreElements()) {
                node18.addNode(enumeration.nextElement().toNode());
            }
            node10.addNode(node18);
            node8.addNode(node10);
            stringBuffer.append(node8);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }
}

