/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.webservice;

import de.geocalc.text.IFormat;
import de.geocalc.xml.Node;
import java.util.Enumeration;
import java.util.Vector;

public class FeatureInfo {
    private Vector<Node> gmlNodes = new Vector();

    public int featureCount() {
        return this.gmlNodes.size();
    }

    public void addNode(Node node) {
        this.gmlNodes.addElement(node);
    }

    public String toPlainText() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Node> enumeration = this.gmlNodes.elements();
        while (enumeration.hasMoreElements()) {
            int n = 0;
            this.appendNodeAsPlainText(stringBuffer, n, enumeration.nextElement());
        }
        return stringBuffer.toString();
    }

    private void appendNodeAsPlainText(StringBuffer stringBuffer, int n, Node node) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append("\n");
        }
        stringBuffer.append(IFormat.getSpaces(n));
        stringBuffer.append(node.getName());
        if (node.hasValue()) {
            stringBuffer.append("\t");
            stringBuffer.append(node.getValue());
        } else if (node.hasNodes()) {
            Enumeration enumeration = node.elements();
            while (enumeration.hasMoreElements()) {
                this.appendNodeAsPlainText(stringBuffer, n + 3, (Node)enumeration.nextElement());
            }
        }
    }

    public String toHtmlText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n");
        stringBuffer.append("<body>\n");
        Enumeration<Node> enumeration = this.gmlNodes.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("<table cellspacing='2' cellpadding='2'>\n");
            this.appendNodeAsHtmlText(stringBuffer, enumeration.nextElement());
            stringBuffer.append("</table>\n");
        }
        stringBuffer.append("</body>\n");
        stringBuffer.append("</html>\n");
        return stringBuffer.toString();
    }

    private void appendNodeAsHtmlText(StringBuffer stringBuffer, Node node) {
        if (node.hasNodes()) {
            stringBuffer.append("<tr><td bgcolor='#ffdece' colspan='2' ><b>");
        } else {
            stringBuffer.append("<tr><td bgcolor='#ffdece'>");
        }
        stringBuffer.append(node.getName());
        if (node.hasNodes()) {
            stringBuffer.append("</b>");
        }
        stringBuffer.append("</td>");
        if (node.hasValue()) {
            stringBuffer.append("<td bgcolor='#ffdece'>");
            stringBuffer.append(node.getValue());
            stringBuffer.append("</td></tr>\n");
        } else if (node.hasNodes()) {
            stringBuffer.append("</tr>\n");
            Enumeration enumeration = node.elements();
            while (enumeration.hasMoreElements()) {
                this.appendNodeAsHtmlText(stringBuffer, (Node)enumeration.nextElement());
            }
        } else {
            stringBuffer.append("</tr>\n");
        }
        stringBuffer.append("\n");
    }

    public String toXmlText() {
        Node node = new Node("GetFeatureInfo");
        Enumeration<Node> enumeration = this.gmlNodes.elements();
        while (enumeration.hasMoreElements()) {
            try {
                node.addNode(enumeration.nextElement());
            }
            catch (Exception exception) {}
        }
        return node.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Node> enumeration = this.gmlNodes.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
        }
        return stringBuffer.toString();
    }
}

