/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.webservice;

import de.geocalc.webservice.HTTPConst;
import de.geocalc.webservice.HTTPResponse;
import de.geocalc.webservice.Service;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HTTPRequest {
    Service service;
    private int fHTTPError;
    private Socket fSocket;
    private BufferedReader fCReader;
    private DataOutputStream fCWriter;
    private String fMethod;
    private String fURL;
    private String fVersion;
    private String fBody;
    private String fQuery;
    private Hashtable fHeaderLines;

    public HTTPRequest(Socket socket, Service service) {
        try {
            this.service = service;
            this.fHTTPError = 200;
            this.fSocket = socket;
            this.fCReader = new BufferedReader(new InputStreamReader(this.fSocket.getInputStream()));
            this.fCWriter = new DataOutputStream(this.fSocket.getOutputStream());
            this.fHeaderLines = new Hashtable();
        }
        catch (IOException iOException) {
            System.err.println("IOException: HTTPRequestHandler.HTTPRequestHandler()");
            System.err.println(iOException);
            this.fHTTPError = 400;
        }
    }

    public void receive() {
        try {
            this.getRequestLine();
            this.getHeaderLines();
            this.getEntityBody();
            this.setServerQuery();
            if (HTTPConst.fServerVerbose) {
                this.writeRequestHeader();
            }
            HTTPResponse hTTPResponse = new HTTPResponse(this.fHeaderLines, this.service);
            if (this.fHTTPError == 200) {
                hTTPResponse.setHost((String)this.fHeaderLines.get("Host"));
                hTTPResponse.setURL(HTTPConst.decodeURL(this.fURL));
                hTTPResponse.setQuery(HTTPConst.decodeURL(this.fQuery));
            }
            hTTPResponse.setStatusCode(this.fHTTPError);
            hTTPResponse.send(this.fCWriter);
            this.fSocket.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException: HTTPRequestHandler.receive()");
            System.err.println(iOException);
        }
    }

    private HTTPRequest() {
    }

    private void getRequestLine() {
        try {
            String string = this.fCReader.readLine();
            Vector vector = HTTPConst.tokenize(string, ' ');
            if (vector.size() != 3) {
                this.fHTTPError = 400;
            } else {
                this.fMethod = (String)vector.elementAt(0);
                this.fURL = (String)vector.elementAt(1);
                this.fVersion = (String)vector.elementAt(2);
                if (!this.fVersion.substring(0, 4).equals("HTTP")) {
                    this.fHTTPError = 400;
                }
                if (!this.fMethod.equals("GET") && !this.fMethod.equals("POST")) {
                    this.fHTTPError = 501;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException: HTTPRequestHandler.getRequestLine()");
            System.err.println(iOException);
            this.fHTTPError = 400;
        }
    }

    private void getHeaderLines() {
        if (this.fHTTPError == 400) {
            return;
        }
        try {
            String string = this.fCReader.readLine();
            while (string.length() != 0) {
                int n = string.indexOf(58);
                if (n != -1) {
                    String string2 = string.substring(0, n).trim();
                    String string3 = string.substring(n + 1, string.length()).trim();
                    if (!this.fHeaderLines.containsKey(string2)) {
                        this.fHeaderLines.put(string2, string3);
                    }
                }
                string = this.fCReader.readLine();
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException: HTTPRequestHandler.getHeaderLines()");
            System.err.println(iOException);
            this.fHTTPError = 400;
        }
    }

    private void getEntityBody() {
        if (this.fHTTPError == 400) {
            return;
        }
        try {
            int n = 0;
            if (this.fHeaderLines.containsKey("Content-Length")) {
                n = Integer.parseInt((String)this.fHeaderLines.get("Content-Length"));
            } else if (this.fHeaderLines.containsKey("Content-length")) {
                n = Integer.parseInt((String)this.fHeaderLines.get("Content-length"));
            } else {
                return;
            }
            char[] cArray = new char[n];
            this.fCReader.read(cArray, 0, n);
            this.fBody = new String(cArray);
        }
        catch (IOException iOException) {
            System.err.println("IOException: HTTPRequestHandler.getEntityBody()");
            System.err.println(iOException);
            this.fHTTPError = 400;
        }
    }

    private void setServerQuery() {
        if (this.fHTTPError != 200) {
            return;
        }
        String string = null;
        int n = this.fURL.indexOf(63);
        int n2 = this.fURL.length();
        if (n != -1) {
            if (n + 1 < n2) {
                string = this.fURL.substring(n + 1, n2);
            }
            this.fURL = this.fURL.substring(0, n);
        }
        if (this.fMethod.equals("GET") && string != null) {
            this.fQuery = string;
        } else if (this.fMethod.equals("POST") && this.fBody != null) {
            this.fQuery = this.fBody;
        }
    }

    private void writeRequestHeader() {
        System.err.println("[========== HTTP REQUEST HEADER ==========]");
        System.err.println("  " + this.fMethod + " " + this.fURL + (String)(this.fQuery == null ? "" : "?" + this.fQuery) + " " + this.fVersion);
        Enumeration enumeration = this.fHeaderLines.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.err.println("  " + string + ": " + String.valueOf(this.fHeaderLines.get(string)));
        }
        System.err.println("");
    }
}

