/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.webservice;

import de.geocalc.webservice.Capability;
import de.geocalc.webservice.FeatureInfo;
import de.geocalc.webservice.HTTPConst;
import de.geocalc.webservice.Map;
import de.geocalc.webservice.Service;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HTTPResponse {
    Service service;
    private final String fVersion = "HTTP/1.0";
    private final String fIndexFile = "index";
    private final String[] fIndexTypes = new String[]{"htm", "html", "txt", "text"};
    private int fStatusCode;
    private String fHost;
    private String fPhrase;
    private String fURL;
    private String fQuery;
    private String fRealm;
    private Hashtable fHeaderLines;
    private Hashtable fRequestHeaderLines;
    private Hashtable fQueries;

    public HTTPResponse(Hashtable hashtable, Service service) {
        this.service = service;
        this.fStatusCode = 200;
        this.fHeaderLines = new Hashtable();
        this.fRequestHeaderLines = hashtable;
        this.fQueries = new Hashtable();
    }

    public void setHost(String string) {
        this.fHost = string;
    }

    public void setURL(String string) {
        this.fURL = string;
    }

    public void setQuery(String string) {
        this.fQuery = string;
    }

    public void setStatusCode(int n) {
        this.fStatusCode = n;
    }

    public void send(DataOutputStream dataOutputStream) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            block32: {
                object5 = "";
                object4 = "";
                if (!this.fURL.equals("/") && !this.fURL.equals("\\")) {
                    System.err.println("Unerwartete URL: '" + this.fURL + "'");
                }
                if (this.fQuery == null) {
                    object5 = this.createHtmlInfo("");
                    this.fHeaderLines.put("Content-Type", "text/html");
                    this.fHeaderLines.put("Content-Length", Integer.toString(((String)object5).length()));
                } else {
                    this.resolveQuery();
                    this.resolvePhrase();
                    if (this.fStatusCode == 200) {
                        try {
                            Object object6;
                            String string;
                            String string2;
                            String string3;
                            String string4;
                            String string5;
                            String string6;
                            Object object7;
                            object3 = (String)this.fQueries.get("SERVICE");
                            if (object3 != null && !((String)object3).equalsIgnoreCase("WMS")) {
                                throw new Exception("unknown SERVICE " + (String)object3);
                            }
                            object2 = (String)this.fQueries.get("REQUEST");
                            if (object2 == null || ((String)object2).equalsIgnoreCase("GetCapabilities")) {
                                object7 = this.service.getCapability();
                                object5 = ((Capability)object7).toXml();
                                this.fHeaderLines.put("Content-Type", "text/xml");
                                this.fHeaderLines.put("Content-Length", Integer.toString(((String)object5).length()));
                                break block32;
                            }
                            if (((String)object2).equalsIgnoreCase("GetMap")) {
                                object7 = (String)this.fQueries.get("FORMAT");
                                object = (String)this.fQueries.get("BBOX");
                                string6 = (String)this.fQueries.get("WIDTH");
                                string5 = (String)this.fQueries.get("HEIGHT");
                                string4 = (String)this.fQueries.get("VERSION");
                                string3 = (String)this.fQueries.get("LAYERS");
                                string2 = (String)this.fQueries.get("TRANSPARENT");
                                string = (String)this.fQueries.get("BGCOLOR");
                                if (object7 == null) {
                                    object7 = "image/gif";
                                }
                                object4 = object7;
                                if (object == null) {
                                    throw new Exception("no BBOX in Query");
                                }
                                if (string6 == null) {
                                    throw new Exception("no WIDTH in Query");
                                }
                                if (string5 == null) {
                                    throw new Exception("no HEIGHT in Query");
                                }
                                object5 = object6 = this.service.getMap((String)object, string6, string5, string3, string2, string);
                                this.fHeaderLines.put("Content-Type", object7);
                                break block32;
                            }
                            if (((String)object2).equalsIgnoreCase("GetFeatureInfo")) {
                                object7 = (String)this.fQueries.get("VERSION");
                                object = (String)this.fQueries.get("BBOX");
                                string6 = (String)this.fQueries.get("WIDTH");
                                string5 = (String)this.fQueries.get("HEIGHT");
                                string4 = (String)this.fQueries.get("QUERY_LAYERS");
                                string3 = (String)this.fQueries.get("INFO_FORMAT");
                                string2 = (String)this.fQueries.get("FEATURE_COUNT");
                                string = (String)this.fQueries.get("X");
                                FeatureInfo featureInfo = this.service.getFeatureInfo((String)object, string6, string5, string, (String)(object6 = (String)this.fQueries.get("Y")), string4, string2);
                                if (featureInfo.featureCount() == 0) {
                                    throw new Exception("no Feature found");
                                }
                                String string7 = "text/plain";
                                if (string3 == null) {
                                    object5 = featureInfo.toPlainText();
                                    string7 = "text/plain";
                                } else if (string3.indexOf("text/xml") >= 0) {
                                    object5 = featureInfo.toXmlText();
                                    string7 = "text/xml";
                                } else if (string3.indexOf("text/html") >= 0) {
                                    object5 = featureInfo.toHtmlText();
                                    string7 = "text/html";
                                } else {
                                    object5 = featureInfo.toPlainText();
                                    string7 = "text/plain";
                                }
                                this.fHeaderLines.put("Content-Type", string7);
                                this.fHeaderLines.put("Content-Length", Integer.toString(((String)object5).length()));
                                break block32;
                            }
                            throw new Exception("unknown REQUEST " + (String)object2);
                        }
                        catch (Exception exception) {
                            object5 = this.createXmlErr(exception);
                        }
                    } else {
                        object5 = this.createHtmlErr(new Exception("StatusCode = " + this.fStatusCode + " URL = '" + this.fURL + "'"));
                    }
                }
            }
            if (HTTPConst.fServerVerbose) {
                this.writeQueryHeader();
                this.writeResponseHeader();
            }
            dataOutputStream.writeBytes("HTTP/1.0 " + this.fStatusCode + " " + this.fPhrase + "\r\n");
            object3 = this.fHeaderLines.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                dataOutputStream.writeBytes((String)object2 + ": " + (String)this.fHeaderLines.get(object2) + "\r\n");
            }
            dataOutputStream.writeBytes("\r\n");
            if (object5 instanceof String) {
                dataOutputStream.writeBytes((String)object5);
            } else if (this.fStatusCode == 200 && object5 instanceof File) {
                object2 = new BufferedInputStream(new FileInputStream((File)object5));
                int n = 1024;
                object = new byte[n];
                int n2 = n;
                while (n2 == n) {
                    n2 = ((BufferedInputStream)object2).read((byte[])object, 0, n);
                    if (n2 == -1) continue;
                    dataOutputStream.write((byte[])object, 0, n2);
                }
                ((BufferedInputStream)object2).close();
                ((File)object5).delete();
            } else if (this.fStatusCode == 200 && object5 instanceof Map) {
                ((Map)object5).putOutputStream((String)object4, dataOutputStream);
            }
        }
        catch (Exception exception) {
            System.err.println("IOException: HTTPResponse.send()");
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    private String createHtmlErr(Exception exception) {
        System.err.println(exception.getClass().getName() + ": " + exception.getMessage());
        exception.printStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body><p>");
        stringBuffer.append("<b>" + exception.getClass().getName() + "</b>" + exception.getMessage());
        stringBuffer.append("<ul>");
        Enumeration enumeration = this.fQueries.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            stringBuffer.append("<li>" + String.valueOf(k) + ":" + String.valueOf(this.fQueries.get(k)) + "</li>");
        }
        stringBuffer.append("</ul>");
        stringBuffer.append("</p></body></html>");
        this.fHeaderLines.put("Content-Type", "text/html");
        this.fHeaderLines.put("Content-Length", Integer.toString(stringBuffer.length()));
        return stringBuffer.toString();
    }

    private String createXmlErr(Exception exception) {
        System.err.println(exception.getClass().getName() + ": " + exception.getMessage());
        exception.printStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' encoding=\"ISO-8859-1\" standalone=\"no\" ?>");
        stringBuffer.append("<!DOCTYPE ServiceExceptionReport SYSTEM \"http://schemas.opengeospatial.net/wms/1.1.1/exception_1_1_1.dtd\">");
        stringBuffer.append("<ServiceExceptionReport version=\"1.1.1\">");
        stringBuffer.append("<ServiceException>");
        stringBuffer.append(exception.getClass().getName() + " " + exception.getMessage());
        stringBuffer.append("</ServiceException>");
        stringBuffer.append("</ServiceExceptionReport>");
        String string = (String)this.fRequestHeaderLines.get("Accept");
        if (string != null && string.indexOf("application/vnd.ogc.se_xml") < 0) {
            this.fHeaderLines.put("Content-Type", "text/xml");
        } else {
            this.fHeaderLines.put("Content-Type", "application/vnd.ogc.se_xml");
        }
        this.fHeaderLines.put("Content-Length", Integer.toString(stringBuffer.length()));
        return stringBuffer.toString();
    }

    private String createHtmlInfo(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body><p>");
        stringBuffer.append("<b>KafPlotWmsServer </b>" + string);
        stringBuffer.append("<ul>");
        stringBuffer.append("<li>GetCapabilities</li>");
        stringBuffer.append("<li>GetMap</li>");
        stringBuffer.append("</ul>");
        stringBuffer.append("</p></body></html>");
        return stringBuffer.toString();
    }

    private HTTPResponse() {
    }

    private void resolveQuery() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.fQuery, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n = string.indexOf("=");
            if (n >= 0) {
                this.fQueries.put(string.substring(0, n).toUpperCase(), string.substring(n + 1));
                continue;
            }
            this.fQueries.put(string, "");
        }
    }

    private void resolvePhrase() {
        switch (this.fStatusCode) {
            case 200: {
                this.fPhrase = "OK";
                break;
            }
            case 400: {
                this.fPhrase = "Bad request";
                break;
            }
            case 403: {
                this.fPhrase = "Forbidden";
                break;
            }
            case 404: {
                this.fPhrase = "Not found";
                break;
            }
            case 501: {
                this.fPhrase = "Not implemented";
                break;
            }
            case 401: {
                this.fPhrase = "Unauthorized";
                break;
            }
            case 301: {
                this.fPhrase = "Moved Permanently";
                break;
            }
        }
    }

    private void writeResponseHeader() {
        System.err.println("[========= HTTP RESPONSE HEADER ==========]");
        System.err.println("  HTTP/1.0 " + this.fStatusCode + " " + this.fPhrase);
        Enumeration enumeration = this.fHeaderLines.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.err.println("  " + string + ": " + String.valueOf(this.fHeaderLines.get(string)));
        }
        System.err.println("");
    }

    private void writeQueryHeader() {
        System.err.println("[=============== QUERIES =================]");
        Enumeration enumeration = this.fQueries.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.err.println("  " + string + ": " + String.valueOf(this.fQueries.get(string)));
        }
        System.err.println("");
    }
}

