/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.webservice;

import de.geocalc.webservice.BitFile;
import de.geocalc.webservice.LZWStringTable;
import java.io.IOException;
import java.io.OutputStream;

class LZWCompressor {
    LZWCompressor() {
    }

    public static void LZWCompress(OutputStream outputStream, int n, byte[] byArray) throws IOException {
        short s = -1;
        BitFile bitFile = new BitFile(outputStream);
        LZWStringTable lZWStringTable = new LZWStringTable();
        int n2 = 1 << n;
        int n3 = n2 + 1;
        int n4 = n + 1;
        int n5 = (1 << n4) - 1;
        lZWStringTable.ClearTable(n);
        bitFile.WriteBits(n2, n4);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            short s2 = lZWStringTable.FindCharString(s, by);
            if (s2 != -1) {
                s = s2;
                continue;
            }
            bitFile.WriteBits(s, n4);
            if (lZWStringTable.AddCharString(s, by) > n5) {
                if (++n4 > 12) {
                    bitFile.WriteBits(n2, n4 - 1);
                    lZWStringTable.ClearTable(n);
                    n4 = n + 1;
                }
                n5 = (1 << n4) - 1;
            }
            s = (short)((short)by & 0xFF);
        }
        if (s != -1) {
            bitFile.WriteBits(s, n4);
        }
        bitFile.WriteBits(n3, n4);
        bitFile.Flush();
    }
}

