/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.webservice;

import de.geocalc.webservice.HTTPConst;
import de.geocalc.webservice.HTTPRequestHandler;
import de.geocalc.webservice.Service;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class WebService
extends Thread {
    private String typ;
    private Service service;
    private int port;
    private ServerSocket serversocket;

    public WebService(String string, int n, Service service) {
        this.typ = string;
        this.port = n;
        this.service = service;
        this.start();
    }

    @Override
    public void run() {
        HTTPConst.fServerVerbose = true;
        try {
            this.serversocket = new ServerSocket(this.port);
            System.err.println("WebService is running on port " + Integer.toString(this.port) + ".");
            while (!this.isInterrupted()) {
                Socket socket = this.serversocket.accept();
                HTTPRequestHandler hTTPRequestHandler = new HTTPRequestHandler(socket, this.service);
                hTTPRequestHandler.start();
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public void close() throws IOException {
        if (this.serversocket != null) {
            this.serversocket.close();
            System.err.println("WebService is close");
            this.serversocket = null;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("WebService USAGE:");
            System.err.println("WebService <port>");
            System.exit(0);
        }
        int n = Integer.parseInt(stringArray[0]);
        WebService webService = new WebService("OGC:WMS", n, null);
    }
}

