/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.xml;

import de.geocalc.util.VoidEnumerator;
import de.geocalc.xml.Att;
import java.util.Enumeration;

public class Node {
    private String name;
    private Object value;
    private Node next;
    private Att att;

    public Node(String string) {
        this.name = string;
    }

    public Node(String string, String string2) {
        this.name = string;
        this.value = string2;
    }

    private void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(Object object) throws Exception {
        if (this.value != null) {
            throw new Exception("Unpossible to overwrite NodeValue");
        }
        this.value = object;
    }

    public Object getValue() {
        return this.value instanceof Node ? null : this.value;
    }

    public boolean hasValue() {
        return this.value != null && !(this.value instanceof Node);
    }

    public void addNode(Node node) throws Exception {
        if (this.value == null) {
            this.value = node;
        } else if (this.value instanceof Node) {
            Node node2 = (Node)this.value;
            while (node2.hasNext()) {
                node2 = node2.getNext();
            }
            node2.setNext(node);
        } else {
            throw new Exception(this.name);
        }
    }

    public boolean hasNodes() {
        return this.value instanceof Node;
    }

    public Enumeration elements() {
        if (this.value != null && this.value instanceof Node) {
            return new NodeEnumerator(this, (Node)this.value);
        }
        return new VoidEnumerator();
    }

    private Node getNext() {
        return this.next;
    }

    private void setNext(Node node) {
        this.next = node;
    }

    private boolean hasNext() {
        return this.next != null;
    }

    public void addAtt(Att att) {
        if (this.att == null) {
            this.att = att;
        } else {
            Att att2 = this.att;
            while (att2.hasNext()) {
                att2 = att2.getNext();
            }
            att2.setNext(att);
        }
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.name);
        if (this.att != null) {
            for (object = this.att; object != null; object = ((Att)object).getNext()) {
                stringBuffer.append(" ");
                stringBuffer.append(object);
            }
        }
        stringBuffer.append(">");
        if (this.value != null) {
            stringBuffer.append(this.value);
        }
        if (this.value instanceof Node) {
            object = (Node)this.value;
            while (((Node)object).hasNext()) {
                object = ((Node)object).getNext();
                stringBuffer.append(object);
            }
        }
        stringBuffer.append("</");
        stringBuffer.append(this.name);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private class NodeEnumerator
    implements Enumeration {
        Node akt = null;

        public NodeEnumerator(Node node, Node node2) {
            this.akt = node2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.akt != null;
        }

        public Object nextElement() {
            Node node = this.akt;
            this.akt = this.akt.getNext();
            return node;
        }
    }
}

