/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.xml.readopt;

import de.geocalc.util.VoidEnumerator;
import de.geocalc.xml.readopt.XMLParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XMLElement {
    private static final char MAX_TEST_IDENTIFIER = '\u0080';
    private static Hashtable entities = new Hashtable(10);
    private static final boolean[] identifiers = new boolean[128];
    private Hashtable attributes = null;
    private Vector children = null;
    private String name = null;
    private String contents = "";
    private String parseString;
    private int next = 0;

    public void addChild(XMLElement xMLElement) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(xMLElement);
    }

    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, object.toString());
    }

    public Enumeration enumerateChildren() {
        if (this.children == null) {
            return new VoidEnumerator();
        }
        return this.children.elements();
    }

    public int countChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public XMLElement getChildrenAt(int n) {
        return (XMLElement)this.children.elementAt(n);
    }

    public XMLElement getChildren(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf("/");
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        Enumeration enumeration = this.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement = (XMLElement)enumeration.nextElement();
            if (!xMLElement.getName().equals(string2)) continue;
            return string3 == null ? xMLElement : xMLElement.getChildren(string3);
        }
        return null;
    }

    public XMLElement getUChildren(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf("/");
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        Enumeration enumeration = this.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement = (XMLElement)enumeration.nextElement();
            if (!xMLElement.getUName().equals(string2)) continue;
            return string3 == null ? xMLElement : xMLElement.getUChildren(string3);
        }
        return null;
    }

    private void setContent(String string) {
        this.contents = string;
    }

    public String getContent() {
        return this.contents;
    }

    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public String getStringAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(string);
    }

    private void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getUName() {
        int n = this.name.indexOf(58);
        return n >= 0 ? this.name.substring(n + 1) : this.name;
    }

    public void parseString(String string) throws XMLParseException {
        this.name = null;
        this.contents = "";
        this.attributes = null;
        this.children = null;
        this.parseString = string;
        this.next = 0;
        while (true) {
            char c;
            if ((c = this.scanWhitespace()) != '<') {
                throw new XMLParseException(this.getName(), "'<' erwartet");
            }
            c = this.readChar();
            if (c != '!' && c != '?') break;
            this.skipSpecialTag(0);
        }
        --this.next;
        this.scanElement(this);
    }

    private void scanIdentifier(StringBuffer stringBuffer) throws XMLParseException {
        char c;
        while (((c = this.parseString.charAt(this.next++)) & 0x80) != 0 || identifiers[c]) {
            stringBuffer.append(c);
        }
        --this.next;
    }

    private char scanWhitespace() throws XMLParseException {
        char c;
        while ((c = this.parseString.charAt(this.next++)) == ' ') {
        }
        return c;
    }

    private char scanWhitespace(StringBuffer stringBuffer) throws XMLParseException {
        char c;
        block4: while (true) {
            c = this.parseString.charAt(this.next++);
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    stringBuffer.append(c);
                }
                case '\r': {
                    continue block4;
                }
            }
            break;
        }
        return c;
    }

    private void scanString(StringBuffer stringBuffer) throws XMLParseException {
        char c = this.readChar();
        if (c != '\'' && c != '\"') {
            throw new XMLParseException(this.getName(), "' oder \" erwartet");
        }
        char c2;
        while ((c2 = this.parseString.charAt(this.next++)) != c) {
            if (c2 == '&') {
                this.resolveEntity(stringBuffer);
                continue;
            }
            stringBuffer.append(c2);
        }
        return;
    }

    private void scanPCData(StringBuffer stringBuffer) throws XMLParseException {
        while (true) {
            char c;
            if ((c = this.parseString.charAt(this.next++)) == '<') {
                c = this.readChar();
                if (c == '!') {
                    this.checkCDATA(stringBuffer);
                    continue;
                }
                --this.next;
                return;
            }
            if (c == '&') {
                this.resolveEntity(stringBuffer);
                continue;
            }
            stringBuffer.append(c);
        }
    }

    private boolean checkCDATA(StringBuffer stringBuffer) throws XMLParseException {
        char c = this.readChar();
        if (c != '[') {
            --this.next;
            this.skipSpecialTag(0);
            return false;
        }
        if (!this.checkLiteral("CDATA[")) {
            this.skipSpecialTag(1);
            return false;
        }
        int n = 0;
        block4: while (n < 3) {
            int n2;
            c = this.readChar();
            switch (c) {
                case ']': {
                    if (n < 2) {
                        ++n;
                        continue block4;
                    }
                    stringBuffer.append(']');
                    stringBuffer.append(']');
                    n = 0;
                    continue block4;
                }
                case '>': {
                    if (n < 2) {
                        for (n2 = 0; n2 < n; ++n2) {
                            stringBuffer.append(']');
                        }
                        n = 0;
                        stringBuffer.append('>');
                        continue block4;
                    }
                    n = 3;
                    continue block4;
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(']');
            }
            stringBuffer.append(c);
            n = 0;
        }
        return true;
    }

    private void skipComment() throws XMLParseException {
        int n = 2;
        while (n > 0) {
            char c = this.readChar();
            if (c == '-') {
                --n;
                continue;
            }
            n = 2;
        }
        if (this.readChar() != '>') {
            throw new XMLParseException(this.getName(), "'>' erwartet");
        }
    }

    private void skipSpecialTag(int n) throws XMLParseException {
        char c;
        int n2 = 1;
        char c2 = '\u0000';
        if (n == 0) {
            c = this.readChar();
            if (c == '[') {
                ++n;
            } else if (c == '-') {
                c = this.readChar();
                if (c == '[') {
                    ++n;
                } else if (c == ']') {
                    --n;
                } else if (c == '-') {
                    this.skipComment();
                    return;
                }
            }
        }
        while (n2 > 0) {
            c = this.readChar();
            if (c2 == '\u0000') {
                if (c == '\"' || c == '\'') {
                    c2 = c;
                } else if (n <= 0) {
                    if (c == '<') {
                        ++n2;
                    } else if (c == '>') {
                        --n2;
                    }
                }
                if (c == '[') {
                    ++n;
                    continue;
                }
                if (c != ']') continue;
                --n;
                continue;
            }
            if (c != c2) continue;
            c2 = '\u0000';
        }
    }

    private boolean checkLiteral(String string) throws XMLParseException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (this.parseString.charAt(this.next++) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void scanElement(XMLElement xMLElement) throws XMLParseException {
        Object object;
        char c;
        String string;
        StringBuffer stringBuffer;
        block19: {
            stringBuffer = new StringBuffer(20);
            this.scanIdentifier(stringBuffer);
            string = stringBuffer.toString();
            xMLElement.setName(string);
            c = this.scanWhitespace();
            while (c != '>' && c != '/') {
                stringBuffer.setLength(0);
                --this.next;
                this.scanIdentifier(stringBuffer);
                object = stringBuffer.toString();
                c = this.scanWhitespace();
                if (c != '=') {
                    throw new XMLParseException(this.getName(), "'=' erwartet:" + String.valueOf(xMLElement));
                }
                this.scanWhitespace();
                --this.next;
                stringBuffer.setLength(0);
                this.scanString(stringBuffer);
                xMLElement.setAttribute((String)object, stringBuffer);
                c = this.scanWhitespace();
            }
            if (c == '/') {
                c = this.readChar();
                if (c != '>') {
                    throw new XMLParseException(this.getName(), "'>' erwartet");
                }
                return;
            }
            stringBuffer.setLength(0);
            c = this.scanWhitespace(stringBuffer);
            if (c != '<') {
                --this.next;
                this.scanPCData(stringBuffer);
            } else {
                while ((c = this.readChar()) == '!') {
                    if (this.checkCDATA(stringBuffer)) {
                        this.scanPCData(stringBuffer);
                    } else {
                        c = this.scanWhitespace(stringBuffer);
                        if (c == '<') continue;
                        --this.next;
                        this.scanPCData(stringBuffer);
                    }
                    break block19;
                }
                stringBuffer.setLength(0);
            }
        }
        if (stringBuffer.length() == 0) {
            while (c != '/') {
                if (c == '!') {
                    c = this.readChar();
                    if (c != '-') {
                        throw new XMLParseException(this.getName(), "Comment or Element erwartet");
                    }
                    c = this.readChar();
                    if (c != '-') {
                        throw new XMLParseException(this.getName(), "Comment or Element erwartet");
                    }
                    this.skipComment();
                } else {
                    --this.next;
                    object = new XMLElement();
                    this.scanElement((XMLElement)object);
                    xMLElement.addChild((XMLElement)object);
                }
                c = this.scanWhitespace();
                c = this.readChar();
            }
            --this.next;
        } else {
            xMLElement.setContent(stringBuffer.toString().trim());
        }
        c = this.readChar();
        if (c != '/') {
            throw new XMLParseException(this.getName(), "'/' erwartet");
        }
        this.scanWhitespace();
        --this.next;
        if (!this.checkLiteral(string)) {
            throw new XMLParseException(this.getName(), string + " erwartet");
        }
        if (this.scanWhitespace() != '>') {
            throw new XMLParseException(this.getName(), "'>' erwartet");
        }
    }

    private void resolveEntity(StringBuffer stringBuffer) throws XMLParseException {
        char c = '\u0000';
        StringBuffer stringBuffer2 = new StringBuffer(5);
        while ((c = this.readChar()) != ';') {
            stringBuffer2.append(c);
        }
        String string = stringBuffer2.toString();
        if (string.charAt(0) == '#') {
            try {
                c = string.charAt(1) == 'x' ? (char)Integer.parseInt(string.substring(2), 16) : (char)Integer.parseInt(string.substring(1), 10);
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLParseException(this.getName(), "Unbekanntes Entity &" + string + ";");
            }
            stringBuffer.append(c);
        } else {
            char[] cArray = (char[])entities.get(string);
            if (cArray == null) {
                throw new XMLParseException(this.getName(), "Unbekanntes Entity &" + string + ";");
            }
            stringBuffer.append(cArray);
        }
    }

    private char readChar() throws XMLParseException {
        try {
            return this.parseString.charAt(this.next++);
        }
        catch (Exception exception) {
            throw new XMLParseException(this.getName(), "Unerwartetes Ende der Daten");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.append(stringBuffer);
        return stringBuffer.toString();
    }

    private void append(StringBuffer stringBuffer) {
        Object object;
        Enumeration enumeration;
        if (this.name == null) {
            this.appendEncoded(stringBuffer, this.contents);
            return;
        }
        stringBuffer.append('<');
        stringBuffer.append(this.name);
        if (this.attributes != null && !this.attributes.isEmpty()) {
            enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(' ');
                object = (String)enumeration.nextElement();
                String string = (String)this.attributes.get(object);
                stringBuffer.append((String)object);
                stringBuffer.append('=');
                stringBuffer.append('\"');
                this.appendEncoded(stringBuffer, string);
                stringBuffer.append('\"');
            }
        }
        if (this.contents != null && this.contents.length() > 0) {
            stringBuffer.append('>');
            this.appendEncoded(stringBuffer, this.contents);
            stringBuffer.append('<');
            stringBuffer.append('/');
            stringBuffer.append(this.name);
            stringBuffer.append('>');
        } else if (this.countChildren() == 0) {
            stringBuffer.append('/');
            stringBuffer.append('>');
        } else {
            stringBuffer.append('>');
            enumeration = this.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                object = (XMLElement)enumeration.nextElement();
                ((XMLElement)object).append(stringBuffer);
            }
            stringBuffer.append('<');
            stringBuffer.append('/');
            stringBuffer.append(this.name);
            stringBuffer.append('>');
        }
    }

    private void appendEncoded(StringBuffer stringBuffer, String string) {
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    char c2 = c;
                    if (c2 < ' ' || c2 > '~') {
                        stringBuffer.append("&#x");
                        stringBuffer.append(Integer.toString(c2, 16));
                        stringBuffer.append(';');
                        continue block7;
                    }
                    stringBuffer.append(c);
                }
            }
        }
    }

    static {
        entities.put("amp", new char[]{'&'});
        entities.put("quot", new char[]{'\"'});
        entities.put("apos", new char[]{'\''});
        entities.put("lt", new char[]{'<'});
        entities.put("gt", new char[]{'>'});
        for (int i = 0; i < 128; ++i) {
            char c = (char)i;
            XMLElement.identifiers[i] = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_' || c == '.' || c == ':' || c == '-';
        }
    }
}

